/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.CIndenter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class CStringAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;
    private final ICProject fProject;

    private String displayString(String inputString, CharSequence indentation, String delimiter) {
        int length = inputString.length();
        StringBuilder buffer = new StringBuilder(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\r")) {
                buffer.append("\\r");
                if (!tokenizer.hasMoreTokens()) continue;
                token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    buffer.append("\\n");
                    buffer.append("\"" + delimiter);
                    buffer.append(indentation);
                    buffer.append("\"");
                    continue;
                }
                buffer.append("\"" + delimiter);
                buffer.append(indentation);
                buffer.append("\"");
            } else if (token.equals("\n")) {
                buffer.append("\\n");
                buffer.append("\"" + delimiter);
                buffer.append(indentation);
                buffer.append("\"");
                continue;
            }
            StringBuilder tokenBuffer = new StringBuilder();
            int i = 0;
            while (i < token.length()) {
                char c = token.charAt(i);
                switch (c) {
                    case '\r': {
                        tokenBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        tokenBuffer.append("\\n");
                        break;
                    }
                    case '\b': {
                        tokenBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        tokenBuffer.append("\t");
                        break;
                    }
                    case '\f': {
                        tokenBuffer.append("\\f");
                        break;
                    }
                    case '\"': {
                        tokenBuffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        tokenBuffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        tokenBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        tokenBuffer.append(c);
                    }
                }
                ++i;
            }
            buffer.append((CharSequence)tokenBuffer);
        }
        return buffer.toString();
    }

    public CStringAutoIndentStrategy(String partitioning, ICProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private String getModifiedText(String string, CharSequence indentation, String delimiter) {
        return this.displayString(string, indentation, delimiter);
    }

    private void indentStringAfterNewLine(IDocument document, DocumentCommand command) throws BadLocationException {
        int length;
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)true);
        int offset = partition.getOffset();
        if (command.offset == offset + (length = partition.getLength()) && document.getChar(offset + length - 1) == '\"') {
            return;
        }
        if (offset > 0 && document.getChar(offset - 1) == 'R') {
            return;
        }
        CHeuristicScanner scanner = new CHeuristicScanner(document);
        CIndenter indenter = new CIndenter(document, scanner, this.fProject);
        StringBuilder indentation = indenter.computeContinuationLineIndentation(offset);
        if (indentation == null) {
            indentation = new StringBuilder();
        }
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IPreferenceStore preferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        if (this.isLineDelimiter(document, command.text)) {
            command.text = "\"" + command.text + indentation + "\"";
        } else if (command.text.length() > 1 && preferenceStore.getBoolean("escapeStrings")) {
            command.text = this.getModifiedText(command.text, indentation, delimiter);
        }
    }

    private boolean isSmartMode() {
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null) {
            IEditorPart part = page.getActiveEditor();
            if (part instanceof MultiPageEditorPart) {
                part = (IEditorPart)part.getAdapter(ITextEditorExtension3.class);
            }
            if (part instanceof ITextEditorExtension3) {
                ITextEditorExtension3 extension = (ITextEditorExtension3)part;
                return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            if (command.length != 0 || command.text == null) {
                return;
            }
            IPreferenceStore preferenceStore = CUIPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("wrapStrings") && this.isSmartMode()) {
                this.indentStringAfterNewLine(document, command);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

