/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public class SelectionProviderMediator
implements ISelectionProvider {
    private Map<Control, ISelectionProvider> fProviders = new HashMap<Control, ISelectionProvider>();
    private ISelectionProvider fActiveProvider = null;
    private ISelectionChangedListener fSelectionChangedListener;
    private FocusListener fFocusListener;
    private ListenerList fListenerList = new ListenerList();

    public SelectionProviderMediator() {
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectionProviderMediator.this.onSelectionChanged(event);
            }
        };
        this.fFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                SelectionProviderMediator.this.onFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
            }
        };
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected final void fireSelectionChanged() {
        Object[] listeners = this.fListenerList.getListeners();
        if (listeners.length > 0) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }

    public void addViewer(Viewer viewer) {
        this.addSelectionProvider(viewer.getControl(), (ISelectionProvider)viewer);
    }

    public void addSelectionProvider(Control ctrl, ISelectionProvider sp) {
        this.fProviders.put(ctrl, sp);
        sp.addSelectionChangedListener(this.fSelectionChangedListener);
        ctrl.addFocusListener(this.fFocusListener);
    }

    public ISelection getSelection() {
        if (this.fActiveProvider != null) {
            return this.fActiveProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.fActiveProvider != null) {
            this.fActiveProvider.setSelection(selection);
        }
    }

    protected void onFocusGained(FocusEvent e) {
        ISelectionProvider provider = this.fProviders.get(e.widget);
        if (provider != null) {
            this.fActiveProvider = provider;
            this.fireSelectionChanged();
        }
    }

    protected void onSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.fActiveProvider) {
            this.fireSelectionChanged();
        }
    }
}

