/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateCategory;
import org.eclipse.cdt.core.templateengine.TemplateEngine2;
import org.eclipse.cdt.core.templateengine.TemplateInfo2;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;
import org.eclipse.cdt.ui.wizards.ProjectTypePage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TemplateSelectionPage
extends WizardPage {
    private static Node tree;
    private final TemplateEngine2 coreEngine = TemplateEngine2.getDefault();
    private final TemplateEngineUI uiEngine = TemplateEngineUI.getDefault();
    private TreeViewer templateTree;
    private Template selectedTemplate;
    private IWizardPage nextPage;

    public TemplateSelectionPage() {
        super("templateSelection");
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.templateTree = new TreeViewer(comp);
        this.templateTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.templateTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Node) {
                    return !((Node)element).getChildren().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof Node) {
                    return ((Node)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Node) {
                    return ((Node)inputElement).getChildren().toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Node) {
                    return ((Node)parentElement).getChildren().toArray();
                }
                return null;
            }
        });
        this.templateTree.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof Node) {
                    Object object = ((Node)element).getObject();
                    if (object instanceof TemplateCategory) {
                        return ((TemplateCategory)object).getLabel();
                    }
                    if (object instanceof Template) {
                        return ((Template)((Object)object)).getLabel();
                    }
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.templateTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TemplateSelectionPage.this.selectedTemplate = null;
                TemplateSelectionPage.this.nextPage = null;
                IStructuredSelection selection = (IStructuredSelection)TemplateSelectionPage.this.templateTree.getSelection();
                Object selObj = selection.getFirstElement();
                if (selObj instanceof Node) {
                    Object object = ((Node)selObj).getObject();
                    if (object instanceof Template) {
                        String projectType;
                        ProjectTypePage projectTypePage;
                        IWizard wizard = TemplateSelectionPage.this.getWizard();
                        TemplateSelectionPage.this.selectedTemplate = (Template)((Object)object);
                        IWizardPage[] templatePages = TemplateSelectionPage.this.selectedTemplate.getTemplateWizardPages((IWizardPage)TemplateSelectionPage.this, wizard.getNextPage((IWizardPage)TemplateSelectionPage.this), wizard);
                        if (templatePages != null && templatePages.length > 0) {
                            TemplateSelectionPage.this.nextPage = templatePages[0];
                        }
                        if ((projectTypePage = TemplateSelectionPage.this.getProjectTypePage(projectType = TemplateSelectionPage.this.selectedTemplate.getTemplateInfo().getProjectType())) != null && projectTypePage.init(TemplateSelectionPage.this.selectedTemplate, wizard, TemplateSelectionPage.this.nextPage)) {
                            TemplateSelectionPage.this.nextPage = projectTypePage;
                        }
                        TemplateSelectionPage.this.setPageComplete(true);
                    } else {
                        TemplateSelectionPage.this.setPageComplete(false);
                    }
                } else {
                    TemplateSelectionPage.this.setPageComplete(false);
                }
            }
        });
        this.buildTree();
        this.templateTree.setInput((Object)tree);
        this.setControl((Control)comp);
    }

    public Template getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public boolean isPageComplete() {
        return this.selectedTemplate != null;
    }

    public IWizardPage getNextPage() {
        if (this.nextPage != null) {
            return this.nextPage;
        }
        return super.getNextPage();
    }

    private void buildTree() {
        Template[] templates;
        if (tree != null) {
            return;
        }
        tree = new Node(null, null);
        Template[] templateArray = templates = this.uiEngine.getTemplates();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            List parentCategoryIds = ((TemplateInfo2)template.getTemplateInfo()).getParentCategoryIds();
            boolean inTree = false;
            if (!parentCategoryIds.isEmpty()) {
                for (String parentCategoryId : parentCategoryIds) {
                    List<Node> parents = this.getParents(parentCategoryId);
                    if (parents.isEmpty()) continue;
                    for (Node parent : parents) {
                        new Node(parent, (Object)template);
                    }
                    inTree = true;
                }
            }
            if (!inTree) {
                new Node(tree, (Object)template);
            }
            ++n2;
        }
    }

    private List<Node> getParents(String parentCategoryId) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        TemplateCategory category = this.coreEngine.getCategory(parentCategoryId);
        if (category == null) {
            CUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.ui", "Undefined parent category " + parentCategoryId));
            return nodes;
        }
        List parentCategoryIds = category.getParentCategoryIds();
        boolean inTree = false;
        if (!parentCategoryIds.isEmpty()) {
            for (String myParentId : parentCategoryIds) {
                List<Node> parents = this.getParents(myParentId);
                if (parents.isEmpty()) continue;
                for (Node parent : parents) {
                    Node node = parent.getChild(category);
                    if (node == null) {
                        nodes.add(new Node(parent, category));
                        continue;
                    }
                    nodes.add(node);
                }
                inTree = true;
            }
        }
        if (!inTree) {
            Node node = tree.getChild(category);
            if (node == null) {
                nodes.add(new Node(tree, category));
            } else {
                nodes.add(node);
            }
        }
        return nodes;
    }

    private ProjectTypePage getProjectTypePage(String projectType) {
        if (projectType != null && !projectType.isEmpty()) {
            IExtension[] exts;
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint point = reg.getExtensionPoint("org.eclipse.cdt.ui", "projectTypePages");
            if (point == null) {
                return null;
            }
            IExtension[] iExtensionArray = exts = point.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = ext.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ept;
                    IConfigurationElement elem = iConfigurationElementArray[n4];
                    if (elem.getName().equals("projectTypePage") && projectType.equals(ept = elem.getAttribute("projectType"))) {
                        try {
                            Object obj = elem.createExecutableExtension("class");
                            if (obj instanceof ProjectTypePage) {
                                return (ProjectTypePage)obj;
                            }
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e.getStatus());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static class Node {
        private final Object object;
        private final Node parent;
        private final List<Node> children = new LinkedList<Node>();

        public Node(Node parent, Object object) {
            this.parent = parent;
            this.object = object;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        private void addChild(Node child) {
            this.children.add(child);
        }

        public Node getChild(Object child) {
            for (Node childNode : this.children) {
                if (!childNode.getObject().equals(child)) continue;
                return childNode;
            }
            return null;
        }

        public Object getObject() {
            return this.object;
        }

        public Node getParent() {
            return this.parent;
        }

        public List<Node> getChildren() {
            return this.children;
        }
    }
}

