/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersHideShowManager;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class STDataViewersHideShowColumnsDialog
extends Dialog {
    private boolean dirty = false;
    private STDataViewersHideShowManager manager;
    private CheckboxTableViewer checkButtonsTable;
    private AbstractSTViewer stViewer;
    private ICheckStateListener checkStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            STDataViewersHideShowColumnsDialog.this.dirty = true;
        }
    };

    public STDataViewersHideShowColumnsDialog(AbstractSTViewer stViewer) {
        super(stViewer.getViewer().getControl().getShell());
        this.stViewer = stViewer;
        this.manager = stViewer.getHideShowManager();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(STDataViewersMessages.hideshowDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(4, 4, false, false, 2, 1);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, true);
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        layoutData = new GridData(4, 4, true, false, 2, 1);
        this.checkButtonsTable = this.createCheckboxTable(composite, layoutData);
        this.checkButtonsTable.setInput((Object)this.stViewer.getColumns());
        this.checkButtonsTable.addCheckStateListener(this.checkStateListener);
        Button selectAllButton = new Button(composite, 0);
        selectAllButton.setText(STDataViewersMessages.selectAll_text);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                STDataViewersHideShowColumnsDialog.this.dirty = true;
                STDataViewersHideShowColumnsDialog.this.checkButtonsTable.setAllChecked(true);
            }
        });
        layoutData = new GridData(4, 128, false, false, 1, 1);
        selectAllButton.setLayoutData((Object)layoutData);
        Button deselectAllButton = new Button(composite, 0);
        deselectAllButton.setText(STDataViewersMessages.deselectAll_text);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                STDataViewersHideShowColumnsDialog.this.dirty = true;
                STDataViewersHideShowColumnsDialog.this.checkButtonsTable.setAllChecked(false);
            }
        });
        layoutData = new GridData(4, 128, false, false, 1, 1);
        deselectAllButton.setLayoutData((Object)layoutData);
        this.createSeparatorLine(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setDefaultWidgetsValues();
        return composite;
    }

    private void setDefaultWidgetsValues() {
        Item[] columns = this.stViewer.getColumns();
        int i = columns.length;
        while (i-- > 0) {
            boolean state = this.manager.getState(i) == 1;
            this.checkButtonsTable.setChecked((Object)columns[i], state);
        }
    }

    protected void createSeparatorLine(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        Label separator = new Label(parent, 258);
        GridData layoutData = new GridData(4, 4, true, true, parentLayout.numColumns, 1);
        separator.setLayoutData((Object)layoutData);
    }

    private CheckboxTableViewer createCheckboxTable(Composite parent, GridData layoutData) {
        CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)35588);
        tableViewer.getControl().setLayoutData((Object)layoutData);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Item[]) {
                    Item[] columns = (Item[])inputElement;
                    int[] order = STDataViewersHideShowColumnsDialog.this.stViewer.getColumnOrder();
                    Object[] elements = new Item[columns.length];
                    int i = columns.length;
                    while (i-- > 0) {
                        elements[i] = columns[order[i]];
                    }
                    return elements;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Item) {
                    Item column = (Item)element;
                    if (STDataViewersHideShowColumnsDialog.this.manager.getWidth(STDataViewersHideShowColumnsDialog.this.stViewer.getColumnIndex(column)) == 0) {
                        return String.valueOf(column.getText()) + " (width = 0)";
                    }
                    return column.getText();
                }
                return element.toString();
            }
        });
        return tableViewer;
    }

    public int open() {
        this.dirty = false;
        return super.open();
    }

    protected void okPressed() {
        if (this.dirty) {
            this.saveManagerSettings();
        }
        super.okPressed();
    }

    private void saveManagerSettings() {
        Item[] columns = this.stViewer.getColumns();
        int i = columns.length;
        while (i-- > 0) {
            int state = this.checkButtonsTable.getChecked((Object)columns[i]) ? 1 : 0;
            this.manager.setState(i, state);
        }
    }

    public STDataViewersHideShowManager getManager() {
        return this.manager;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

