/*
 * memtest.cpp
 * name: Ying Han
 * student number: 200010907
 *
 * purpose: memory manager tester
 *
 * usage:
 * 	memtest test.bat [-ff|-bf|-wf]
 */
 
#include <iostream>
#include <fstream>
#include <string>

#include "mm.h"

using namespace std;


/********************************************************************
 * Func: main()
 * Purpose:	memory manager tester
 *******************************************************************/
int main(int argc, char *argv[])
{
	MMMonitor mm;
	MMType type = FF;
	int pid;
	int size;
	char buff[20];
	char * ptrS;
	ifstream memReq;
	if(argc > 1)
	{
		memReq.open(argv[1], ifstream::in);
		if(!memReq.good())
		{
			cerr << "can't find file.\n";
			return -1;
		}
	}
	if(argc > 2)
	{
		if(strcmp(argv[2], "-bf") == 0)
		{
			type = BF;
		}
		else if(strcmp(argv[2], "-wf") == 0)
		{
			type = WF;
		}
	}
	mm.setType(type);
	
	
	while(!memReq.eof())
	{
		memReq.getline(buff, 20);
		if(strcmp(buff, "dump") == 0)
		{
			cout << "\n";
			mm.dump();
		}
		else
		{
			if(ptrS = strtok(buff, " "))
			{
				if(ptrS[0] == '+')
				{
					pid = atoi(strtok(NULL, " \n"));
					size = atoi(strtok(NULL, " \n"));
					cout << "allocate[" << pid << "]: " << size << " -> ";
					if(mm.allocate(pid, size))
					{
						cout << "SUCCESSED\n";
					}
					else
					{
						cout << "FAILED\n";
					}
				}
				else if(ptrS[0] == '-')
				{
					pid = atoi(strtok(NULL, " \n"));
					cout << "release[" << pid << "] -> ";
					if(mm.release(pid))
					{
						cout << "SUCCESSED\n";
					}
					else
					{
						cout << "FAILED\n";
					}
				}
			}
		}
	}
	
	
	return 0;
}
