/*
 * mm.cpp
 * name: Ying Han
 * student number: 200010907
 *
 * purpose: memory manager monitor 
 */
 
#include <sys/time.h>

#include "mm.h"


/********************************************************************
 * Func: allocate()
 * Purpose: allocates memory (monitor method)
 *******************************************************************/
bool MMMonitor::allocate(int pid, int size)
{
	pthread_mutex_lock(&_mutex);
	
	bool memAllocated = false;
	
	ostringstream strout;
	// start time
	struct timeval ts, te;
	gettimeofday(&ts, NULL);
	if(memAllocated = memPlacement(pid, size))
	{
		// end time, record stats
		gettimeofday(&te, NULL);
		strout << te.tv_sec - ts.tv_sec << "," << te.tv_usec - ts.tv_usec;
		_statOut << strout.str() << "\n";
		
		_memused += size;
		
	}
	
	pthread_mutex_unlock(&_mutex);
	return memAllocated;
}


/********************************************************************
 * Func: release()
 * Purpose: release memory (monitor method)
 *******************************************************************/
int MMMonitor::release(int pid)
{
	pthread_mutex_lock(&_mutex);
	int freeSize = 0;
	int tmpStart;
	int tmpSize;
	list<BlockType>::iterator i;
	for(i = _mem.begin(); i != _mem.end(); ++i)
	{
		if(i->pid == pid)
		{
			i->pid = HOLE;
			_memused -= i->size;
			freeSize = i->size;
			
			// coalesence:
			// check prev block, assume user never free first block
			--i;
			if(i->pid == HOLE)
			{
				tmpStart = i->start;
				tmpSize = i->size;			
				i = _mem.erase(i);
				i->start = tmpStart;
				i->size += tmpSize;
			}
			else
			{
				// return to current position when prev block is not free
				++i;
			}
			
			// check next block
			++i;
			if(i != _mem.end() && i->pid == HOLE)
			{
				--i;
				tmpStart = i->start;
				tmpSize = i->size;
				i = _mem.erase(i);
				i->start = tmpStart;
				i->size += tmpSize;
			}
		}
	}
		
	pthread_mutex_unlock(&_mutex);
	return freeSize;
}


/********************************************************************
 * Func: makeBlock()
 * Purpose: allocate memory(size) from the block of free memory(i)
 *******************************************************************/
void MMMonitor::makeBlock(list<BlockType>::iterator i, int pid, int size)
{
	BlockType newBlock;
	if(i->size > size)
	{
		newBlock.pid = pid;
		newBlock.start = i->start;
		newBlock.size = size;
		i->start += size;
		i->size -= size;
		_mem.insert(i, newBlock);
	}
	else if(i->size == size)
	{
		i->pid = pid;
	}
}


/********************************************************************
 * Func: memPlacement()
 * Purpose: memory placement algorithm(FF, BF, WF)
 *******************************************************************/
bool MMMonitor::memPlacement(int pid, int size)
{
	bool foundHole = false;
	list<BlockType>::iterator h;
	list<BlockType>::iterator i;
	for(i = _mem.begin(); i != _mem.end(); ++i)
	{
		if(i->pid == HOLE && i->size >= size)
		{
			if(foundHole)
			{
				if(_mmtype == WF && h->size < i->size)
				{
					// worst fit
					h = i;
				}
				else if(_mmtype == BF && h->size > i->size)
				{
					// best fit
					h = i;
				}
			}
			else
			{
				foundHole = true;
				h = i;
				if(_mmtype == FF)
				{
					// first fit
					break;
				}
			}	
		}
	}
	if(foundHole)
	{
		makeBlock(h, pid, size);
	}
	return foundHole;

}


/********************************************************************
 * Func: setType()
 * Purpose: set the memory placement algorithm
 *******************************************************************/
void MMMonitor::setType(MMType type)
{
	_mmtype = type;
}


/********************************************************************
 * Func: logStats()
 * Purpose: write the current memory stats into a file(csv)
 *******************************************************************/
void MMMonitor::logStats(ofstream & ofs)
{
	ostringstream strout;
	int fragCount = 0;
	int freeMem = 0;
	list<BlockType>::iterator i;
	for(i = _mem.begin(); i != _mem.end(); ++i)
	{
		if(i->pid == HOLE)
		{
			fragCount++;
			freeMem += i->size;
			strout << i->size << ",";
		}
	}
	ofs << fragCount << "," << freeMem << "," << strout.str() <<"\n";
}


/********************************************************************
 * Func: dump()
 * Purpose: output the current memory layout
 *******************************************************************/
void MMMonitor::dump()
{
	int freeMem = 0;
	int fragCount = 0;
	cout << "mem dump start:\n";
	list<BlockType>::iterator i;
	for(i = _mem.begin(); i != _mem.end(); ++i)
	{
		cout << "[";
		if(i->pid == HOLE)
		{
			freeMem += i->size;
			fragCount++;
			cout << "H";
		}
		else
		{
			cout << i->pid;
		}
		cout << "|" << i->start << "|" << i->size << "]->";
	}
	cout << "END\n";
	cout << "free space: " << freeMem << " frag:" << fragCount << "\n\n";
}


/********************************************************************
 * Func: memFree()
 * Purpose: return current free memory size(mb)
 *******************************************************************/
int MMMonitor::memFree()
{
	return _memsize - _memused;	
}
