/*
 * mm.h
 * name: Ying Han
 * student number: 200010907
 *
 * purpose: memory manager monitor 
 */
 
#ifndef _MM_H_
#define _MM_H_

#include <pthread.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <list>
using namespace std;

typedef enum { HOLE = -1 } HoleType;
typedef enum { FF, BF, WF } MMType;	// memory placement algorithm 
struct BlockType
{
	int pid;
	int start;
	int size;
};


class MMMonitor
{
	public:
		// monitor methods:
		bool allocate(int pid, int size);
		int release(int pid);
		// end of monitor methods
	
		MMMonitor(int size = 1024)
		{
			pthread_mutex_init(&_mutex, NULL);
			_mmtype = FF;
			_memsize = size;
			_memused = 0;
			BlockType block;
			block.pid = -1;
			block.start = 0;
			block.size = size;
			_mem.push_back(block);
			_statOut.open("stat.csv", ifstream::out);
		}
		~MMMonitor()
		{
			pthread_mutex_destroy(&_mutex);
		}
		// sim/stats related methods:
		void setType(MMType type);		
		void logStats(ofstream & ofs);
		void dump();
		int memFree();

		
	private:
		// helper
		void makeBlock(list<BlockType>::iterator i, int pid, int size);
		bool memPlacement(int pid, int size);
	
		// data
		pthread_mutex_t _mutex;
		MMType _mmtype;	
		int _memsize;		// in mb
		int _memused;		// in mb
		list<BlockType> _mem;
	
		ofstream _statOut;	// stats
		
};


#endif
