/*
 * sim.cpp
 * name: Ying Han
 * student number: 200010907
 */

#include <pthread.h>
#include <iostream>
#include <fstream>
#include <list>

#include "types.h"
#include "mm.h"

using namespace std;

// proc interval (min)
int gPIMin = 1;
int gPIMax = 10;
int gPITick = 1;
// proc cpu time (min)
int gCPUMin = 5;
int gCPUMax = 60;
int gCPUTick = 5;
// proc size (mb)
int gPSMin = 50;
int gPSMax = 300;
int gPSTick = 10;


long int gTime = 0;				// sim timer
long int gEndTime = 2000;		// sim end time (mins)
list<ProcType> gPlist;			// proc list
MMMonitor gMM;					// memory manager


long int genRandomNum(long int min, long int max, long int tick)
{
	long int intervals = (max - min) / tick + 1;
	long int num = (rand() % intervals) * tick + min;
	if(num < min || num > max)
	{
		cerr << "genRandomNum() out of bound error\n";
	}
	return num;
}


void dumpProcList()
{
	// dump proc list:
	int numProcs = 0;
	int numCompletedProcs = 0;
	int numSuspendedProcs = 0;
	int numWaitingProcs = 0;
	int numRunningProcs = 0;
	
	char proc_state;
	ofstream procOut("proc.csv");
	procOut << "pid,size,state,create_time,run_time,end_time,cpu_time,duration,mem_free\n";
	list<ProcType>::iterator i;
	for(i = gPlist.begin(); i != gPlist.end(); ++i)
	{
		switch(i->state)
		{
			case WAIT:
				proc_state = 'W';
				numWaitingProcs++;
				break;
			case RUN:
				proc_state = 'R';
				numRunningProcs++;
				break;
			case SUSPEND:
				proc_state = 'S';
				numSuspendedProcs++;
				break;
			case END:
				proc_state = 'E';
				numCompletedProcs++;
				break;
		}
		numProcs++;
		
		procOut << i->pid << "," << i->size << "," << proc_state << ",";
		procOut << i->create_time << "," << i->run_time << "," << i->end_time << ",";
		procOut << i->cpu_time << "," << i->duration << "," << i->memFree << "\n";	
	}
	
	procOut << numProcs << "," << numCompletedProcs << "," << numRunningProcs << ",";
	procOut << numSuspendedProcs << ", " << numWaitingProcs << "\n";
}

void updateProc()
{
	list<ProcType>::iterator i;
	for(i = gPlist.begin(); i != gPlist.end(); ++i)
	{
		if(i->state == RUN)
		{
			i->duration++;
			if(i->duration >= i->cpu_time)
			{
				i->state = END;
				i->end_time = gTime;
			}
		}
	}
}

// running proc
void *Proc(void *arg)
{
	pthread_t thread_id = pthread_self();
	list<ProcType>::iterator i;
	while(1)
	{
		for(i = gPlist.begin(); i != gPlist.end(); ++i)
		{	
			if(i->pid == (int)arg && i->state == END)
			{
				gMM.release(i->pid);
				return arg;
			}
		}
		sched_yield();
	}
	return arg;
}

// long term scheduler
void *LTScheduler(void *arg)
{
	int status;
	pthread_t thread_id;
	
	bool stopSched = false;
	list<ProcType>::iterator i;
	int proc_id = 1;
	ProcType proc;
	proc.create_time = 0;
	while(gTime < gEndTime)
	{
		if(proc.create_time <= gTime && proc.create_time > 0)
		{
			// put proc into the LS 
			gPlist.push_back(proc);	// add proc to proc list
			proc.create_time = 0;	// reset the create time
			
			/*
			// schedule proc into cpu 
			if(gMM.allocate(proc.pid, proc.size))
			{
				proc.state = RUN;
				proc.run_time = gTime;
				gPlist.push_back(proc);
				
				// reset the create time
				proc.create_time = 0;
				
				// create the thread(simulate proc)
				status = pthread_create(&thread_id, NULL, Proc, (void*)(proc.pid));
				if(status != 0)
				{
					cerr << "Error creating thread:" << proc.pid << "\n";
					return arg;
				}
			}
			*/
			
		}
		
		if(proc.create_time == 0)
		{
			// generate a new proc
			proc.pid = proc_id;
			proc.size = genRandomNum(gPSMin, 
									gPSMax,
									gPSTick);
			proc.state = WAIT;
			proc.create_time = gTime + genRandomNum(gPIMin, 
													gPIMax,
													gPITick);
			proc.cpu_time = genRandomNum(gCPUMin,
										gCPUMax,
										gCPUTick);
			proc.end_time = 0;
			proc.duration = 0;
			
			proc_id++;
		}
		
		// schedule the proc in LS into CPU
		for(i = gPlist.begin(); (i != gPlist.end()); ++i)
		{	
			if(i->state == WAIT && i->create_time <= gTime )
			{
				i->memFree = gMM.memFree();	// log the amount of free mem
				if(gMM.allocate(i->pid, i->size))
				{
					i->state = RUN;
					i->run_time = gTime;
					
					// create the thread(simulate proc)
					status = pthread_create(&thread_id, NULL, Proc, (void*)(i->pid));
					if(status != 0)
					{
						cerr << "Error creating thread:" << i->pid << "\n";
						return arg;
					}
				}
				else
				{
					break;	// first come first serve
				}
			}
		}
			
		sched_yield();
	}
	
	return arg;
}


int main(int argc, char *argv[])
{
	bool dumpMem = false;
	MMType type = FF;
	// get arguments
	if(argc > 9)
	{
		gPIMin = atoi(argv[1]);
		gPIMax = atoi(argv[2]);
		gPITick = atoi(argv[3]);
		
		gPSMin = atoi(argv[4]);
		gPSMax = atoi(argv[5]);
		gPSTick = atoi(argv[6]);
		
		gCPUMin = atoi(argv[7]);
		gCPUMax = atoi(argv[8]);
		gCPUTick = atoi(argv[9]);
		
		cout << "I[" << gPIMin << "," << gPIMax << "," << gPITick << "] ";
		cout << "S[" << gPSMin << "," << gPSMax << "," << gPSTick << "] ";
		cout << "C[" << gCPUMin << "," << gCPUMax << "," << gCPUTick << "]\n";
	}
	if(argc > 10)
	{
		if(strcmp(argv[10], "-bf") == 0)
		{
			type = BF;
		}
		else if(strcmp(argv[10], "-wf") == 0)
		{
			type = WF;
		}
	}
	if(argc > 11)
	{
		if(strcmp(argv[11], "-md") == 0)
		{
			dumpMem = true;
		}
	}
	gMM.setType(type);
	
	int status;
	pthread_t thread_id;
	// create the long term scheduler 
	status = pthread_create(&thread_id, NULL, LTScheduler, NULL);
	if(status != 0)
	{
		cerr << "Error creating LTScheduler\n";
		return 1;
	}
	
	ofstream memOut("mem.csv");
	// simulation loop
	gMM.allocate(0, 300);	// 300mb for OS
	while(gTime < gEndTime)
	{
		gTime++;
		// update running proc's duration
		updateProc();
		
		// suspensions 
		
		// mem stats
		gMM.logStats(memOut);
		if(dumpMem)
		{
			gMM.dump();
		}
		
		sched_yield();
	}
	
	// wait for the long term scheduler to exit
	pthread_join(thread_id, NULL);
	
	dumpProcList();
	
	return 0;
}
