## R has many built in data-sets that are useful for examples.
##
## E.g., 1997 Motor Trends cars:
mtcars

## make data-set for grouped barplot
counts <- table(mtcars$vs, mtcars$gear)
rownames(counts) <- c('V', 'Straight')

barplot(counts,
        beside=TRUE,
        main='Car Distribution by Gears and Engine Type',
        xlab='Number of Gears',
        col=c('darkblue','red'),
        legend=rownames(counts),
        las=1)

## without the 'beside argument'
barplot(counts,
        main='Car Distribution by Gears and Engine Type',
        xlab='Number of Gears',
        col=c('darkblue','red'),
        legend=rownames(counts),
        las=1)
