/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jode.AssertError;
import jode.GlobalOptions;
import jode.decompiler.Declarable;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.Options;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.expr.LocalVarOperator;
import jode.type.Type;

public class LocalInfo
implements Declarable {
    private static int serialnr = 0;
    private static int nextAnonymousSlot = -1;
    private int slot;
    private MethodAnalyzer methodAnalyzer;
    private boolean nameIsGenerated = false;
    private boolean isUnique;
    private String name = null;
    private Type type;
    private LocalInfo shadow;
    private Vector operators = new Vector();
    private Vector hints = new Vector();
    private boolean removed = false;
    private boolean isFinal = false;
    private Expression constExpr = null;
    private int loopCount = 0;

    public static void init() {
        serialnr = 0;
    }

    public void setOperator(LocalVarOperator localVarOperator) {
        this.getLocalInfo().operators.addElement(localVarOperator);
    }

    public void addHint(String string, Type type) {
        this.getLocalInfo().hints.addElement(new Hint(string, type));
    }

    public int getUseCount() {
        return this.getLocalInfo().operators.size();
    }

    public void combineWith(LocalInfo localInfo) {
        LocalVarOperator localVarOperator;
        if (this.shadow != null) {
            this.getLocalInfo().combineWith(localInfo);
            return;
        }
        if (this == (localInfo = localInfo.getLocalInfo())) {
            return;
        }
        this.shadow = localInfo;
        if (!this.nameIsGenerated) {
            localInfo.name = this.name;
        }
        if (this.constExpr != null) {
            if (localInfo.constExpr != null) {
                throw new AssertError("local has multiple constExpr");
            }
            localInfo.constExpr = this.constExpr;
        }
        localInfo.setType(this.type);
        boolean bl = !localInfo.type.equals(this.type);
        Enumeration enumeration = this.operators.elements();
        while (enumeration.hasMoreElements()) {
            localVarOperator = (LocalVarOperator)enumeration.nextElement();
            if (bl) {
                if ((GlobalOptions.debuggingFlags & 4) != 0) {
                    GlobalOptions.err.println("updating " + localVarOperator);
                }
                localVarOperator.updateType();
            }
            localInfo.operators.addElement(localVarOperator);
        }
        enumeration = this.hints.elements();
        while (enumeration.hasMoreElements()) {
            localVarOperator = enumeration.nextElement();
            if (localInfo.hints.contains(localVarOperator)) continue;
            localInfo.hints.addElement(localVarOperator);
        }
        this.type = null;
        this.name = null;
        this.operators = null;
    }

    public LocalInfo getLocalInfo() {
        if (this.shadow != null) {
            while (this.shadow.shadow != null) {
                this.shadow = this.shadow.shadow;
            }
            return this.shadow;
        }
        return this;
    }

    public boolean hasName() {
        return this.getLocalInfo().name != null;
    }

    public String guessName() {
        if (this.shadow != null) {
            while (this.shadow.shadow != null) {
                this.shadow = this.shadow.shadow;
            }
            return this.shadow.guessName();
        }
        if (this.name == null) {
            Enumeration enumeration = this.hints.elements();
            while (enumeration.hasMoreElements()) {
                Hint hint = (Hint)enumeration.nextElement();
                if (!this.type.isOfType(hint.getType())) continue;
                this.name = hint.getName();
                this.setType(hint.getType());
                return this.name;
            }
            this.nameIsGenerated = true;
            if ((GlobalOptions.debuggingFlags & 4) != 0) {
                GlobalOptions.err.println(this.getName() + " set type to getHint()");
            }
            this.setType(this.type.getHint());
            if ((Options.options & 0x10) != 0) {
                this.name = this.type.getDefaultName();
            } else {
                this.name = this.type.getDefaultName() + (this.slot >= 0 ? "_" + this.slot : "") + "_" + serialnr++ + "_";
                this.isUnique = true;
            }
            if ((GlobalOptions.debuggingFlags & 0x100) != 0) {
                GlobalOptions.err.println("Guessed name: " + this.name + " from type: " + this.type);
                Thread.dumpStack();
            }
        }
        return this.name;
    }

    public String getName() {
        if (this.shadow != null) {
            while (this.shadow.shadow != null) {
                this.shadow = this.shadow.shadow;
            }
            return this.shadow.getName();
        }
        if (this.name == null) {
            return "local_" + this.slot + "_" + Integer.toHexString(this.hashCode());
        }
        return this.name;
    }

    public boolean isNameGenerated() {
        return this.getLocalInfo().nameIsGenerated;
    }

    public int getSlot() {
        return this.getLocalInfo().slot;
    }

    public void setName(String string) {
        LocalInfo localInfo = this.getLocalInfo();
        localInfo.name = string;
    }

    public void makeNameUnique() {
        LocalInfo localInfo = this.getLocalInfo();
        String string = localInfo.getName();
        if (!localInfo.isUnique) {
            localInfo.name = string + "_" + serialnr++ + "_";
            localInfo.isUnique = true;
        }
    }

    public Type getType() {
        return this.getLocalInfo().type;
    }

    public Type setType(Type type) {
        Type type2;
        LocalInfo localInfo = this.getLocalInfo();
        if (localInfo.loopCount++ > 5) {
            GlobalOptions.err.println("Type error in local " + this.getName() + ": " + localInfo.type + " seems to be recursive.");
            Thread.dumpStack();
            type = Type.tError;
        }
        if ((type2 = localInfo.type.intersection(type)) == Type.tError && type != Type.tError && localInfo.type != Type.tError) {
            GlobalOptions.err.println("Type error in local " + this.getName() + ": " + localInfo.type + " and " + type);
            Thread.dumpStack();
        } else if ((GlobalOptions.debuggingFlags & 4) != 0) {
            GlobalOptions.err.println(this.getName() + " setType, new: " + type2 + " old: " + localInfo.type);
        }
        if (!localInfo.type.equals(type2)) {
            localInfo.type = type2;
            Enumeration enumeration = localInfo.operators.elements();
            while (enumeration.hasMoreElements()) {
                LocalVarOperator localVarOperator = (LocalVarOperator)enumeration.nextElement();
                if ((GlobalOptions.debuggingFlags & 4) != 0) {
                    GlobalOptions.err.println("updating " + localVarOperator);
                }
                localVarOperator.updateType();
            }
        }
        --localInfo.loopCount;
        return localInfo.type;
    }

    public void setExpression(Expression expression) {
        this.setType(expression.getType());
        this.getLocalInfo().constExpr = expression;
    }

    public Expression getExpression() {
        return this.getLocalInfo().constExpr;
    }

    public boolean isShadow() {
        return this.shadow != null;
    }

    public boolean equals(Object object) {
        return object instanceof LocalInfo && ((LocalInfo)object).getLocalInfo() == this.getLocalInfo();
    }

    public void remove() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isConstant() {
        return true;
    }

    public MethodAnalyzer getMethodAnalyzer() {
        return this.methodAnalyzer;
    }

    public boolean markFinal() {
        LocalInfo localInfo = this.getLocalInfo();
        Enumeration enumeration = localInfo.operators.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (!((LocalVarOperator)enumeration.nextElement()).isWrite()) continue;
            ++n;
        }
        localInfo.isFinal = true;
        return true;
    }

    public boolean isFinal() {
        return this.getLocalInfo().isFinal;
    }

    public String toString() {
        return this.getName();
    }

    public void dumpDeclaration(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        LocalInfo localInfo = this.getLocalInfo();
        if (localInfo.isFinal) {
            tabbedPrintWriter.print("final ");
        }
        tabbedPrintWriter.printType(localInfo.getType().getHint());
        tabbedPrintWriter.print(" " + localInfo.getName().toString());
    }

    public LocalInfo() {
        this.type = Type.tUnknown;
        this.slot = nextAnonymousSlot--;
    }

    public LocalInfo(MethodAnalyzer methodAnalyzer, int n) {
        this.type = Type.tUnknown;
        this.methodAnalyzer = methodAnalyzer;
        this.slot = n;
    }

    static class Hint {
        String name;
        Type type;

        public final Type getType() {
            return this.type;
        }

        public final String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object instanceof Hint) {
                Hint hint = (Hint)object;
                return this.name.equals(hint.name) && this.type.equals(hint.type);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.type.hashCode();
        }

        public Hint(String string, Type type) {
            this.name = string;
            this.type = type;
        }
    }
}

