/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.net;

import com.cycling74.max.Atom;
import com.cycling74.max.Callback;
import com.cycling74.max.MaxSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class TcpReceiver
implements Runnable {
    private int port;
    private ServerSocket recvSocket;
    private Thread listener = null;
    private String debugString = "TcpReceiver";
    private Callback callback = null;
    private boolean shouldRun = true;

    public TcpReceiver(int port, Object toCallIn, String methodName) {
        this.setCallback(toCallIn, methodName);
        if (port != 0) {
            this.setPort(port);
        }
    }

    public TcpReceiver() {
        this(0, null, null);
    }

    public TcpReceiver(int port) {
        this(port, null, null);
    }

    private void setListener(boolean b) {
        if (b) {
            if (this.listener == null && this.initRecvSocket()) {
                this.listener = new Thread(this);
                this.listener.start();
            }
        } else {
            if (this.recvSocket != null) {
                try {
                    this.recvSocket.close();
                }
                catch (IOException ie) {
                    MaxSystem.error(this.debugString + ": io exception: " + ie);
                }
            }
            this.listener = null;
        }
    }

    private boolean initRecvSocket() {
        if (this.port != 0) {
            try {
                this.recvSocket = new ServerSocket(this.port);
                return true;
            }
            catch (BindException be) {
                MaxSystem.error(this.debugString + ": there is already an object " + "bound to port " + this.port);
            }
            catch (SocketException se) {
                MaxSystem.error(this.debugString + ": socket exception: " + se);
            }
            catch (IOException ie) {
                MaxSystem.error(this.debugString + ": io exception: " + ie);
            }
        }
        return false;
    }

    private void resetListener() {
        new Thread(){

            public void run() {
                TcpReceiver.this.setListener(false);
                TcpReceiver.this.setListener(true);
            }
        }.start();
    }

    public void setActive(boolean b) {
        if (b) {
            new Thread(){

                public void run() {
                    TcpReceiver.this.setListener(true);
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    TcpReceiver.this.setListener(false);
                }
            }.start();
        }
    }

    public void setDebugString(String debugString) {
        this.debugString = debugString;
    }

    public void setPort(int port) {
        if (port != this.port) {
            this.port = port;
            this.resetListener();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void close() {
        this.shouldRun = false;
        if (this.listener != null) {
            try {
                this.recvSocket.close();
            }
            catch (IOException ie) {
                MaxSystem.error(this.debugString + ": io exception: " + ie);
            }
        }
    }

    public void run() {
        block3: while (this.shouldRun) {
            try {
                this.recvSocket.setSoTimeout(50);
                Socket socket = this.recvSocket.accept();
                BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                while (this.shouldRun) {
                    String msg = input.readLine();
                    if (msg == null) {
                        input.close();
                        continue block3;
                    }
                    if (this.callback == null) continue;
                    this.callback.setArgs(new Object[]{Atom.parse(msg)});
                    this.callback.execute();
                }
            }
            catch (SocketTimeoutException se) {
            }
            catch (IOException ie) {
                return;
            }
        }
    }

    public void setCallback(Object toCallIn, String methodName) {
        if (toCallIn != null && methodName != null) {
            this.callback = new Callback(toCallIn, methodName, new Object[]{new Atom[0]});
        }
    }
}

