function [basisobj, quadpts, quadwts] = quadset(nquad, basisobj)

%  Set up quadrature points and weights for Simpson's rule
%  and store information in basisobj

rangeval = getbasisrange(basisobj);
params   = getbasispar(basisobj);
knots = [rangeval(1), params, rangeval(2)];

breaks  = unique(knots);
nbreaks = length(breaks);

quadpts1 = [linspace(breaks(1),breaks(2),nquad)'];
quadwts1 = ones(nquad,1);
quadwts1(2:2:nquad-1) = 4;
quadwts1(3:2:nquad-2) = 2;
quadwts1 = ((breaks(2)-breaks(1))/(nquad-1)).*quadwts1/3;
quadvals = [quadpts1, quadwts1];

for i=3:nbreaks
    quadptsi = [linspace(breaks(i-1),breaks(i),nquad)'];
    quadwtsi = ones(nquad,1);
    quadwtsi(3:2:nquad-2) = 2;
    quadwtsi(2:2:nquad-1) = 4;
    quadwtsi = ((breaks(i)-breaks(i-1))/(nquad-1)).*quadwtsi/3;
    quadvals = [quadvals;[quadptsi, quadwtsi]];
end
quadpts = quadvals(:,1);
quadwts = quadvals(:,2);

basisobj = putquadvals(basisobj, quadvals);

clear values
for ivalue=1:2
    basisvalues    = eval_basis(quadpts, basisobj, ivalue-1);
    values{ivalue} = basisvalues;
end

basisobj = putvalues(basisobj, values);

