import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class Caden_space_invader extends PApplet {


Player spaceship;

ArrayList<Enemy> enemies = new ArrayList<Enemy>();

int numEnemy = 15;
int score;
public void setup() {
  

  score = 0;

  spaceship = new Player (800, 800);

  for (int i = 0; i < numEnemy; i++) {
    enemies.add(new Enemy((int)random(0, width), (int)random(-200, 0)));
  }
}

public void draw() {
  background(255, 0, 9);

  if (spaceship.lives == 0) {
    fill(3, 59, 255);
    rect(0, 0, width, height);
    fill(255, 0, 0);
    text("GAME OVER", width / 2, height / 2);
    noLoop();
  }

  spaceship.update();

  for (int i = 0; i < enemies.size(); i++) {
    Enemy e = enemies.get(i);
    e.update();
  }

  if (enemies.size() < numEnemy) {
    respawn();
  }

  text("Lives: " + spaceship.lives, 50, 50);
  text("Score:" + score, 50, 70 );
}

public void keyPressed() {
  if (key == ' ') {
    spaceship.fire();
  }
}

public void respawn() {
  enemies.add(new Enemy((int)random(0, width), (int)random(-200, 0)));
}

class Bullet {
  
  int x;
  int y;
  int bWidth;
  int bHeight;

  Bullet(int xPos, int yPos) {
    this.x = xPos;
    this.y = yPos;
    this.bWidth = 25;
    this.bHeight = 25;
    
  }
  
  public void update() {
    draw();
    move();
  }
  
  public void draw() {
    fill(155, 155, 155);
    ellipse(x, y, bWidth, bHeight);
  }

  public void move() {
    y = y - 5;
  }
  public boolean hit(Enemy e) {
    return abs(x - e.x) < (bWidth + e.eWidth)/2 && abs(y - e.y) < (bHeight + e.eHeight)/3;
  }
  
}
class Enemy {  
  int x;
  int y;
  int eHeight;
  int eWidth;

  Enemy(int xPos, int yPos) {
    this.x = xPos;
    this.y = yPos;
    this.eWidth = 50;
    this.eHeight = 50;
  }

  public void draw() {
    fill(143, 97, 252);
    rect(x, y, eWidth, eHeight);
  }

public void update() {
  draw();
  move();
}

  public void move() {
    y = y + 8;

    if (y > height) {
      y = (int)random(-2000, -1000);
      x = (int)random(0, width - 50);
      
    }
  }
}
class Player {

  int x;
  int y;
  int pWidth;
  int pHeight;
  int lives;

  ArrayList<Bullet> bullets = new ArrayList<Bullet>();
  Player(int xPos, int yPos) {
    this.x = xPos;
    this.y = yPos;
    this.pWidth = 100;
    this.pHeight = 100;
    this.lives = 3;
  }

  public void fire() {
    bullets. add(new Bullet(x + 50, y));
  }

  public void hit() {
    for (int i = 0; i < enemies.size(); i++) {
      Enemy e = enemies.get(i);
      if (abs(x - e.x) < ( pWidth + e.eWidth)/2 && abs(y - e.y) < (pHeight + e.eHeight)/2) {
        enemies.remove(i);
        lives--;
      }
    }
  }

  public void update() {
    draw();
    move();
    hit();

    for (int i = 0; i < bullets.size(); i ++) {
      Bullet b = bullets.get(i);
      b.update();

      if (b.y < 0) {
        bullets.remove(this);
      }

      for (int j = 0; j < enemies.size(); j++) {
        Enemy e = enemies.get(j);
        if (b.hit(e)) {
          enemies.remove(j);
          bullets.remove(i);
          score++;
        }
      }
    }
  }
  

  
  public void draw() {
    fill(111, 211, 6);
    rect(x, y, pWidth, pHeight);
  }

  public void move() {
    if (keyPressed) {
      if (keyCode == LEFT) {
        x = x - 15;
      }


      if (keyCode == RIGHT) {
        x = x + 15;
      }
    }
  }
}
  public void settings() {  size(1000, 900); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Caden_space_invader" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
