/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;

public class Gurik_Space_Invaders
extends PApplet {
    Player spaceship;
    ArrayList<Enemy> enemies = new ArrayList();
    int numEnemy = 30;
    int score;

    public void setup() {
        this.score = 0;
        this.spaceship = new Player(250, 400);
        int i = 0;
        while (i < this.numEnemy) {
            ++i;
        }
    }

    public void draw() {
        this.background(219.0f, 0.0f, 26.0f);
        if (this.spaceship.lives == 0) {
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.fill(219);
            this.text("Game Over", this.width / 2, this.height / 2);
            this.noLoop();
        }
        this.spaceship.update();
        int i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            e.update();
            ++i;
        }
        if (this.enemies.size() < this.numEnemy) {
            this.respawn();
        }
        this.text("Lives: " + this.spaceship.lives, 50.0f, 50.0f);
        this.text("Score:" + this.score, 50.0f, 100.0f);
    }

    public void keyPressed() {
        if (this.key == ' ') {
            this.spaceship.fire();
        }
    }

    public void respawn() {
        this.enemies.add(new Enemy((int)this.random(0.0f, this.width), (int)this.random(-200.0f, 0.0f)));
    }

    public void settings() {
        this.size(500, 500);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Gurik_Space_Invaders"};
        if (passedArgs != null) {
            PApplet.main((String[])Gurik_Space_Invaders.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Bullet {
        int x;
        int y;
        int bHeight;
        int bWidth;

        Bullet(int xPos, int yPos) {
            this.x = xPos;
            this.y = yPos;
            this.bWidth = 20;
            this.bHeight = 20;
        }

        public void update() {
            this.draw();
            this.move();
        }

        public void draw() {
            Gurik_Space_Invaders.this.fill(0);
            Gurik_Space_Invaders.this.ellipse(this.x, this.y, this.bWidth, this.bHeight);
        }

        public void move() {
            this.y -= 5;
        }

        public boolean hit(Enemy e) {
            return Gurik_Space_Invaders.abs((int)(this.x - e.x)) < (this.bWidth + e.eWidth) / 2 && Gurik_Space_Invaders.abs((int)(this.y - e.y)) < (this.bHeight + e.eHeight) / 2;
        }
    }

    class Enemy {
        int x;
        int y;
        int eWidth;
        int eHeight;

        Enemy(int xPos, int yPos) {
            this.x = xPos;
            this.y = yPos;
            this.eWidth = 20;
            this.eHeight = 20;
        }

        public void update() {
            this.draw();
            this.move();
        }

        public void draw() {
            Gurik_Space_Invaders.this.fill(52.0f, 164.0f, 183.0f);
            Gurik_Space_Invaders.this.rect(this.x, this.y, this.eWidth, this.eHeight);
        }

        public void move() {
            this.y += 5;
            if (this.y > Gurik_Space_Invaders.this.height) {
                this.y = (int)Gurik_Space_Invaders.this.random(-200.0f, -50.0f);
                this.x = (int)Gurik_Space_Invaders.this.random(0.0f, Gurik_Space_Invaders.this.width - 50);
            }
        }
    }

    class Player {
        int x;
        int y;
        int pWidth;
        int pHeight;
        int lives;
        ArrayList<Bullet> bullets = new ArrayList();

        Player(int xPos, int yPos) {
            this.x = xPos;
            this.y = yPos;
            this.pWidth = 30;
            this.pHeight = 30;
            this.lives = 3;
        }

        public void fire() {
            this.bullets.add(new Bullet(this.x + 15, this.y));
        }

        public void hit() {
            int i = 0;
            while (i < Gurik_Space_Invaders.this.enemies.size()) {
                Enemy e = Gurik_Space_Invaders.this.enemies.get(i);
                if (Gurik_Space_Invaders.abs((int)(this.x - e.x)) < (this.pWidth + e.eWidth) / 2 && Gurik_Space_Invaders.abs((int)(this.y - e.y)) < (this.pHeight + e.eHeight) / 2) {
                    Gurik_Space_Invaders.this.enemies.remove(i);
                    --this.lives;
                }
                ++i;
            }
        }

        public void update() {
            this.draw();
            this.move();
            this.hit();
            int i = 0;
            while (i < this.bullets.size()) {
                Bullet b = this.bullets.get(i);
                b.update();
                if (b.y < 0) {
                    this.bullets.remove(i);
                }
                int j = 0;
                while (j < Gurik_Space_Invaders.this.enemies.size()) {
                    Enemy e = Gurik_Space_Invaders.this.enemies.get(j);
                    if (b.hit(e)) {
                        Gurik_Space_Invaders.this.enemies.remove(j);
                        this.bullets.remove(i);
                        ++Gurik_Space_Invaders.this.score;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void draw() {
            Gurik_Space_Invaders.this.fill(0);
            Gurik_Space_Invaders.this.rect(this.x, this.y, this.pWidth, this.pHeight);
        }

        public void move() {
            if (Gurik_Space_Invaders.this.keyPressed) {
                if (Gurik_Space_Invaders.this.keyCode == 37) {
                    this.x -= 5;
                }
                if (Gurik_Space_Invaders.this.keyCode == 39) {
                    this.x += 5;
                }
            }
        }
    }
}

