/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import jogamp.graph.geom.plane.AffineTransform;

public class Triangle {
    private final Vertex[] vertices = new Vertex[3];
    private final boolean[] boundaryEdges = new boolean[3];
    private boolean[] boundaryVertices = null;
    private int id;

    public Triangle(Vertex vertex, Vertex vertex2, Vertex vertex3, boolean[] blArray) {
        this.id = Integer.MAX_VALUE;
        this.vertices[0] = vertex;
        this.vertices[1] = vertex2;
        this.vertices[2] = vertex3;
        this.boundaryVertices = blArray;
    }

    public Triangle(Triangle triangle) {
        this.id = triangle.id;
        this.vertices[0] = triangle.vertices[0].clone();
        this.vertices[1] = triangle.vertices[1].clone();
        this.vertices[2] = triangle.vertices[2].clone();
        System.arraycopy(triangle.boundaryEdges, 0, this.boundaryEdges, 0, 3);
        this.boundaryVertices = new boolean[3];
        System.arraycopy(triangle.boundaryVertices, 0, this.boundaryVertices, 0, 3);
    }

    private Triangle(int n, boolean[] blArray, boolean[] blArray2) {
        this.id = n;
        System.arraycopy(blArray, 0, this.boundaryEdges, 0, 3);
        this.boundaryVertices = new boolean[3];
        System.arraycopy(blArray2, 0, this.boundaryVertices, 0, 3);
    }

    public Triangle transform(AffineTransform affineTransform, Vertex.Factory<? extends Vertex> factory) {
        Triangle triangle = new Triangle(this.id, this.boundaryEdges, this.boundaryVertices);
        triangle.vertices[0] = affineTransform.transform(this.vertices[0], factory.create());
        triangle.vertices[1] = affineTransform.transform(this.vertices[1], factory.create());
        triangle.vertices[2] = affineTransform.transform(this.vertices[2], factory.create());
        return triangle;
    }

    public final boolean isOnCurve() {
        return this.vertices[0].isOnCurve() && this.vertices[1].isOnCurve() && this.vertices[2].isOnCurve();
    }

    public final boolean isLine() {
        return VectorUtil.isVec2Zero(this.vertices[0].getTexCoord(), 0) && VectorUtil.isVec2Zero(this.vertices[1].getTexCoord(), 0) && VectorUtil.isVec2Zero(this.vertices[2].getTexCoord(), 0);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public boolean isEdgesBoundary() {
        return this.boundaryEdges[0] || this.boundaryEdges[1] || this.boundaryEdges[2];
    }

    public boolean isVerticesBoundary() {
        return this.boundaryVertices[0] || this.boundaryVertices[1] || this.boundaryVertices[2];
    }

    public boolean[] getEdgeBoundary() {
        return this.boundaryEdges;
    }

    public boolean[] getVerticesBoundary() {
        return this.boundaryVertices;
    }

    public void setVerticesBoundary(boolean[] blArray) {
        this.boundaryVertices = blArray;
    }

    public String toString() {
        return "Tri ID: " + this.id + ", onCurve " + this.isOnCurve() + "\n\t" + this.vertices[0] + ", bound " + this.boundaryVertices[0] + "\n\t" + this.vertices[1] + ", bound " + this.boundaryVertices[1] + "\n\t" + this.vertices[2] + ", bound " + this.boundaryVertices[2];
    }
}

