/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;

public class Gurshaan_s_space_invaders
extends PApplet {
    Player spaceship;
    ArrayList<Enemy> enemies = new ArrayList();
    int numEnemy = 10;
    int score;

    public void setup() {
        this.score = 0;
        this.spaceship = new Player(800, 800);
        int i = 0;
        while (i < this.numEnemy) {
            this.enemies.add(new Enemy((int)this.random(0.0f, this.width), (int)this.random(-200.0f, 0.0f)));
            ++i;
        }
    }

    public void draw() {
        this.background(10.0f, 26.0f, 193.0f);
        if (this.spaceship.lives == 0) {
            this.fill(0);
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.fill(255);
            this.text(" Game Over ", this.width / 2, this.height / 2);
            this.noLoop();
        }
        this.spaceship.update();
        int i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            e.update();
            ++i;
        }
        if (this.enemies.size() < this.numEnemy) {
            this.respawn();
        }
        this.text("Lives " + this.spaceship.lives, 50.0f, 50.0f);
        this.text("Score " + this.score, 50.0f, 100.0f);
    }

    public void respawn() {
        this.enemies.add(new Enemy((int)this.random(0.0f, this.width), (int)this.random(-200.0f, 0.0f)));
    }

    public void keyPressed() {
        if (this.key == ' ') {
            this.spaceship.fire();
        }
    }

    public void settings() {
        this.size(1000, 1000);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Gurshaan_s_space_invaders"};
        if (passedArgs != null) {
            PApplet.main((String[])Gurshaan_s_space_invaders.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Bullet {
        int x;
        int y;
        int bWidth;
        int bHeight;

        Bullet(int xPos, int yPos) {
            this.x = xPos;
            this.y = yPos;
            this.bWidth = 25;
            this.bHeight = 25;
        }

        public void update() {
            this.draw();
            this.move();
        }

        public void draw() {
            Gurshaan_s_space_invaders.this.fill(0.0f, 0.0f, 0.0f);
            Gurshaan_s_space_invaders.this.ellipse(this.x, this.y, this.bWidth, this.bHeight);
        }

        public void move() {
            this.y -= 5;
        }

        public boolean hit(Enemy e) {
            return Gurshaan_s_space_invaders.abs((int)(this.x - e.x)) < (this.bWidth + e.eWidth) / 2 && Gurshaan_s_space_invaders.abs((int)(this.y - e.y)) < (this.bHeight + e.eHeight) / 2;
        }
    }

    class Enemy {
        int x;
        int y;
        int eWidth;
        int eHeight;

        Enemy(int xPos, int yPos) {
            this.x = xPos;
            this.y = yPos;
            this.eWidth = 50;
            this.eHeight = 50;
        }

        public void update() {
            this.draw();
            this.move();
        }

        public void draw() {
            Gurshaan_s_space_invaders.this.fill(7.0f, 240.0f, 43.0f);
            Gurshaan_s_space_invaders.this.rect(this.x, this.y, this.eWidth, this.eHeight);
        }

        public void move() {
            this.y += 3;
            if (this.y > Gurshaan_s_space_invaders.this.height) {
                this.y = (int)Gurshaan_s_space_invaders.this.random(-200.0f, -50.0f);
                this.x = (int)Gurshaan_s_space_invaders.this.random(0.0f, Gurshaan_s_space_invaders.this.width - 50);
            }
        }
    }

    class Player {
        int x;
        int y;
        int pWidth;
        int pHeight;
        int lives;
        ArrayList<Bullet> bullets = new ArrayList();

        Player(int xPos, int yPos) {
            this.x = xPos;
            this.y = yPos;
            this.pWidth = 50;
            this.pHeight = 50;
            this.lives = 3;
        }

        public void fire() {
            this.bullets.add(new Bullet(this.x + 25, this.y));
        }

        public void hit() {
            int i = 0;
            while (i < Gurshaan_s_space_invaders.this.enemies.size()) {
                Enemy e = Gurshaan_s_space_invaders.this.enemies.get(i);
                if (Gurshaan_s_space_invaders.abs((int)(this.x - e.x)) < (this.pWidth + e.eWidth) / 2 && Gurshaan_s_space_invaders.abs((int)(this.y - e.y)) < (this.pHeight + e.eHeight) / 2) {
                    Gurshaan_s_space_invaders.this.enemies.remove(i);
                    --this.lives;
                }
                ++i;
            }
        }

        public void update() {
            this.draw();
            this.move();
            this.hit();
            int i = 0;
            while (i < this.bullets.size()) {
                Bullet b = this.bullets.get(i);
                b.update();
                if (b.y < 0) {
                    this.bullets.remove(i);
                }
                int j = 0;
                while (j < Gurshaan_s_space_invaders.this.enemies.size()) {
                    Enemy e = Gurshaan_s_space_invaders.this.enemies.get(j);
                    if (b.hit(e)) {
                        Gurshaan_s_space_invaders.this.enemies.remove(j);
                        this.bullets.remove(i);
                        ++Gurshaan_s_space_invaders.this.score;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void draw() {
            Gurshaan_s_space_invaders.this.fill(240.0f, 7.0f, 54.0f);
            Gurshaan_s_space_invaders.this.rect(this.x, this.y, this.pWidth, this.pHeight);
        }

        public void move() {
            if (Gurshaan_s_space_invaders.this.keyPressed) {
                if (Gurshaan_s_space_invaders.this.keyCode == 37) {
                    this.x -= 10;
                }
                if (Gurshaan_s_space_invaders.this.keyCode == 39) {
                    this.x += 10;
                }
            }
        }
    }
}

