/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import com.apple.laf.ClientPropertyApplicator;
import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.CGraphicsDevice;
import sun.awt.CausedFocusEvent;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLSurfaceData;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CPrinterDialogPeer;
import sun.lwawt.macosx.CThreading;
import sun.lwawt.macosx.CViewPlatformEmbeddedFrame;
import sun.lwawt.macosx.CWrapper;
import sun.lwawt.macosx.LWCToolkit;
import sun.util.logging.PlatformLogger;

public class CPlatformWindow
extends CFRetainedResource
implements PlatformWindow {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.lwawt.macosx.CPlatformWindow");
    private static final PlatformLogger focusLogger = PlatformLogger.getLogger("sun.lwawt.macosx.focus.CPlatformWindow");
    public static final String WINDOW_BRUSH_METAL_LOOK = "apple.awt.brushMetalLook";
    public static final String WINDOW_DRAGGABLE_BACKGROUND = "apple.awt.draggableWindowBackground";
    public static final String WINDOW_ALPHA = "Window.alpha";
    public static final String WINDOW_SHADOW = "Window.shadow";
    public static final String WINDOW_STYLE = "Window.style";
    public static final String WINDOW_SHADOW_REVALIDATE_NOW = "apple.awt.windowShadow.revalidateNow";
    public static final String WINDOW_DOCUMENT_MODIFIED = "Window.documentModified";
    public static final String WINDOW_DOCUMENT_FILE = "Window.documentFile";
    public static final String WINDOW_CLOSEABLE = "Window.closeable";
    public static final String WINDOW_MINIMIZABLE = "Window.minimizable";
    public static final String WINDOW_ZOOMABLE = "Window.zoomable";
    public static final String WINDOW_HIDES_ON_DEACTIVATE = "Window.hidesOnDeactivate";
    public static final String WINDOW_DOC_MODAL_SHEET = "apple.awt.documentModalSheet";
    public static final String WINDOW_FADE_DELEGATE = "apple.awt._windowFadeDelegate";
    public static final String WINDOW_FADE_IN = "apple.awt._windowFadeIn";
    public static final String WINDOW_FADE_OUT = "apple.awt._windowFadeOut";
    public static final String WINDOW_FULLSCREENABLE = "apple.awt.fullscreenable";
    static final int MODELESS = 0;
    static final int DOCUMENT_MODAL = 1;
    static final int APPLICATION_MODAL = 2;
    static final int TOOLKIT_MODAL = 3;
    static final int _RESERVED_FOR_DATA = 1;
    static final int DECORATED = 2;
    static final int TEXTURED = 4;
    static final int UNIFIED = 8;
    static final int UTILITY = 16;
    static final int HUD = 32;
    static final int SHEET = 64;
    static final int CLOSEABLE = 128;
    static final int MINIMIZABLE = 256;
    static final int RESIZABLE = 512;
    static final int NONACTIVATING = 0x1000000;
    static final int IS_DIALOG = 0x2000000;
    static final int IS_MODAL = 0x4000000;
    static final int IS_POPUP = 0x8000000;
    static final int _STYLE_PROP_BITMASK = 1022;
    static final int HAS_SHADOW = 1024;
    static final int ZOOMABLE = 2048;
    static final int ALWAYS_ON_TOP = 32768;
    static final int HIDES_ON_DEACTIVATE = 131072;
    static final int DRAGGABLE_BACKGROUND = 524288;
    static final int DOCUMENT_MODIFIED = 0x200000;
    static final int FULLSCREENABLE = 0x800000;
    static final int _METHOD_PROP_BITMASK = 11177472;
    static final int SHOULD_BECOME_KEY = 4096;
    static final int SHOULD_BECOME_MAIN = 8192;
    static final int MODAL_EXCLUDED = 65536;
    static final int _CALLBACK_PROP_BITMASK = 77824;
    static ClientPropertyApplicator<JRootPane, CPlatformWindow> CLIENT_PROPERTY_APPLICATOR = new ClientPropertyApplicator<JRootPane, CPlatformWindow>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<CPlatformWindow>("Window.documentModified"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(0x200000, object == null ? false : Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.brushMetalLook"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(4, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.alpha"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            AWTUtilities.setWindowOpacity(cPlatformWindow.target, object == null ? 1.0f : Float.parseFloat(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.shadow"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(1024, object == null ? true : Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.minimizable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(256, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.closeable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(128, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.zoomable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(2048, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.fullscreenable"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.setStyleBits(0x800000, Boolean.parseBoolean(object.toString()));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("apple.awt.windowShadow.revalidateNow"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            cPlatformWindow.execute(l -> CPlatformWindow.nativeRevalidateNSWindowShadow(l));
        }
    }, new ClientPropertyApplicator.Property<CPlatformWindow>("Window.documentFile"){

        @Override
        public void applyProperty(CPlatformWindow cPlatformWindow, Object object) {
            if (object == null || !(object instanceof File)) {
                cPlatformWindow.execute(l -> CPlatformWindow.nativeSetNSWindowRepresentedFilename(l, null));
                return;
            }
            String string = ((File)object).getAbsolutePath();
            cPlatformWindow.execute(l -> CPlatformWindow.nativeSetNSWindowRepresentedFilename(l, string));
        }
    }}){

        @Override
        public CPlatformWindow convertJComponentToTarget(JRootPane jRootPane) {
            Component component = SwingUtilities.getRoot(jRootPane);
            if (component == null || (LWWindowPeer)component.getPeer() == null) {
                return null;
            }
            return (CPlatformWindow)((LWWindowPeer)component.getPeer()).getPlatformWindow();
        }
    };
    private Rectangle nativeBounds = new Rectangle(0, 0, 0, 0);
    private volatile boolean isFullScreenMode;
    private boolean isFullScreenAnimationOn;
    private volatile boolean isIconifyAnimationActive;
    private Window target;
    private LWWindowPeer peer;
    protected CPlatformView contentView;
    protected CPlatformWindow owner;
    protected boolean visible = false;
    private boolean undecorated;
    private Rectangle normalBounds = null;
    private CPlatformResponder responder;

    private native long nativeCreateNSWindow(long var1, long var3, long var5, double var7, double var9, double var11, double var13);

    private static native void nativeSetNSWindowStyleBits(long var0, int var2, int var3);

    private static native void nativeSetNSWindowMenuBar(long var0, long var2);

    private static native Insets nativeGetNSWindowInsets(long var0);

    private static native void nativeSetNSWindowBounds(long var0, double var2, double var4, double var6, double var8);

    private static native void nativeSetNSWindowMinMax(long var0, double var2, double var4, double var6, double var8);

    private static native void nativePushNSWindowToBack(long var0);

    private static native void nativePushNSWindowToFront(long var0);

    private static native void nativeSetNSWindowTitle(long var0, String var2);

    private static native void nativeRevalidateNSWindowShadow(long var0);

    private static native void nativeSetNSWindowMinimizedIcon(long var0, long var2);

    private static native void nativeSetNSWindowRepresentedFilename(long var0, String var2);

    private static native void nativeSetEnabled(long var0, boolean var2);

    private static native void nativeSynthesizeMouseEnteredExitedEvents();

    private static native void nativeDispose(long var0);

    private static native void nativeEnterFullScreenMode(long var0);

    private static native void nativeExitFullScreenMode(long var0);

    static native CPlatformWindow nativeGetTopmostPlatformWindowUnderMouse();

    static int SET(int n, int n2, boolean bl) {
        if (bl) {
            return n | n2;
        }
        return n & ~n2;
    }

    static boolean IS(int n, int n2) {
        return (n & n2) != 0;
    }

    public CPlatformWindow() {
        super(0L, true);
    }

    @Override
    public void initialize(Window window, LWWindowPeer lWWindowPeer, PlatformWindow platformWindow) {
        JRootPane jRootPane;
        this.initializeBase(window, lWWindowPeer, platformWindow, new CPlatformView());
        int n = this.getInitialStyleBits();
        this.responder = this.createPlatformResponder();
        this.contentView = this.createContentView();
        this.contentView.initialize(this.peer, this.responder);
        Rectangle rectangle = !CPlatformWindow.IS(2, n) ? new Rectangle(0, 0, 1, 1) : lWWindowPeer.constrainBounds(window.getBounds());
        AtomicLong atomicLong = new AtomicLong();
        this.contentView.execute(l -> {
            if (this.owner != null) {
                this.owner.execute(l2 -> atomicLong.set(this.nativeCreateNSWindow(l, l2, n, rectangle.x, rectangle.y, rectangle.width, rectangle.height)));
            } else {
                atomicLong.set(this.nativeCreateNSWindow(l, 0L, n, rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            }
        });
        this.setPtr(atomicLong.get());
        if (this.target instanceof RootPaneContainer && (jRootPane = ((RootPaneContainer)((Object)this.target)).getRootPane()) != null) {
            jRootPane.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CLIENT_PROPERTY_APPLICATOR.attachAndApplyClientProperties(jRootPane);
                    jRootPane.removePropertyChangeListener("ancestor", this);
                }
            });
        }
        this.validateSurface();
    }

    protected void initializeBase(Window window, LWWindowPeer lWWindowPeer, PlatformWindow platformWindow, CPlatformView cPlatformView) {
        this.peer = lWWindowPeer;
        this.target = window;
        if (platformWindow instanceof CPlatformWindow) {
            this.owner = (CPlatformWindow)platformWindow;
        }
        this.contentView = cPlatformView;
    }

    protected CPlatformResponder createPlatformResponder() {
        return new CPlatformResponder(this.peer, false);
    }

    protected CPlatformView createContentView() {
        return new CPlatformView();
    }

    protected int getInitialStyleBits() {
        boolean bl;
        int n = 3970;
        if (this.isNativelyFocusableWindow()) {
            n = CPlatformWindow.SET(n, 4096, true);
            n = CPlatformWindow.SET(n, 8192, true);
        }
        boolean bl2 = this.target instanceof Frame;
        boolean bl3 = this.target instanceof Dialog;
        boolean bl4 = bl = this.target.getType() == Window.Type.POPUP;
        if (bl3) {
            n = CPlatformWindow.SET(n, 256, false);
        }
        boolean bl5 = bl2 ? ((Frame)this.target).isUndecorated() : (this.undecorated = bl3 ? ((Dialog)this.target).isUndecorated() : true);
        if (this.undecorated) {
            n = CPlatformWindow.SET(n, 2, false);
        }
        boolean bl6 = bl2 ? ((Frame)this.target).isResizable() : (bl3 ? ((Dialog)this.target).isResizable() : false);
        n = CPlatformWindow.SET(n, 512, bl6);
        if (!bl6) {
            n = CPlatformWindow.SET(n, 2048, false);
        }
        if (this.target.isAlwaysOnTop()) {
            n = CPlatformWindow.SET(n, 32768, true);
        }
        if (this.target.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            n = CPlatformWindow.SET(n, 65536, true);
        }
        if (bl) {
            n = CPlatformWindow.SET(n, 4, false);
            n = CPlatformWindow.SET(n, 0x1000000, true);
            n = CPlatformWindow.SET(n, 0x8000000, true);
        }
        if (Window.Type.UTILITY.equals((Object)this.target.getType())) {
            n = CPlatformWindow.SET(n, 16, true);
        }
        if (this.target instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)this.target)).getRootPane();
            Object object = null;
            object = jRootPane.getClientProperty(WINDOW_BRUSH_METAL_LOOK);
            if (object != null) {
                n = CPlatformWindow.SET(n, 4, Boolean.parseBoolean(object.toString()));
            }
            if (bl3 && ((Dialog)this.target).getModalityType() == Dialog.ModalityType.DOCUMENT_MODAL && (object = jRootPane.getClientProperty(WINDOW_DOC_MODAL_SHEET)) != null) {
                n = CPlatformWindow.SET(n, 64, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_STYLE)) != null) {
                if ("small".equals(object)) {
                    n = CPlatformWindow.SET(n, 16, true);
                    if (this.target.isAlwaysOnTop() && jRootPane.getClientProperty(WINDOW_HIDES_ON_DEACTIVATE) == null) {
                        n = CPlatformWindow.SET(n, 131072, true);
                    }
                }
                if ("textured".equals(object)) {
                    n = CPlatformWindow.SET(n, 4, true);
                }
                if ("unified".equals(object)) {
                    n = CPlatformWindow.SET(n, 8, true);
                }
                if ("hud".equals(object)) {
                    n = CPlatformWindow.SET(n, 32, true);
                }
            }
            if ((object = jRootPane.getClientProperty(WINDOW_HIDES_ON_DEACTIVATE)) != null) {
                n = CPlatformWindow.SET(n, 131072, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_CLOSEABLE)) != null) {
                n = CPlatformWindow.SET(n, 128, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_MINIMIZABLE)) != null) {
                n = CPlatformWindow.SET(n, 256, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_ZOOMABLE)) != null) {
                n = CPlatformWindow.SET(n, 2048, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_FULLSCREENABLE)) != null) {
                n = CPlatformWindow.SET(n, 0x800000, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_SHADOW)) != null) {
                n = CPlatformWindow.SET(n, 1024, Boolean.parseBoolean(object.toString()));
            }
            if ((object = jRootPane.getClientProperty(WINDOW_DRAGGABLE_BACKGROUND)) != null) {
                n = CPlatformWindow.SET(n, 524288, Boolean.parseBoolean(object.toString()));
            }
        }
        if (bl3) {
            n = CPlatformWindow.SET(n, 0x2000000, true);
            if (((Dialog)this.target).isModal()) {
                n = CPlatformWindow.SET(n, 0x4000000, true);
            }
        }
        this.peer.setTextured(CPlatformWindow.IS(4, n));
        return n;
    }

    private void setStyleBits(int n, boolean bl) {
        this.execute(l -> CPlatformWindow.nativeSetNSWindowStyleBits(l, n, bl ? n : 0));
    }

    private native void _toggleFullScreenMode(long var1);

    public void toggleFullScreen() {
        this.execute(this::_toggleFullScreenMode);
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        CMenuBar cMenuBar = (CMenuBar)LWToolkit.targetToPeer(menuBar);
        this.execute(l -> {
            if (cMenuBar != null) {
                cMenuBar.execute(l2 -> CPlatformWindow.nativeSetNSWindowMenuBar(l, l2));
            } else {
                CPlatformWindow.nativeSetNSWindowMenuBar(l, 0L);
            }
        });
    }

    @Override
    public void dispose() {
        this.contentView.dispose();
        this.execute(CPlatformWindow::nativeDispose);
        CPlatformWindow.super.dispose();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        new RuntimeException("unimplemented").printStackTrace();
        return null;
    }

    @Override
    public Insets getInsets() {
        AtomicReference atomicReference = new AtomicReference();
        this.execute(l -> atomicReference.set(CPlatformWindow.nativeGetNSWindowInsets(l)));
        return atomicReference.get() != null ? (Insets)atomicReference.get() : new Insets(0, 0, 0, 0);
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(this.nativeBounds.x, this.nativeBounds.y);
    }

    @Override
    public GraphicsDevice getGraphicsDevice() {
        return this.contentView.getGraphicsDevice();
    }

    @Override
    public SurfaceData getScreenSurface() {
        return null;
    }

    @Override
    public SurfaceData replaceSurfaceData() {
        return this.contentView.replaceSurfaceData();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.execute(l -> CPlatformWindow.nativeSetNSWindowBounds(l, n, n2, n3, n4));
    }

    private boolean isMaximized() {
        if (this.undecorated) {
            return this.normalBounds != null;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.execute(l -> atomicBoolean.set(CWrapper.NSWindow.isZoomed(l)));
        return atomicBoolean.get();
    }

    private void maximize() {
        if (this.peer == null || this.isMaximized()) {
            return;
        }
        if (!this.undecorated) {
            this.execute(CWrapper.NSWindow::zoom);
        } else {
            this.deliverZoom(true);
            LWCToolkit.flushNativeSelectors();
            this.normalBounds = this.peer.getBounds();
            GraphicsConfiguration graphicsConfiguration = this.getPeer().getGraphicsConfiguration();
            Insets insets = ((CGraphicsDevice)graphicsConfiguration.getDevice()).getScreenInsets();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            this.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }
    }

    private void unmaximize() {
        if (!this.isMaximized()) {
            return;
        }
        if (!this.undecorated) {
            this.execute(CWrapper.NSWindow::zoom);
        } else {
            this.deliverZoom(false);
            Rectangle rectangle = this.normalBounds;
            this.normalBounds = null;
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        int n;
        LWWindowPeer lWWindowPeer;
        this.updateIconImages();
        this.updateFocusabilityForAutoRequestFocus(false);
        boolean bl2 = this.isMaximized();
        LWWindowPeer lWWindowPeer2 = lWWindowPeer = this.peer == null ? null : this.peer.getBlocker();
        if (lWWindowPeer == null || !bl) {
            if (bl) {
                this.contentView.execute(l -> this.execute(l2 -> CWrapper.NSWindow.makeFirstResponder(l2, l)));
                n = this.target.getType() == Window.Type.POPUP ? 1 : 0;
                this.execute(arg_0 -> CPlatformWindow.lambda$setVisible$10(n != 0, arg_0));
            } else {
                this.execute(l -> {
                    CWrapper.NSWindow.orderOut(l);
                    CWrapper.NSWindow.close(l);
                });
            }
        } else {
            CPlatformWindow cPlatformWindow = (CPlatformWindow)lWWindowPeer.getPlatformWindow();
            cPlatformWindow.execute(l -> this.execute(l2 -> CWrapper.NSWindow.orderWindow(l2, -1, l)));
        }
        this.visible = bl;
        if (bl && this.target instanceof Frame) {
            if (!bl2 && this.isMaximized()) {
                this.deliverZoom(true);
            } else {
                n = ((Frame)this.target).getExtendedState();
                if ((n & 1) != 0) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        this.execute(CWrapper.NSWindow::miniaturize);
                        break;
                    }
                    case 6: {
                        this.maximize();
                        break;
                    }
                    default: {
                        this.unmaximize();
                    }
                }
            }
        }
        CPlatformWindow.nativeSynthesizeMouseEnteredExitedEvents();
        this.updateFocusabilityForAutoRequestFocus(true);
        if (bl) {
            if (this.owner != null && this.owner.isVisible()) {
                this.owner.execute(l -> this.execute(l2 -> CWrapper.NSWindow.orderWindow(l2, 1, l)));
                this.applyWindowLevel(this.target);
            }
            for (Window window : this.target.getOwnedWindows()) {
                CPlatformWindow cPlatformWindow;
                WindowPeer windowPeer = (WindowPeer)window.getPeer();
                if (!(windowPeer instanceof LWWindowPeer) || (cPlatformWindow = (CPlatformWindow)((LWWindowPeer)windowPeer).getPlatformWindow()) == null || !cPlatformWindow.isVisible()) continue;
                cPlatformWindow.execute(l -> this.execute(l2 -> CWrapper.NSWindow.orderWindow(l, 1, l2)));
                cPlatformWindow.applyWindowLevel(window);
            }
        }
        if (lWWindowPeer != null && bl) {
            ((CPlatformWindow)lWWindowPeer.getPlatformWindow()).orderAboveSiblings();
        }
    }

    @Override
    public void setTitle(String string) {
        this.execute(l -> CPlatformWindow.nativeSetNSWindowTitle(l, string));
    }

    @Override
    public void updateIconImages() {
        CImage cImage = this.getImageForTarget();
        this.execute(l -> {
            if (cImage == null) {
                CPlatformWindow.nativeSetNSWindowMinimizedIcon(l, 0L);
            } else {
                cImage.execute(l2 -> CPlatformWindow.nativeSetNSWindowMinimizedIcon(l, l2));
            }
        });
    }

    public SurfaceData getSurfaceData() {
        return this.contentView.getSurfaceData();
    }

    @Override
    public void toBack() {
        this.execute(CPlatformWindow::nativePushNSWindowToBack);
    }

    @Override
    public void toFront() {
        LWCToolkit lWCToolkit = (LWCToolkit)Toolkit.getDefaultToolkit();
        Window window = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null && window.getPeer() != null && ((LWWindowPeer)window.getPeer()).getPeerType() == LWWindowPeer.PeerType.EMBEDDED_FRAME && !lWCToolkit.isApplicationActive()) {
            lWCToolkit.activateApplicationIgnoringOtherApps();
        }
        this.updateFocusabilityForAutoRequestFocus(false);
        this.execute(CPlatformWindow::nativePushNSWindowToFront);
        this.updateFocusabilityForAutoRequestFocus(true);
    }

    @Override
    public void setResizable(boolean bl) {
        this.setStyleBits(512, bl);
    }

    @Override
    public void setSizeConstraints(int n, int n2, int n3, int n4) {
        this.execute(l -> CPlatformWindow.nativeSetNSWindowMinMax(l, n, n2, n3, n4));
    }

    @Override
    public boolean rejectFocusRequest(CausedFocusEvent.Cause cause) {
        if (cause != CausedFocusEvent.Cause.MOUSE_EVENT && !((LWCToolkit)Toolkit.getDefaultToolkit()).isApplicationActive()) {
            focusLogger.fine("the app is inactive, so the request is rejected");
            return true;
        }
        return false;
    }

    @Override
    public boolean requestWindowFocus() {
        this.execute(l -> {
            if (CWrapper.NSWindow.canBecomeMainWindow(l)) {
                CWrapper.NSWindow.makeMainWindow(l);
            }
            CWrapper.NSWindow.makeKeyAndOrderFront(l);
        });
        return true;
    }

    @Override
    public boolean isActive() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.execute(l -> atomicBoolean.set(CWrapper.NSWindow.isKeyWindow(l)));
        return atomicBoolean.get();
    }

    @Override
    public void updateFocusableWindowState() {
        boolean bl = this.isNativelyFocusableWindow();
        this.setStyleBits(12288, bl);
    }

    @Override
    public Graphics transformGraphics(Graphics graphics) {
        return graphics;
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.setStyleBits(32768, bl);
    }

    @Override
    public void setOpacity(float f) {
        this.execute(l -> CWrapper.NSWindow.setAlphaValue(l, f));
    }

    @Override
    public void setOpaque(boolean bl) {
        boolean bl2;
        this.execute(l -> CWrapper.NSWindow.setOpaque(l, bl));
        boolean bl3 = bl2 = this.peer == null ? false : this.peer.isTextured();
        if (!bl2) {
            Color color;
            if (!bl) {
                this.execute(l -> CWrapper.NSWindow.setBackgroundColor(l, 0));
            } else if (this.peer != null && (color = this.peer.getBackground()) != null) {
                int n = color.getRGB();
                this.execute(l -> CWrapper.NSWindow.setBackgroundColor(l, n));
            }
        }
        SwingUtilities.invokeLater(this::invalidateShadow);
    }

    @Override
    public void enterFullScreenMode() {
        this.isFullScreenMode = true;
        this.execute(CPlatformWindow::nativeEnterFullScreenMode);
    }

    @Override
    public void exitFullScreenMode() {
        this.execute(CPlatformWindow::nativeExitFullScreenMode);
        this.isFullScreenMode = false;
    }

    @Override
    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    @Override
    public void setWindowState(int n) {
        if (this.peer == null || !this.peer.isVisible()) {
            return;
        }
        int n2 = this.peer.getState();
        if (n2 == n) {
            return;
        }
        if ((n & 1) != 0) {
            n = 1;
        }
        switch (n) {
            case 1: {
                if (n2 == 6) {
                    this.unmaximize();
                }
                this.execute(CWrapper.NSWindow::miniaturize);
                break;
            }
            case 6: {
                if (n2 == 1) {
                    this.execute(CWrapper.NSWindow::deminiaturize);
                }
                this.maximize();
                break;
            }
            case 0: {
                if (n2 == 1) {
                    this.execute(CWrapper.NSWindow::deminiaturize);
                    break;
                }
                if (n2 != 6) break;
                this.unmaximize();
                break;
            }
            default: {
                throw new RuntimeException("Unknown window state: " + n);
            }
        }
    }

    @Override
    public void setModalBlocked(boolean bl) {
        if (this.target.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            return;
        }
        this.execute(l -> CPlatformWindow.nativeSetEnabled(l, !bl));
        this.checkBlockingAndOrder();
    }

    public final void invalidateShadow() {
        this.execute(l -> CPlatformWindow.nativeRevalidateNSWindowShadow(l));
    }

    private CImage getImageForTarget() {
        CImage cImage = null;
        try {
            cImage = CImage.getCreator().createFromImages(this.target.getIconImages());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cImage;
    }

    @Override
    public LWWindowPeer getPeer() {
        return this.peer;
    }

    @Override
    public boolean isUnderMouse() {
        return this.contentView.isUnderMouse();
    }

    public CPlatformView getContentView() {
        return this.contentView;
    }

    @Override
    public long getLayerPtr() {
        return this.contentView.getWindowLayerPtr();
    }

    private void validateSurface() {
        SurfaceData surfaceData = this.getSurfaceData();
        if (surfaceData instanceof CGLSurfaceData) {
            ((CGLSurfaceData)surfaceData).validate();
        }
    }

    void flushBuffers() {
        if (this.isVisible() && !this.nativeBounds.isEmpty() && !this.isFullScreenMode) {
            try {
                LWCToolkit.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                }, (Component)this.target);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    static long getNativeViewPtr(PlatformWindow platformWindow) {
        long l = 0L;
        if (platformWindow instanceof CPlatformWindow) {
            l = ((CPlatformWindow)platformWindow).getContentView().getAWTView();
        } else if (platformWindow instanceof CViewPlatformEmbeddedFrame) {
            l = ((CViewPlatformEmbeddedFrame)platformWindow).getNSViewPtr();
        }
        return l;
    }

    private void deliverWindowFocusEvent(boolean bl, CPlatformWindow cPlatformWindow) {
        if (bl && !((LWCToolkit)Toolkit.getDefaultToolkit()).isApplicationActive()) {
            focusLogger.fine("the app is inactive, so the notification is ignored");
            return;
        }
        LWWindowPeer lWWindowPeer = cPlatformWindow == null ? null : cPlatformWindow.getPeer();
        this.responder.handleWindowFocusEvent(bl, lWWindowPeer);
    }

    protected void deliverMoveResizeEvent(int n, int n2, int n3, int n4, boolean bl) {
        this.checkZoom();
        Rectangle rectangle = this.nativeBounds;
        this.nativeBounds = new Rectangle(n, n2, n3, n4);
        if (this.peer != null) {
            this.peer.notifyReshape(n, n2, n3, n4);
            if (bl && !rectangle.getSize().equals(this.nativeBounds.getSize()) || this.isFullScreenAnimationOn) {
                this.flushBuffers();
            }
        }
    }

    private void deliverWindowClosingEvent() {
        if (this.peer != null && this.peer.getBlocker() == null) {
            this.peer.postEvent(new WindowEvent(this.target, 201));
        }
    }

    private void deliverIconify(boolean bl) {
        if (this.peer != null) {
            this.peer.notifyIconify(bl);
        }
        if (bl) {
            this.isIconifyAnimationActive = false;
        }
    }

    private void deliverZoom(boolean bl) {
        if (this.peer != null) {
            this.peer.notifyZoom(bl);
        }
    }

    private void checkZoom() {
        if (this.target instanceof Frame && this.isVisible()) {
            Frame frame = (Frame)this.target;
            if (frame.getExtendedState() != 6 && this.isMaximized()) {
                this.deliverZoom(true);
            } else if (frame.getExtendedState() == 6 && !this.isMaximized()) {
                this.deliverZoom(false);
            }
        }
    }

    private void deliverNCMouseDown() {
        if (this.peer != null) {
            this.peer.notifyNCMouseDown();
        }
    }

    private boolean isNativelyFocusableWindow() {
        if (this.peer == null) {
            return false;
        }
        return !this.peer.isSimpleWindow() && this.target.getFocusableWindowState();
    }

    private void updateFocusabilityForAutoRequestFocus(boolean bl) {
        if (this.target.isAutoRequestFocus() || !this.isNativelyFocusableWindow()) {
            return;
        }
        this.setStyleBits(12288, bl);
    }

    private boolean checkBlockingAndOrder() {
        LWWindowPeer lWWindowPeer;
        LWWindowPeer lWWindowPeer2 = lWWindowPeer = this.peer == null ? null : this.peer.getBlocker();
        if (lWWindowPeer == null) {
            return false;
        }
        if (lWWindowPeer instanceof CPrinterDialogPeer) {
            return true;
        }
        CPlatformWindow cPlatformWindow = (CPlatformWindow)lWWindowPeer.getPlatformWindow();
        cPlatformWindow.orderAboveSiblings();
        cPlatformWindow.execute(l -> {
            CWrapper.NSWindow.orderFrontRegardless(l);
            CWrapper.NSWindow.makeKeyAndOrderFront(l);
            CWrapper.NSWindow.makeMainWindow(l);
        });
        return true;
    }

    private boolean isIconified() {
        int n;
        boolean bl = false;
        if (this.target instanceof Frame && ((n = ((Frame)this.target).getExtendedState()) & 1) != 0) {
            bl = true;
        }
        return this.isIconifyAnimationActive || bl;
    }

    private boolean isOneOfOwnersOrSelf(CPlatformWindow cPlatformWindow) {
        while (cPlatformWindow != null) {
            if (this == cPlatformWindow) {
                return true;
            }
            cPlatformWindow = cPlatformWindow.owner;
        }
        return false;
    }

    private CPlatformWindow getRootOwner() {
        CPlatformWindow cPlatformWindow = this;
        while (cPlatformWindow.owner != null) {
            cPlatformWindow = cPlatformWindow.owner;
        }
        return cPlatformWindow;
    }

    private void orderAboveSiblings() {
        CPlatformWindow cPlatformWindow = this.getRootOwner();
        if (cPlatformWindow.isVisible() && !cPlatformWindow.isIconified()) {
            cPlatformWindow.execute(CWrapper.NSWindow::orderFront);
        }
        if (!cPlatformWindow.isIconified()) {
            AWTAccessor.WindowAccessor windowAccessor = AWTAccessor.getWindowAccessor();
            this.orderAboveSiblingsImpl(windowAccessor.getOwnedWindows(cPlatformWindow.target));
        }
    }

    private void orderAboveSiblingsImpl(Window[] windowArray) {
        ArrayList<Window> arrayList = new ArrayList<Window>();
        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
        AWTAccessor.WindowAccessor windowAccessor = AWTAccessor.getWindowAccessor();
        for (Window window : windowArray) {
            boolean bl = false;
            ComponentPeer componentPeer = componentAccessor.getPeer(window);
            if (componentPeer instanceof LWWindowPeer) {
                CPlatformWindow cPlatformWindow = (CPlatformWindow)((LWWindowPeer)componentPeer).getPlatformWindow();
                bl = this.isIconified();
                if (cPlatformWindow != null && cPlatformWindow.isVisible() && !bl) {
                    if (cPlatformWindow.isOneOfOwnersOrSelf(this)) {
                        cPlatformWindow.execute(CWrapper.NSWindow::orderFront);
                    } else {
                        cPlatformWindow.owner.execute(l -> cPlatformWindow.execute(l2 -> CWrapper.NSWindow.orderWindow(l2, 1, l)));
                    }
                    cPlatformWindow.applyWindowLevel(window);
                }
            }
            if (bl) continue;
            arrayList.addAll(Arrays.asList(windowAccessor.getOwnedWindows(window)));
        }
        if (!arrayList.isEmpty()) {
            this.orderAboveSiblingsImpl(arrayList.toArray(new Window[0]));
        }
    }

    protected void applyWindowLevel(Window window) {
        if (window.isAlwaysOnTop() && window.getType() != Window.Type.POPUP) {
            this.execute(l -> CWrapper.NSWindow.setLevel(l, 1));
        } else if (window.getType() == Window.Type.POPUP) {
            this.execute(l -> CWrapper.NSWindow.setLevel(l, 2));
        }
    }

    private void windowWillMiniaturize() {
        this.isIconifyAnimationActive = true;
    }

    private void windowDidBecomeMain() {
        assert (CThreading.assertAppKit());
        if (this.checkBlockingAndOrder()) {
            return;
        }
        this.orderAboveSiblings();
    }

    private void windowWillEnterFullScreen() {
        this.isFullScreenAnimationOn = true;
    }

    private void windowDidEnterFullScreen() {
        this.isFullScreenAnimationOn = false;
    }

    private void windowWillExitFullScreen() {
        this.isFullScreenAnimationOn = true;
    }

    private void windowDidExitFullScreen() {
        this.isFullScreenAnimationOn = false;
    }

    private static /* synthetic */ void lambda$setVisible$10(boolean bl, long l) {
        if (bl) {
            CWrapper.NSWindow.orderFrontRegardless(l);
        } else {
            CWrapper.NSWindow.orderFront(l);
        }
        boolean bl2 = CWrapper.NSWindow.isKeyWindow(l);
        if (!bl2) {
            CWrapper.NSWindow.makeKeyWindow(l);
        }
    }
}

