/*
 * Decompiled with CFR 0.152.
 */
package background;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import main.BodyPanel;
import util.Util;

public class CapillaryThread {
    private double length;
    private double width;
    private double angle;
    private CapillaryThread top = null;
    private CapillaryThread middle = null;
    private CapillaryThread bottom = null;
    private Rectangle2D.Double thread;
    private float shortenBranch = 0.65f;
    private float shortenCenterBranch = 0.6f;
    private double topAngle = -0.3f;
    private double bottomAngle = 0.3f;
    private double absoluteAngle;
    private double scale = 1.0;
    private double increaseScale = 1.0E-4;
    private int increaseScaleTimer = 60;

    CapillaryThread(double len, double wid, double ang, int layer, double absAng) {
        this.length = len;
        this.width = wid;
        this.angle = ang;
        this.absoluteAngle = absAng += this.angle;
        this.thread = new Rectangle2D.Double(-this.width / 2.0, -this.length, this.width, this.length);
        if (layer >= 1) {
            this.top = new CapillaryThread(this.length * (double)this.shortenBranch * (double)Util.random(1.0, 1.2), this.width * (double)this.shortenBranch, this.topAngle + (double)Util.random(-0.2 * this.topAngle, 0.2 * this.topAngle), layer - 1, this.absoluteAngle);
            this.middle = new CapillaryThread(this.length * (double)this.shortenCenterBranch * (double)Util.random(1.0, 1.2), this.width * (double)this.shortenCenterBranch, Util.random(-0.2, 0.2), layer - 1, this.absoluteAngle);
            this.bottom = new CapillaryThread(this.length * (double)this.shortenBranch * (double)Util.random(1.0, 1.2), this.width * (double)this.shortenBranch, this.bottomAngle + (double)Util.random(-0.2 * this.bottomAngle, 0.2 * this.bottomAngle), layer - 1, this.absoluteAngle);
        }
        if (layer == 0) {
            this.middle = new CapillaryThread(75.0f * Util.random(1.0, 1.2), this.width * (double)this.shortenCenterBranch, -this.absoluteAngle + (double)Util.random(-0.2, 0.2), layer - 1, this.absoluteAngle);
        }
    }

    public void drawCapillary(Graphics2D g2, Color c) {
        AffineTransform tr = g2.getTransform();
        g2.rotate(this.angle);
        g2.scale(this.scale, this.scale);
        this.scale += this.increaseScale;
        if (BodyPanel.getEnergy() > 3100) {
            this.increaseScaleTimer -= 2;
        } else if (BodyPanel.getEnergy() > 2500) {
            this.increaseScaleTimer -= 5;
        } else if (BodyPanel.getEnergy() > 0) {
            --this.increaseScaleTimer;
        }
        if (this.increaseScaleTimer < 0) {
            this.increaseScale *= -1.0;
            this.increaseScaleTimer = 60;
        }
        g2.setColor(c);
        g2.fill(this.thread);
        g2.translate(0.0, -this.length);
        if (this.top != null) {
            this.top.drawCapillary(g2, c);
        }
        if (this.middle != null) {
            this.middle.drawCapillary(g2, c);
        }
        if (this.bottom != null) {
            this.bottom.drawCapillary(g2, c);
        }
        g2.setTransform(tr);
    }
}

