/*
 * Decompiled with CFR 0.152.
 */
package bodycells;

import bodycells.BaseBodyCell;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import main.BodyPanel;
import processing.core.PApplet;
import util.Util;

public class BodyCell
extends BaseBodyCell {
    private double angle = 0.0;
    private Ellipse2D.Double bodyHitBox;
    private BufferedImage body;
    private Ellipse2D.Double nucleus;
    private Arc2D.Double smallER;
    private Arc2D.Double largeER;
    private Ellipse2D.Double mitochondria;
    private Rectangle2D.Double microtube;
    private AffineTransform point = new AffineTransform();
    private BaseBodyCell infectedCell;
    private int lowerInfectedLevelTimer = 250;
    private GeneralPath dnaPath = new GeneralPath();
    private float noiseSeed = Util.random(0.0, 10.0);
    private PApplet pa = new PApplet();
    private float dnaAngle = 0.0f;
    private int dnaLength = 150;
    private float dnaRadius = 1.0f;
    private float dnaX;
    private float dnaY;
    private float dnaLastX = 0.0f;
    private float dnaLastY = 0.0f;

    public BodyCell(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.body = Util.loadImage("assets/animalCellBody.png");
        this.bodyHitBox = new Ellipse2D.Double();
        this.nucleus = new Ellipse2D.Double();
        this.smallER = new Arc2D.Double();
        this.largeER = new Arc2D.Double();
        this.mitochondria = new Ellipse2D.Double();
        this.microtube = new Rectangle2D.Double();
        this.infectedTimer = 300;
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
        this.pos.add(this.vel);
        this.collisionWallDetection();
        if (this.infected || this.infectedLevel != 0) {
            this.createIntruder();
        }
    }

    private void createIntruder() {
        int i;
        if (this.infectedTimer == 200) {
            BodyPanel.infectedCellList.remove(this.infectedCell);
            this.infectedCell = null;
        }
        if (this.infectedLevel == 0) {
            --this.infectedTimer;
            if (this.infectedTimer == 0) {
                i = 0;
                while (i < (int)Util.random(5.0, 10.0)) {
                    BodyPanel.addVirusAtPosition(this.pos.x, this.pos.y);
                    ++i;
                }
                BodyPanel.infectedCellList.remove(this.infectedCell);
                BodyPanel.bodyCellList.remove(this);
            }
        }
        if (this.infectedLevel >= 2) {
            i = 0;
            while (i < (int)Util.random(10.0, 12.0)) {
                BodyPanel.addBacteriaAtPosition(this.pos.x, this.pos.y);
                ++i;
            }
            BodyPanel.infectedCellList.remove(this.infectedCell);
            BodyPanel.bodyCellList.remove(this);
        }
        if (this.infectedLevel != 0) {
            --this.lowerInfectedLevelTimer;
            if (this.lowerInfectedLevelTimer < 0) {
                this.infectedLevel = 0;
                BodyPanel.infectedCellList.remove(this.infectedCell);
            }
        }
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        g2.scale(this.scale, this.scale);
        g2.rotate(this.angle);
        if (this.infectedCell == null) {
            this.angle += 0.02;
        }
        this.angle += 0.002;
        this.point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(this.point);
        g2.setColor(new Color(255, 192, 116));
        g2.drawImage((Image)this.body, -40, -40, null);
        g2.setColor(new Color(168, 61, 167));
        g2.fill(this.nucleus);
        g2.setColor(new Color(180, 80, 187));
        g2.setStroke(new BasicStroke(2.0f));
        g2.draw(this.smallER);
        g2.setStroke(new BasicStroke(4.0f));
        g2.draw(this.largeER);
        g2.setColor(new Color(255, 116, 0));
        g2.translate(8, 20);
        g2.rotate(0.8);
        g2.fill(this.mitochondria);
        g2.setTransform(this.point);
        g2.setColor(new Color(240, 226, 38));
        g2.translate(20, -10);
        g2.rotate(0.3);
        g2.fill(this.microtube);
        g2.setTransform(this.point);
        g2.setColor(new Color(90, 4, 176));
        g2.translate(-8, -8);
        g2.scale(0.2, 0.2);
        g2.setStroke(new BasicStroke(8.0f));
        g2.draw(this.dnaPath);
        g2.setTransform(original);
    }

    private void setDrawingAttributes() {
        this.bodyHitBox.setFrame(-this.SIZE_X / 2, -this.SIZE_Y / 2, this.SIZE_X, this.SIZE_Y);
        this.nucleus.setFrame(-this.SIZE_X / 2 + 10, -this.SIZE_Y / 2 + 10, this.SIZE_X / 2, this.SIZE_X / 2);
        int i = 0;
        while (i < this.dnaLength) {
            this.dnaRadius = (float)((double)this.dnaRadius + 0.1);
            this.noiseSeed = (float)((double)this.noiseSeed + 0.05);
            float noiseRadius = this.dnaRadius + this.pa.noise(this.noiseSeed) * 100.0f - 100.0f;
            float ra = Util.radians(this.dnaAngle += 5.0f);
            this.dnaX = noiseRadius * (float)Math.cos(ra);
            this.dnaY = noiseRadius * (float)Math.sin(ra);
            this.dnaPath.moveTo(this.dnaX, this.dnaY);
            this.dnaPath.lineTo(this.dnaLastX, this.dnaLastY);
            this.dnaLastX = this.dnaX;
            this.dnaLastY = this.dnaY;
            ++i;
        }
        this.smallER.setArc((double)(-this.SIZE_X / 2 + 10) - 2.5, (double)(-this.SIZE_Y / 2 + 10) - 2.5, this.SIZE_X / 2 + 5, this.SIZE_X / 2 + 5, 0.0, 60.0, 0);
        this.largeER.setArc(-this.SIZE_X / 2 + 10 - 10, -this.SIZE_Y / 2 + 10 - 10, this.SIZE_X / 2 + 20, this.SIZE_X / 2 + 20, 0.0, 60.0, 0);
        this.mitochondria.setFrame(-10.0, -7.5, 20.0, 15.0);
        this.microtube.setFrame(8.0, 5.0, 10.0, 2.0);
    }

    private void setOutline() {
        this.outline.add(new Area(this.bodyHitBox));
    }

    @Override
    protected BaseBodyCell getBaseBodyCell() {
        return this;
    }

    @Override
    public AffineTransform getPointTransformation() {
        return this.point;
    }

    public void setInfectedCell(BaseBodyCell bci) {
        this.infectedCell = bci;
    }

    public boolean hasInfectedCell() {
        return this.infectedCell != null;
    }
}

