/*
 * Decompiled with CFR 0.152.
 */
package bodycells;

import bodycells.BaseBodyCell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import main.BodyPanel;
import util.Util;

public class OrganCell
extends BaseBodyCell {
    private Ellipse2D.Double cellBody = new Ellipse2D.Double();

    public OrganCell(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.infectedTimer = 300;
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
        this.pos.add(this.vel);
        if (this.infected || this.infectedLevel != 0) {
            this.createIntruder();
        }
    }

    private void createIntruder() {
        int i;
        --this.infectedTimer;
        if (this.infectedTimer == 0) {
            i = 0;
            while (i < (int)Util.random(1.0, 2.0)) {
                BodyPanel.addVirusAtPosition(this.pos.x, this.pos.y);
                ++i;
            }
            BodyPanel.bodyCellList.remove(this);
            BodyPanel.infectedCellList.remove(this);
        }
        if (this.infectedLevel >= 2) {
            i = 0;
            while (i < (int)Util.random(3.0, 4.0)) {
                BodyPanel.addBacteriaAtPosition(this.pos.x, this.pos.y);
                ++i;
            }
            BodyPanel.bodyCellList.remove(this);
        }
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        g2.scale(this.scale, this.scale);
        AffineTransform point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(point);
        g2.setColor(new Color(255, 73, 71));
        g2.fill(this.cellBody);
        g2.setTransform(original);
    }

    private void setDrawingAttributes() {
        this.cellBody.setFrame(-this.SIZE_X / 2, -this.SIZE_X / 2, this.SIZE_X, this.SIZE_Y);
    }

    private void setOutline() {
        this.outline.add(new Area(this.cellBody));
    }

    @Override
    protected BaseBodyCell getBaseBodyCell() {
        return this;
    }

    @Override
    protected AffineTransform getPointTransformation() {
        return null;
    }
}

