/*
 * Decompiled with CFR 0.152.
 */
package bodycells;

import bodycells.BaseBodyCell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class OrganCellWall
extends BaseBodyCell {
    private Ellipse2D.Double cellBody = new Ellipse2D.Double();
    private Rectangle2D.Double cellHitBox = new Rectangle2D.Double();
    private boolean passable = false;

    public OrganCellWall(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        if (this.scale <= 0.0) {
            this.scale = 0.0;
        }
        if (this.scale >= 1.0) {
            this.scale = 1.0;
        }
        g2.scale(this.scale, this.scale);
        AffineTransform point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(point);
        g2.setColor(new Color(232, 65, 143));
        if (this.passable) {
            g2.setColor(new Color(70, 59, 71));
        }
        g2.fill(this.cellBody);
        g2.setTransform(original);
    }

    public void setPassable(boolean b) {
        this.passable = b;
    }

    public boolean getPassable() {
        return this.passable;
    }

    private void setDrawingAttributes() {
        this.cellBody.setFrame(-this.SIZE_X / 2, -this.SIZE_Y / 2, this.SIZE_X, this.SIZE_Y);
        this.cellHitBox.setFrame(-this.SIZE_X / 2, -this.SIZE_Y / 2, this.SIZE_X, this.SIZE_Y);
    }

    private void setOutline() {
        this.outline.add(new Area(this.cellHitBox));
    }

    @Override
    protected BaseBodyCell getBaseBodyCell() {
        return this;
    }

    @Override
    protected AffineTransform getPointTransformation() {
        return null;
    }
}

