/*
 * Decompiled with CFR 0.152.
 */
package immunesystem;

import immunesystem.BaseImmuneCell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import main.BodyPanel;

public class Antibody
extends BaseImmuneCell {
    private double angle = 0.0;
    private float speedConstant = 0.9f;
    private Line2D.Double threadTop;
    private Line2D.Double threadLeft;
    private Line2D.Double threadRight;
    private Ellipse2D.Double boundingArea;

    public Antibody(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.energy = 200;
        this.threadTop = new Line2D.Double();
        this.threadLeft = new Line2D.Double();
        this.threadRight = new Line2D.Double();
        this.boundingArea = new Ellipse2D.Double();
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
        this.pos.add(this.vel);
        this.collisionWallDetection();
        this.vel.add(this.accel);
        if (this.accel.x != 0.0f && this.accel.y != 0.0f) {
            this.vel.mult(this.speedConstant);
        }
        --this.energy;
        if (this.energy < 0) {
            BodyPanel.immuneCellList.remove(this);
        }
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        g2.scale(this.scale, this.scale);
        g2.rotate(this.angle);
        this.angle += 0.01;
        AffineTransform point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(point);
        g2.setColor(new Color(85, 126, 255));
        g2.draw(this.threadTop);
        g2.draw(this.threadLeft);
        g2.draw(this.threadRight);
        g2.setTransform(original);
    }

    private void setDrawingAttributes() {
        this.threadTop.setLine(0.0, 0.0, 0.0, -5.0);
        this.threadLeft.setLine(0.0, 0.0, -5.0, 3.0);
        this.threadRight.setLine(0.0, 0.0, 5.0, 3.0);
        this.boundingArea.setFrame(-2.5, -2.5, 8.0, 8.0);
    }

    private void setOutline() {
        this.outline.add(new Area(this.boundingArea));
    }
}

