/*
 * Decompiled with CFR 0.152.
 */
package immunesystem;

import java.awt.Graphics2D;
import java.util.ArrayList;
import main.BaseCell;
import processing.core.PVector;

public abstract class BaseImmuneCell
extends BaseCell {
    protected PVector accel = new PVector();
    protected int energy;

    BaseImmuneCell(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
    }

    @Override
    public abstract void move();

    @Override
    public abstract void drawCell(Graphics2D var1);

    public void decreaseEnergy(int n) {
        this.energy -= n;
    }

    public void goTowards(ArrayList<BaseCell> targetList) {
        try {
            if (targetList.size() != 0) {
                BaseCell chosenCell = null;
                BaseCell otherChosenCell = null;
                int i = 0;
                while (i < targetList.size()) {
                    BaseCell a = targetList.get(i);
                    double distA = PVector.dist(this.pos, a.getPos());
                    int j = i + 1;
                    while (j < targetList.size()) {
                        BaseCell b = targetList.get(j);
                        double distB = PVector.dist(this.pos, b.getPos());
                        otherChosenCell = distA < distB ? a : b;
                        if (chosenCell == null) {
                            chosenCell = otherChosenCell;
                        } else {
                            float distOtherCell;
                            float distCell = PVector.dist(this.pos, chosenCell.getPos());
                            if (distCell > (distOtherCell = PVector.dist(this.pos, otherChosenCell.getPos()))) {
                                chosenCell = otherChosenCell;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (targetList.size() == 1) {
                    chosenCell = targetList.get(0);
                }
                if (chosenCell != null) {
                    this.accel.x = chosenCell.getPos().x - this.pos.x;
                    this.accel.y = chosenCell.getPos().y - this.pos.y;
                    this.accel.normalize();
                }
            } else {
                this.accel.x = 0.0f;
                this.accel.y = 0.0f;
            }
        }
        catch (Exception e) {
            System.out.println("Error in BaseImmuneCell goTowrads() method");
        }
    }

    public void goTowards(BaseCell b) {
        this.accel.x = b.getPos().x - this.pos.x;
        this.accel.y = b.getPos().y - this.pos.y;
        this.accel.normalize();
    }
}

