/*
 * Decompiled with CFR 0.152.
 */
package immunesystem;

import immunesystem.BaseImmuneCell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import main.BodyPanel;

public class Macrophage
extends BaseImmuneCell {
    float speedConstant = 0.8f;
    private Ellipse2D.Double cellBody;

    public Macrophage(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.energy = 400;
        this.cellBody = new Ellipse2D.Double();
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
        this.pos.add(this.vel);
        this.collisionWallDetection();
        this.vel.add(this.accel);
        if (this.accel.x != 0.0f && this.accel.y != 0.0f) {
            this.vel.mult(this.speedConstant);
        }
        --this.energy;
        if (this.energy < 0) {
            BodyPanel.immuneCellList.remove(this);
        }
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        g2.scale(this.scale, this.scale);
        AffineTransform point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(point);
        g2.setColor(new Color(180, 180, 180));
        g2.fill(this.cellBody);
        g2.setTransform(original);
    }

    public void increaseEnergy(int a) {
        this.energy += a;
    }

    private void setDrawingAttributes() {
        this.cellBody.setFrame(-this.SIZE_X / 2, -this.SIZE_Y / 2, this.SIZE_X, this.SIZE_Y);
    }

    private void setOutline() {
        this.outline.add(new Area(this.cellBody));
    }
}

