/*
 * Decompiled with CFR 0.152.
 */
package immunesystem;

import immunesystem.BaseImmuneCell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import main.BodyPanel;

public class TCell
extends BaseImmuneCell {
    float speedConstant = 0.7f;
    private Ellipse2D.Double cellBody;
    private Ellipse2D.Double cellCenter;
    private Ellipse2D.Double effectArea;

    public TCell(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.energy = 150;
        this.cellBody = new Ellipse2D.Double();
        this.cellCenter = new Ellipse2D.Double();
        this.effectArea = new Ellipse2D.Double();
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
        this.pos.add(this.vel);
        this.collisionWallDetection();
        this.vel.add(this.accel);
        this.vel.mult(this.speedConstant);
        --this.energy;
        if (this.energy < 0) {
            BodyPanel.immuneCellList.remove(this);
        }
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        g2.scale(this.scale, this.scale);
        AffineTransform point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(point);
        g2.setColor(new Color(180, 180, 180));
        g2.fill(this.cellBody);
        g2.setColor(new Color(255, 143, 65));
        g2.fill(this.cellCenter);
        g2.setTransform(original);
    }

    private void setDrawingAttributes() {
        this.cellBody.setFrame(-this.SIZE_X / 2, -this.SIZE_Y / 2, this.SIZE_X, this.SIZE_Y);
        this.cellCenter.setFrame(-5.0, -5.0, 10.0, 10.0);
        this.effectArea.setFrame(-250.0, -250.0, 500.0, 500.0);
    }

    private void setOutline() {
        this.outline.add(new Area(this.cellBody));
        this.outline.add(new Area(this.effectArea));
    }
}

