/*
 * Decompiled with CFR 0.152.
 */
package intruder;

import intruder.BaseIntruder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import main.BodyPanel;

public class Bacteria
extends BaseIntruder {
    private Ellipse2D.Double body = new Ellipse2D.Double();
    private Ellipse2D.Double bodyWall = new Ellipse2D.Double();
    private int multiplyTimer = 50;

    public Bacteria(float posX, float posY, float velX, float velY, int sizeX, int sizeY, int scale) {
        super(posX, posY, velX, velY, sizeX, sizeY, scale);
        this.setDrawingAttributes();
        this.setOutline();
    }

    @Override
    public void move() {
        this.pos.add(this.vel);
        this.collisionWallDetection();
        this.multiply();
    }

    @Override
    public void drawCell(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        g2.translate(this.pos.x, this.pos.y);
        g2.scale(this.scale, this.scale);
        float angle = this.vel.heading();
        g2.rotate(angle);
        AffineTransform point = g2.getTransform();
        this.hitBox = this.outline.createTransformedArea(point);
        g2.setColor(new Color(50, 235, 90));
        g2.fill(this.bodyWall);
        g2.setColor(new Color(130, 255, 143));
        g2.fill(this.body);
        g2.setTransform(original);
    }

    private void setDrawingAttributes() {
        this.body.setFrame(-7.5, -5.5, 15.0, 10.0);
        this.bodyWall.setFrame(-10.0, -7.5, 20.0, 15.0);
    }

    private void setOutline() {
        this.outline.add(new Area(this.bodyWall));
    }

    private void multiply() {
        --this.multiplyTimer;
        if (this.multiplyTimer < 0) {
            this.multiplyTimer = 500;
            BodyPanel.addBacteriaAtPosition(this.pos.x, this.pos.y);
        }
    }
}

