/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import processing.core.PVector;

public abstract class BaseCell {
    protected PVector pos;
    protected PVector vel;
    protected final int SIZE_X;
    protected final int SIZE_Y;
    protected double scale;
    protected Area outline = new Area();
    protected Area hitBox = new Area();

    protected BaseCell(float posX, float posY, float velX, float velY, int sizeX, int sizeY, double s) {
        this.pos = new PVector(posX, posY);
        this.vel = new PVector(velX, velY);
        this.SIZE_X = sizeX;
        this.SIZE_Y = sizeY;
        this.scale = s;
    }

    public abstract void move();

    public abstract void drawCell(Graphics2D var1);

    protected void collisionWallDetection() {
        if ((double)this.pos.x + (double)(this.SIZE_X / 2) * this.scale > 1200.0 || (double)this.pos.x - (double)(this.SIZE_X / 2) * this.scale < 0.0) {
            this.vel.x *= -1.0f;
        }
        if ((double)this.pos.y + (double)(this.SIZE_Y / 2) * this.scale > 800.0 || (double)this.pos.y - (double)(this.SIZE_Y / 2) * this.scale < 0.0) {
            this.vel.y *= -1.0f;
        }
    }

    protected boolean collideWith(BaseCell b) {
        return this.hitBox.intersects(b.hitBox.getBounds2D()) && b.hitBox.intersects(this.hitBox.getBounds2D());
    }

    public PVector getPos() {
        return this.pos;
    }

    public PVector getVel() {
        return this.vel;
    }

    public void setVel(float x, float y) {
        this.vel.x = x;
        this.vel.y = y;
    }

    public void setScale(double s) {
        this.scale = s;
    }

    public double getScale() {
        return this.scale;
    }

    public int getSizeX() {
        return this.SIZE_X;
    }

    public int getSizeY() {
        return this.SIZE_Y;
    }
}

