/*
 * Decompiled with CFR 0.152.
 */
package main;

import background.BodyBackground;
import bodycells.BaseBodyCell;
import bodycells.BodyCell;
import bodycells.BodyCellDecorator;
import bodycells.BodyCellInfected;
import bodycells.BodyCellSlightInfected;
import bodycells.OrganCell;
import bodycells.OrganCellWall;
import immunesystem.Antibody;
import immunesystem.BaseImmuneCell;
import immunesystem.Macrophage;
import immunesystem.TCell;
import intruder.Bacteria;
import intruder.Virus;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import main.BaseCell;
import util.Util;

public class BodyPanel
extends JPanel
implements ActionListener {
    private Timer timer;
    public static final int SCREEN_WIDTH = 1200;
    public static final int SCREEN_HEIGHT = 800;
    public static ArrayList<BaseCell> intruderList = new ArrayList();
    public static ArrayList<BaseImmuneCell> immuneCellList = new ArrayList();
    public static ArrayList<BaseCell> bodyCellList = new ArrayList();
    public static ArrayList<BaseCell> infectedCellList = new ArrayList();
    public static ArrayList<OrganCellWall> organCellWallList = new ArrayList();
    private static BodyBackground background = new BodyBackground();
    private BufferedImage startScreen;
    private int initialMacrophage = 5;
    private int initialBodyCell = 20;
    private static int energy;
    private int respawnCellsTimer = 100;
    private int respawnBodyCellsTimer = 100;
    private int respawnOrganCellsTimer = 1000;
    private static final int START_SCREEN = 0;
    private static final int RUNNING_PROGRAM = 1;
    private static final int INTRUDER_WIN = 2;
    private static final int BODY_WIN = 3;
    private int programState = 0;
    JButton startButton = new JButton("Start");
    JButton resetButton = new JButton("Reset");
    JButton addBacteriaButton = new JButton("Add Bacteria");
    JButton addVirusButton = new JButton("Add Virus");
    JButton addMacrophageButton = new JButton("Add Macrophage");
    JButton addTCellButton = new JButton("Add TCell");
    JButton addAntibodyButton = new JButton("Add Antibody");
    JButton addBodyCellButton = new JButton("Add Body Cell");

    BodyPanel() {
        this.timer = new Timer(30, this);
        this.setPreferredSize(new Dimension(1200, 800));
        this.startScreen = Util.loadImage("assets/startScreen.png");
        this.startButton.setBounds(525, 650, 150, 30);
        this.startButton.setFont(new Font("Arial", 0, 25));
        this.setLayout(null);
        this.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BodyPanel.this.initializeProgram();
            }
        });
        this.initializeButtons();
        this.timer.start();
    }

    private void initializeProgram() {
        this.programState = 1;
        this.remove(this.startButton);
        this.remove(this.resetButton);
        this.add(this.addBacteriaButton);
        this.add(this.addVirusButton);
        this.add(this.addMacrophageButton);
        this.add(this.addTCellButton);
        this.add(this.addAntibodyButton);
        this.respawnCellsTimer = 100;
        this.respawnBodyCellsTimer = 100;
        this.respawnOrganCellsTimer = 1000;
        int i = 0;
        while (i < this.initialMacrophage) {
            immuneCellList.add(new Macrophage(Util.random(100.0, 1000.0), Util.random(50.0, 750.0), Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 50, 50, 1.0));
            ++i;
        }
        i = 0;
        while (i < this.initialBodyCell) {
            bodyCellList.add(new BodyCell(Util.random(100.0, 800.0), Util.random(50.0, 750.0), Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 80, 80, 1.0));
            ++i;
        }
        i = 1090;
        while (i <= 1170) {
            int j = 80;
            while (j < 800) {
                bodyCellList.add(new OrganCell(i, j, 0.0f, 0.0f, 70, 70, 1.0));
                j += 80;
            }
            i += 80;
        }
        i = 0;
        while (i < 900) {
            organCellWallList.add(new OrganCellWall(980.0f, i, 0.0f, 0.0f, 80, 80, 1.0));
            i += 80;
        }
        energy = bodyCellList.size() * 100;
        if ((double)Util.random(0.0, 1.0) > 0.5) {
            int initialBacteria = 15;
            int i2 = 0;
            while (i2 < initialBacteria) {
                intruderList.add(new Bacteria(Util.random(100.0, 600.0), Util.random(50.0, 750.0), Util.random(-3.0, 3.0), Util.random(-3.0, 3.0), 20, 15, 1));
                ++i2;
            }
        } else {
            this.bodyCellIterator();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.programState == 1) {
            try {
                BaseCell in;
                int i = 0;
                while (i < intruderList.size()) {
                    BaseCell in2 = intruderList.get(i);
                    in2.move();
                    ++i;
                }
                i = 0;
                while (i < immuneCellList.size()) {
                    BaseCell t;
                    int b;
                    BaseImmuneCell ic = immuneCellList.get(i);
                    ic.move();
                    if (ic instanceof TCell) {
                        int o = 0;
                        while (o < immuneCellList.size()) {
                            if (immuneCellList.get(o) instanceof Macrophage) {
                                BaseCell macro = immuneCellList.get(o);
                                ic.goTowards(macro);
                                if (ic.collideWith(macro)) {
                                    Macrophage m = (Macrophage)macro;
                                    m.increaseEnergy(5);
                                }
                            }
                            ++o;
                        }
                    } else if (ic instanceof Macrophage) {
                        ic.goTowards(intruderList);
                        b = 0;
                        while (b < intruderList.size()) {
                            t = intruderList.get(b);
                            if (ic.collideWith(t)) {
                                ic.decreaseEnergy(20);
                                intruderList.remove(t);
                            }
                            ++b;
                        }
                    } else {
                        b = 0;
                        while (b < intruderList.size()) {
                            t = intruderList.get(b);
                            if (ic.collideWith(t)) {
                                t.setVel(t.getVel().x / 2.0f, t.getVel().y / 2.0f);
                                ic.setVel(t.getVel().x, t.getVel().y);
                            }
                            ++b;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < bodyCellList.size()) {
                    BaseBodyCell bc = (BaseBodyCell)bodyCellList.get(i);
                    bc.move();
                    if (bc instanceof BodyCell) {
                        BodyCellDecorator bci;
                        BodyCell b = (BodyCell)bc;
                        if (b.getInfected() && !b.hasInfectedCell()) {
                            if (b.getInfectedTimer() >= 200) {
                                bci = new BodyCellSlightInfected(bc);
                                b.setInfectedCell(bci);
                                infectedCellList.add(bci);
                            } else if (b.getInfectedTimer() > 100) {
                                bci = new BodyCellInfected(bc);
                                b.setInfectedCell(bci);
                                infectedCellList.add(bci);
                            }
                        }
                        if (b.getInfectedLevel() != 0 && !b.hasInfectedCell() && b.getInfectedLevel() == 1) {
                            bci = new BodyCellInfected(bc);
                            b.setInfectedCell(bci);
                            infectedCellList.add(bci);
                        }
                    }
                    int v = 0;
                    while (v < intruderList.size()) {
                        in = intruderList.get(v);
                        if (in instanceof Virus && bc.collideWith(in)) {
                            bc.setInfected(true);
                            intruderList.remove(in);
                        }
                        if (in instanceof Bacteria && bc.collideWith(in)) {
                            bc.raiseInfectedLevel();
                            intruderList.remove(in);
                        }
                        ++v;
                    }
                    ++i;
                }
                i = 0;
                while (i < organCellWallList.size()) {
                    OrganCellWall ocw = organCellWallList.get(i);
                    if (!ocw.getPassable()) {
                        int j = 0;
                        while (j < bodyCellList.size()) {
                            BaseCell bc;
                            if (bodyCellList.get(j) instanceof BodyCell && (bc = bodyCellList.get(j)).collideWith(ocw)) {
                                bc.setVel(Util.random(-5.0, -1.0), bc.getVel().y);
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < intruderList.size()) {
                            in = intruderList.get(j);
                            if (in.collideWith(ocw)) {
                                intruderList.remove(in);
                                ocw.setScale(ocw.getScale() - 0.25);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.manageEnergy();
            }
            catch (Exception ex) {
                System.out.println("Error in BodyPanel ActionPerformed method");
            }
        }
        this.manageStates();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.programState == 1) {
            background.drawBackground(g2);
            int i = 0;
            while (i < intruderList.size()) {
                BaseCell in = intruderList.get(i);
                in.drawCell(g2);
                ++i;
            }
            i = 0;
            while (i < immuneCellList.size()) {
                BaseCell ic = immuneCellList.get(i);
                ic.drawCell(g2);
                ++i;
            }
            i = 0;
            while (i < bodyCellList.size()) {
                BaseCell bc = bodyCellList.get(i);
                bc.drawCell(g2);
                ++i;
            }
            i = 0;
            while (i < organCellWallList.size()) {
                BaseCell ocw = organCellWallList.get(i);
                ocw.drawCell(g2);
                ++i;
            }
            if (infectedCellList.size() != 0) {
                i = 0;
                while (i < infectedCellList.size()) {
                    BaseCell ibc = infectedCellList.get(i);
                    ibc.drawCell(g2);
                    ++i;
                }
            }
            g2.setColor(new Color(67, 219, 49));
            g2.drawString("Body Energy: " + Integer.toString(energy), 10, 15);
        } else if (this.programState == 0) {
            g2.drawImage((Image)this.startScreen, 0, 0, null);
        } else if (this.programState == 2) {
            g2.setColor(Color.red);
            g2.setFont(new Font("Arial", 0, 60));
            g2.drawString("HOST IS IN CRITICAL CONDITION", 150, 300);
            g2.setFont(new Font("Arial", 0, 30));
            g2.drawString("The body can do nothing anymore", 400, 380);
        } else if (this.programState == 3) {
            background.drawBackground(g2);
            g2.setColor(Color.white);
            g2.setFont(new Font("Arial", 0, 60));
            g2.drawString("THE INTRUDERS HAVE BEEN", 200, 300);
            g2.drawString("ELIMINATED", 450, 380);
        }
    }

    private void manageEnergy() {
        int i;
        int j;
        energy = bodyCellList.size() * 100;
        if (energy > 4000) {
            energy = 4000;
        }
        if (energy <= 0) {
            this.programState = 2;
        }
        if (energy >= 4000 && infectedCellList.size() == 0 && intruderList.size() == 0) {
            this.programState = 3;
        }
        --this.respawnCellsTimer;
        --this.respawnBodyCellsTimer;
        --this.respawnOrganCellsTimer;
        if (this.respawnOrganCellsTimer == 0) {
            this.removeOldOrganCells();
            j = 80;
            while (j < 800) {
                bodyCellList.add(new OrganCell(1170.0f, j, 0.0f, 0.0f, 70, 70, 1.0));
                j += 80;
            }
            i = 0;
            while (i < organCellWallList.size()) {
                OrganCellWall ocw = organCellWallList.get(i);
                ocw.setScale(ocw.getScale() + 0.25);
                ++i;
            }
        }
        if (this.respawnOrganCellsTimer == -500) {
            this.removeOldOrganCells();
            j = 80;
            while (j < 800) {
                bodyCellList.add(new OrganCell(1090.0f, j, 0.0f, 0.0f, 70, 70, 1.0));
                j += 80;
            }
            this.respawnOrganCellsTimer = 2000;
        }
        if (this.respawnBodyCellsTimer < 0 && energy < 4000) {
            BodyPanel.addBodyCellAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
            this.respawnBodyCellsTimer = 150;
        }
        if (intruderList.size() != 0) {
            if (energy < 1000 && this.respawnCellsTimer < 0) {
                BodyPanel.addTCellAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                i = 0;
                while (i < 10) {
                    BodyPanel.addAntibodyAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    BodyPanel.addMacrophageAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                this.respawnCellsTimer = 100;
                energy -= 50;
                this.organCellWallIterator();
            } else if (energy < 2500 && this.respawnCellsTimer < 0) {
                i = 0;
                while (i < 2) {
                    BodyPanel.addTCellAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                i = 0;
                while (i < 30) {
                    BodyPanel.addAntibodyAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                i = 0;
                while (i < 3) {
                    BodyPanel.addMacrophageAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                this.respawnCellsTimer = 75;
                energy -= 150;
                this.organCellWallIterator();
            } else if (energy < 3100 && this.respawnCellsTimer < 0) {
                i = 0;
                while (i < 1) {
                    BodyPanel.addTCellAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                i = 0;
                while (i < 10) {
                    BodyPanel.addAntibodyAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    BodyPanel.addMacrophageAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                this.respawnCellsTimer = 80;
                energy -= 100;
                this.organCellWallIterator();
            } else if (energy < 3700 && this.respawnCellsTimer < 0) {
                i = 0;
                while (i < 5) {
                    BodyPanel.addAntibodyAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    BodyPanel.addMacrophageAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
                    ++i;
                }
                this.respawnCellsTimer = 70;
                energy -= 100;
                this.organCellWallIterator();
            }
        }
    }

    private void manageStates() {
        if (this.programState == 2 && --energy == -1) {
            this.resetButton.setBounds(525, 650, 150, 30);
            this.setLayout(null);
            this.remove(this.addBacteriaButton);
            this.remove(this.addVirusButton);
            this.remove(this.addMacrophageButton);
            this.remove(this.addTCellButton);
            this.remove(this.addAntibodyButton);
            this.add(this.resetButton);
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    intruderList.clear();
                    immuneCellList.clear();
                    bodyCellList.clear();
                    infectedCellList.clear();
                    organCellWallList.clear();
                    energy = 0;
                    BodyPanel.this.initializeProgram();
                }
            });
        }
        if (this.programState == 3 && ++energy == 4001) {
            this.resetButton.setBounds(525, 650, 150, 30);
            this.setLayout(null);
            this.remove(this.addBacteriaButton);
            this.remove(this.addVirusButton);
            this.remove(this.addMacrophageButton);
            this.remove(this.addTCellButton);
            this.remove(this.addAntibodyButton);
            this.add(this.resetButton);
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    intruderList.clear();
                    immuneCellList.clear();
                    bodyCellList.clear();
                    infectedCellList.clear();
                    organCellWallList.clear();
                    energy = 0;
                    BodyPanel.this.initializeProgram();
                }
            });
        }
    }

    private void removeOldOrganCells() {
        int i = 0;
        while (i < bodyCellList.size()) {
            if (bodyCellList.get(i) instanceof OrganCell) {
                BaseCell oc = bodyCellList.get(i);
                if (oc.getPos().x == 1170.0f && this.respawnOrganCellsTimer == 0) {
                    bodyCellList.remove(oc);
                }
                if (oc.getPos().x == 1090.0f && this.respawnOrganCellsTimer == -500) {
                    bodyCellList.remove(oc);
                }
            }
            ++i;
        }
    }

    private void bodyCellIterator() {
        try {
            BodyCell bc;
            ListIterator<BaseCell> litr = bodyCellList.listIterator();
            int amountInfected = 0;
            int index = -1;
            while (litr.hasNext()) {
                ++index;
                if (!(litr.next() instanceof BodyCell)) continue;
                bc = (BodyCell)bodyCellList.get(index);
                if (!(Util.random(0.0, 100.0) < 10.0f)) continue;
                bc.setInfected(true);
                ++amountInfected;
            }
            if (amountInfected == 0) {
                bc = (BodyCell)bodyCellList.get(0);
                bc.setInfected(true);
            }
        }
        catch (Exception e) {
            System.out.println("Error in BodyCellIterator");
        }
    }

    private void organCellWallIterator() {
        ListIterator<OrganCellWall> litr = organCellWallList.listIterator();
        int index = -1;
        while (litr.hasNext()) {
            OrganCellWall ocw = litr.next();
            if (ocw.getScale() <= 0.5) {
                ocw.setPassable(true);
                continue;
            }
            ocw.setPassable(false);
        }
    }

    public static int getEnergy() {
        return energy;
    }

    public static void addVirusAtPosition(float x, float y) {
        intruderList.add(new Virus(x, y, Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 5, 5, 1));
    }

    public static void addBacteriaAtPosition(float x, float y) {
        intruderList.add(new Bacteria(x, y, Util.random(-3.0, 3.0), Util.random(-3.0, 3.0), 5, 5, 1));
    }

    public static void addMacrophageAtPosition(float x, float y) {
        immuneCellList.add(new Macrophage(x, y, Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 50, 50, 1.0));
    }

    public static void addTCellAtPosition(float x, float y) {
        immuneCellList.add(new TCell(x, y, Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 20, 20, 1.0));
    }

    public static void addAntibodyAtPosition(float x, float y) {
        immuneCellList.add(new Antibody(x, y, Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 20, 20, 1.0));
    }

    public static void addBodyCellAtPosition(float x, float y) {
        bodyCellList.add(new BodyCell(x, y, Util.random(-5.0, 5.0), Util.random(-5.0, 5.0), 80, 80, 1.0));
    }

    private void initializeButtons() {
        this.addBacteriaButton.setBounds(120, 750, 150, 20);
        this.addVirusButton.setBounds(290, 750, 150, 20);
        this.addMacrophageButton.setBounds(460, 750, 150, 20);
        this.addTCellButton.setBounds(630, 750, 150, 20);
        this.addAntibodyButton.setBounds(800, 750, 150, 20);
        this.addBacteriaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BodyPanel.addBacteriaAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
            }
        });
        this.addVirusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BodyPanel.addVirusAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
            }
        });
        this.addMacrophageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BodyPanel.addMacrophageAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
            }
        });
        this.addTCellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BodyPanel.addTCellAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
            }
        });
        this.addAntibodyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BodyPanel.addAntibodyAtPosition(Util.random(100.0, 1000.0), Util.random(50.0, 750.0));
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                intruderList.clear();
                immuneCellList.clear();
                bodyCellList.clear();
                infectedCellList.clear();
                organCellWallList.clear();
                energy = 0;
                BodyPanel.this.initializeProgram();
            }
        });
    }
}

