function [Irad,th,xp] = rad( I )

DEBUG = 1;

[nx,ny] = size(I);

fprintf( 1, 'Entering function rad...\n' );
fprintf( 1, '  size of image: %d x %d\n', nx, ny );

if DEBUG 
  imagesc(I), colormap(1-gray), title('Original image'), mypause; 
  % print -deps algo1.eps
end;

%%%
%%% Filter image using Laplacian:
%%%

fprintf( 1, '  applying Laplacian filter...\n' );
h = [-1 -1 -1; -1 8 -1; -1 -1 -1];
Ilap = filter2( h, I );

if DEBUG 
  imagesc(Ilap), colormap(gray), title('Laplacian filter'), mypause;
  % print -deps algo2.eps
end;

%%%
%%% Edge detection:
%%%

edgealg = 'sobel';      % options: log, prewitt, roberts, 
                      %   zerocross, log, sobel (default)
fprintf( 1, '  performing %s edge detection...\n', edgealg );
Iedge = edge(Ilap, edgealg );    
% Iedge = edge(I, 'log');   
% Iedge = Iedge( 2:nx-1, 2:ny-1 ); % get rid of spurious boundary values 

if DEBUG 
  imagesc(Iedge), colormap(1-gray), title('Edge detect' ), mypause;
  % print -deps algo3.eps
end;


%%%
%%% Compute the Radon transform:
%%%

fprintf( 1, '  performing Radon transform...\n' );
th = 0:179;
[Irad,xp] = radon(Iedge,th);
[nix,niy] = size(Irad);

fprintf( 1, '  size of Radon transform: %d x %d\n', nix, niy );

% imwrite( Iedge, 'edge.jpg', 'jpeg' );
if DEBUG 
  imagesc(th,xp,Irad), colormap(jet), colorbar, ...
      xlabel('\th (degrees)' ), ylabel('x'''), title('Radon transform' ), ...
      mypause
  % print -deps algo4.eps
end;

fprintf( 1, 'Exiting function rad.\n' );
