%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% runrad.m:
%%%
%%% Compute the Radon transform of an image, and 
%%% then invert the trasform and display the linear
%%% features on top of the original image.
%%%
%%% Date:   June 24, 1998.
%%% Author: John Stockie.
%%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Read the image:

fprintf( 1, 'Reading image...\n\n' );
% I = double( imread( 'images/VEG5.TIF' ));
I = double( imread( 'images/VEG5c.TIF' ));
% I = double( imread( 'images/file5_b4.tif' ));
% I = I(1:200,:);

% I = 1.0 - double( imread( 'images/ideal1.tif' )); 
% I = I(75:224,:);
% I = I(113:187,:);
% I = I(127:164,:);

% images d1, d2, d3:
% I = I( 75:275,:);
% I = I(100:250,:);
% I = I(125:225,:);

% images e1, e2, e3:
% I = I(200:400,:);
% I = I(225:375,:);
% I = I(250:350,:);

%%% Normalise the matrix so that the values are 
%%% between 0 and 1

Iraw = I;         % save original
I = ( I - min(I(:)) ) / ( max(I(:)) - min(I(:)) );

%%% Transpose the image so the number of columns is largest.

[nx,ny] = size(I);
if ny < nx 
  I = I';
  [nx,ny] = size(I);
end;
  
%%% Run function 'rad' to do filtering, edge 
%%% detection, and Radon  transform.

[R, th, xp] = rad( I );

%%% Invert the Radon transform and plot the results using a 
%%% call to 
%%%
%%%   plotinvr( Image, Radon, theta, xp, threshold, invopt, maxlines );

% plotinvr( I, R, th, xp, 2.4e-4, 1, 50 );
plotinvr( I, R, th, xp, 0.2, 5, 50 );


