clc
close all;
clear all;

%%%%%%%%%%IPv6/4 anonymization%%%%%%%
path=[cd '\gawk\'];
name=[path 'both.txt'];
name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%




%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%


%%   IPv4 ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv4source= (zeros(size(IPv4source)));
% IPv4destination= (zeros(size(IPv4destination)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source(:,3:4)= zeros(size(IPv4source,1),2);
IPv4destination(:,3:4)= zeros(size(IPv4source,1),2);


%% randomized
% IPv4source= (round(rand(size(IPv4source))*65536));
% IPv4destination= (round(rand(size(IPv4destination))*65536));


nameano='10outv4truncationano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);


%% iPv4 anonymization ends
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%% IPv6 anonymization starts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields

%% IPv6  ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv6d= (zeros(size(IPv6d)));
% IPv6s= (zeros(size(IPv6d)));
% IPv4sout=(zeros(size(IPv6d)));
% IPv4dout=(zeros(size(IPv6d)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
% IPv6d= ((ones(size(IPv6d))*1));
% IPv6s= ((ones(size(IPv6d))*1));
% IPv4sout=((ones(size(IPv6d))*1));
% IPv4dout=((ones(size(IPv6d))*1));

%% randomized
IPv4sout=IPv6s(:,1:4);
IPv4dout=IPv6d(:,1:4);

IPv6d=(zeros(size(IPv6d)));
IPv6s=(zeros(size(IPv6d)));


lines = size(IPv6s,1);


%% Anonymized IPv6 address output
nameano='10outv6truncationano.txt';



writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);



%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file

nameano='10outtruncationano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,1,nameano);
