function varargout = anonymization_tool(varargin)
%ANONYMIZATION_TOOL M-file for anonymization_tool.fig
%      ANONYMIZATION_TOOL, by itself, creates a new ANONYMIZATION_TOOL or raises the existing
%      singleton*.
%
%      H = ANONYMIZATION_TOOL returns the handle to a new ANONYMIZATION_TOOL or the handle to
%      the existing singleton*.
%
%      ANONYMIZATION_TOOL('Property','Value',...) creates a new ANONYMIZATION_TOOL using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to anonymization_tool_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      ANONYMIZATION_TOOL('CALLBACK') and ANONYMIZATION_TOOL('CALLBACK',hObject,...) call the
%      local function named CALLBACK in ANONYMIZATION_TOOL.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help anonymization_tool

% Last Modified by GUIDE v2.5 07-Jul-2015 16:05:17

% Begin initialization code - DO NOT EDIT
clc;
gui_Singleton = 0;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @anonymization_tool_OpeningFcn, ...
                   'gui_OutputFcn',  @anonymization_tool_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before anonymization_tool is made visible.
function anonymization_tool_OpeningFcn(hObject, ~, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure100
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

set(handles.prefix_preserving,'Enable','off');
set(handles.anon_black_marker,'Enable','off');
set(handles.time_preci_deg,'Enable','off');
set(handles.reverse_truncation,'Enable','off');
set(handles.truncation,'Enable','off');
set(handles.time_ran_shift,'Enable','off');

set(handles.mrt_anon_black_marker,'Enable','off');
set(handles.prefix_preserving_mrt1,'Enable','off');
set(handles.reverse_truncation_mrt,'Enable','off');
set(handles.time_preci_mrt,'Enable','off');
set(handles.time_rand_mrt,'Enable','off');
set(handles.truncation_mrt,'Enable','off');

set(handles.dataset,'Enable','off');

set(handles.packet_length_pdf_cdf,'Enable','off');
set(handles.protocol_distribution,'Enable','off');
set(handles.packet_length_distribution,'Enable','off');
set(handles.throughput,'Enable','off');
set(handles.emperical_distribution,'Enable','off');
set(handles.boxplot,'Enable','off');
set(handles.volume_bytes,'Enable','off');
set(handles.volume_packet,'Enable','off');

%wang
set(handles.volume_curve_fitting,'Enable','off');
%wang

set(handles.Input_pcap_file,'Enable','off');
set(handles.input_mrt_file,'Enable','off');

% Choose default command line output for anonymization_tool
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes anonymization_tool wait for user response (see UIRESUME)
% uiwait(handles.figure1);

function upload_input_file_Callback(~, ~, handles)
% hObject    handle to upload_input_file (see )
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] =uigetfile( ...
{'*.txt','BGP Desing Matrix (*.out)'},...
 'Open');
global full_path_name;
full_path_name=[PathName,FileName];

%wang
if isequal(FileName,0)
  %disp('User selected Cancel')
  set(handles.Input_pcap_file,'Enable','off');
  set(handles.input_mrt_file,'Enable','off'); 
else
  % disp(['User selected ', fullfile(pathname, filename)])
   set(handles.Input_pcap_file,'Enable','on');
   set(handles.input_mrt_file,'Enable','on');  
end
%wang

%set(handles.Input_pcap_file,'Enable','on');
%set(handles.input_mrt_file,'Enable','on');


%wang -- every button off
set(handles.prefix_preserving,'Enable','off');
set(handles.anon_black_marker,'Enable','off');
set(handles.time_preci_deg,'Enable','off');
set(handles.reverse_truncation,'Enable','off');
set(handles.truncation,'Enable','off');
set(handles.time_ran_shift,'Enable','off');

set(handles.mrt_anon_black_marker,'Enable','off');
set(handles.prefix_preserving_mrt1,'Enable','off');
set(handles.reverse_truncation_mrt,'Enable','off');
set(handles.time_preci_mrt,'Enable','off');
set(handles.time_rand_mrt,'Enable','off');
set(handles.truncation_mrt,'Enable','off');

set(handles.dataset,'Enable','off');

set(handles.packet_length_pdf_cdf,'Enable','off');
set(handles.protocol_distribution,'Enable','off');
set(handles.packet_length_distribution,'Enable','off');
set(handles.throughput,'Enable','off');
set(handles.emperical_distribution,'Enable','off');
set(handles.boxplot,'Enable','off');
set(handles.volume_bytes,'Enable','off');
set(handles.volume_packet,'Enable','off');

set(handles.volume_curve_fitting,'Enable','off');
%wang--


% hObject    handle to Clear_window (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.anoymized_text,'String', '');
cla reset;
%wang--







function varargout = anonymization_tool_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure100
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in exit.
function exit_Callback(hObject, eventdata, handles)
% hObject    handle to exit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(gcf);

% --- Executes on button press in input_mrt_file.
function input_mrt_file_Callback(hObject, eventdata, handles)
% hObject    handle to input_mrt_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global full_path_name; 
nam=full_path_name; % Upload mrt input file - AAM

nam = strcat('"',nam,'"');

pathhome=cd;
path=[cd '\gawk\'];
%nam=full_path_name;
cd(path);
global parsed_name;
file='parsed.txt';
parsed_name=[path file];
dos(['gawk -f mrtp.txt ' nam ' >' file]); % Extract relevant information from mrt trace and store it as parsed.txt -AAM
cd(pathhome)

%% ******************Anonymization options**********
set(handles.mrt_anon_black_marker,'Enable','on');
set(handles.prefix_preserving_mrt1,'Enable','on');
set(handles.reverse_truncation_mrt,'Enable','on');
set(handles.time_preci_mrt,'Enable','on');
set(handles.time_rand_mrt,'Enable','on');
set(handles.truncation_mrt,'Enable','on');
%*************************************************

%wang -- pcap off
set(handles.prefix_preserving,'Enable','off');
set(handles.time_preci_deg,'Enable','off');
set(handles.anon_black_marker,'Enable','off');
set(handles.reverse_truncation,'Enable','off');
set(handles.time_ran_shift,'Enable','off');
set(handles.truncation,'Enable','off');

set(handles.Input_pcap_file,'Enable','off');
set(handles.input_mrt_file,'Enable','off');
%wang

%wang--buffer clear
%set(handles.anoymized_text,'String', '');
%global anon_parsed_name;
%fclose(anon_parsed_name);
%wang

%%*******************Analysis options***************%

set(handles.dataset,'Enable','off');

% set(handles.protocol_distribution,'Enable','on');
% set(handles.packet_length_distribution,'Enable','on');
% set(handles.throughput,'Enable','on');
% set(handles.emperical_distribution,'Enable','on');
% set(handles.boxplot,'Enable','on');
% set(handles.volume_bytes,'Enable','on');
% set(handles.volume_packet,'Enable','on');
% set(handles.prefix_preserving,'Enable','on');
%***************************************************%





% --- Executes on button press in volume_packet.
function volume_packet_Callback(~, eventdata, handles)

%wang
cla reset;
%wang

global parsed_name1;
fid=fopen(parsed_name1); 
%% Reading the parameters
time=[];

length2=[];

while 1 % For each line -AAM

    
    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know where the spaces are
       
       %% First collate time of packets -AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       
       %% Second the protocol (in the middle there are the IP addresses) - AAM
       
       p=line(spaces(3)+1:spaces(4)-1);
       
   
           %% Third the length of packet -AAM
       length2=[length2 str2num(line((spaces(4)+1):end))];
            
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);


[packetspsecond,x]=hist(time,ceil(max(time)));% stadistics every 1 second, to show every milisecond, edit ceil max(time) to ceil max(time*1000) - AAM

axesHandle= findobj(gcf,'Tag','figure100');

grid on
bar(x,packetspsecond)
ylabel('Packets/second')
xlabel('Time (seconds)')

guidata(gcbo, handles);

% --- Executes on button press in volume_bytes.
function volume_bytes_Callback(~, eventdata, handles)

%wang
cla reset;
%wang
global parsed_name1;
fid=fopen(parsed_name1); 

time=[];

length2=[];

while 1 % For each line - AAM

    
    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know wher the spaces are
       
       %% First collate the time packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       
       p=line(spaces(3)+1:spaces(4)-1);
       
   
           %% Third the length - AAM
       length2=[length2 str2num(line((spaces(4)+1):end))];
           
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);

[packetspsecond,x]=hist(time,ceil(max(time*2)));% staistics every 0.5 seconds, to show every second replace *2 by *100 -AAM

length(packetspsecond);
bytes=zeros(1,length(packetspsecond)); % Initiate all values to zero - AAM
%% bytes each 0.00001 seconds 
positions=[1 ,cumsum(packetspsecond)];
for i=1:(length(positions)-1)
   bytes(i)=sum(length2(positions(i):positions(i+1)));    
end

global axesHandle;
axesHandle= findobj(gcf,'Tag','figure100');

grid on
bar(x,bytes)
hold on
legend('Packet arrival vs. time', 'Location', 'NorthEast');

ylabel('Traffic (bytes)')
xlabel('Time (seconds)')
guidata(gcbo, handles);
hist(time,ceil(max(time*2)))

% --- Executes on button press in protocol_distribution.
function protocol_distribution_Callback(hObject, eventdata, handles)

%wang
cla reset;
%wang

global parsed_name1;
%global full_path_name;
name=parsed_name1;
fid=fopen(name);

%% Reading the parameters

time=[];
time1=[];
time2=[];
time3=[];
time4=[];
time5=[];
time6=[];
time7=[];
protocol=[];
lengthpp=[];%length per packet
lengthpp1=[];
lengthpp2=[];
lengthpp3=[];
lengthpp4=[];
lengthpp5=[];
lengthpp6=[];
lengthpp7=[];

while 1 % For each line -AAM

    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know where the spaces are
       
       %% First collate the time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       %%j;
       p=line(spaces(3)+1:spaces(4)-1);
       
   
       %% Third the length of packet - AAM
       lengthpp=[lengthpp (str2num(line((spaces(4)+1):end)))];
       l=str2num(line((spaces(4)+1):end));
       %% counting the prtocols
       switch p
           case 'IPv4'
               protocol=[protocol 1];
               time1=[time1 t];
               lengthpp1=[lengthpp1 l];
           case 'UDP'
               protocol=[protocol 2];
               time2=[time2 t];
               lengthpp2=[lengthpp2 l];
          case 'TCP'
               protocol=[protocol 3];
               time3=[time3 t];
               lengthpp3=[lengthpp3 l];
           case 'ICMP'
               protocol=[protocol 4]; 
               time4=[time4 t];
               lengthpp4=[lengthpp4 l];
           case 'DNS'
               protocol=[protocol 5];
               time5=[time5 t];
               lengthpp5=[lengthpp5 l];
           case 'BGP'
               protocol=[protocol 6];   
               time6=[time6 t];
               lengthpp6=[lengthpp6 l];

       end
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);


[packetspsecond,x]=hist(time,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100' 10000

packetspsecond1=hist(time1,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond2=hist(time2,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond3=hist(time3,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond4=hist(time4,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond5=hist(time5,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond6=hist(time6,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
%packetspsecond7=hist(time7,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'


axesHandle= findobj(gcf,'Tag','figure100');

grid on
plot(x,packetspsecond1,'b')
hold on
plot(x,packetspsecond2,'-bo')
plot(x,packetspsecond3,'-m*')
plot(x,packetspsecond4,'y')
plot(x,packetspsecond5,'k')
plot(x,packetspsecond6,'g')

axis tight
ylabel('Packets/second')
xlabel('Time (seconds)')

legend('IPv4','UDP','TCP','ICMP','DNS','BGP')

guidata(gcbo, handles);

% --- Executes on button press in volume_curve_fitting.
function volume_curve_fitting_Callback(hObject, eventdata, handles)
% hObject    handle to volume_curve_fitting (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Created by AAM

%wang
cla reset;
%wang

global parsed_name1;
fid=fopen(parsed_name1); 

time=[];

length2=[];

while 1 % For each line - AAM

    
    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know where the spaces are
       
       %% First collate time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       
       p=line(spaces(3)+1:spaces(4)-1);
       
   
           %% Third the length of packet - AAM
       length2=[length2 str2num(line((spaces(4)+1):end))];
           
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);

[packetspsecond,x]=hist(time,ceil(max(time*2)));% staistics every 0.5 seconds, to show every second replace *2 by *100 -AAM

length(packetspsecond);
bytes=zeros(1,length(packetspsecond)); % Initiate all values to zero - AAM
%% bytes each 0.00001 seconds 
positions=[1 ,cumsum(packetspsecond)];
for i=1:(length(positions)-1)
   bytes(i)=sum(length2(positions(i):positions(i+1)));    
end

axesHandle= findobj(gcf,'Tag','figure100');

grid on

%Polynomial curve fit with degree 1 -AAM
p=polyfit(x,bytes,1);
y2=polyval(p,time);
plot (x, bytes, 'k.')
hold on
plot(time,y2,'r-')
hold on
% Exponential curve fit -AAM
[xData, yData] = prepareCurveData( x, bytes );
ft = fittype( 'exp1' );
[fitresult, gof] = fit (xData,yData,ft);
plot (fitresult,'g-');
hold on
% Fourier curve fit - AAM
[xDataf, yDataf] = prepareCurveData (x,bytes);
ftf= fittype ('fourier1');
[fitresultf,goff] = fit (xDataf, yDataf, ftf);
plot (fitresultf, 'b-');

legend('Packet arrival vs. time', 'Polynomial','Exponential', 'Fourier', 'Location', 'NorthEast');

ylabel('Traffic (bytes)')
xlabel('Time (seconds)')
guidata(gcbo, handles);
hist(time,ceil(max(time*2)))

% --- Executes on button press in packet_length_distribution.
function packet_length_distribution_Callback(hObject, eventdata, handles)

%wang
cla reset;
%wang


global parsed_name1;

name=parsed_name1;
fid=fopen(name);

%% Reading the parameters

time=[];
time1=[];
time2=[];
time3=[];
time4=[];
time5=[];
time6=[];
time7=[];
protocol=[];
lengthpp=[];%length per packet
lengthpp1=[];
lengthpp2=[];
lengthpp3=[];
lengthpp4=[];
lengthpp5=[];
lengthpp6=[];
lengthpp7=[];

while 1 % For each line - AAM

    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know where the spaces are
       
       %% First collate time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       
       p=line(spaces(3)+1:spaces(4)-1);
       
   
       %% Third the length of packets - AAM
       lengthpp=[lengthpp (str2num(line((spaces(4)+1):end)))];
       l=str2num(line((spaces(4)+1):end));
       %% counting the prtocols
       switch p
           case 'IPv4'
               protocol=[protocol 1];
               time1=[time1 t];
               lengthpp1=[lengthpp1 l];
           case 'UDP'
               protocol=[protocol 2];
               time2=[time2 t];
               lengthpp2=[lengthpp2 l];
          case 'TCP'
               protocol=[protocol 3];
               time3=[time3 t];
               lengthpp3=[lengthpp3 l];
           case 'ICMP'
               protocol=[protocol 4]; 
               time4=[time4 t];
               lengthpp4=[lengthpp4 l];
           case 'DNS'
               protocol=[protocol 5];
               time5=[time5 t];
               lengthpp5=[lengthpp5 l];
           case 'BGP'
               protocol=[protocol 6];   
               time6=[time6 t];
               lengthpp6=[lengthpp6 l];
%            
       end
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);


%[packetspsecond,x]=hist(time,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100' 10000
[packetfrecuency,x]=hist(lengthpp,ceil((max(lengthpp)-min(lengthpp)+1)/10));%packet frecuency each 10

axesHandle= findobj(gcf,'Tag','figure100');

%[packetfrecuency,x]=hist(lengthpp,ceil((max(lengthpp)-min(lengthpp)+1)/10));%packet frecuency each 10
hold on
grid on
bar(x,packetfrecuency)
ylabel('Frecuency')
xlabel('Packets lengths ')
%title('Packet length distribution')

guidata(gcbo, handles);
% --- Executes on button press in throughput.

function throughput_Callback(hObject, eventdata, handles)

%wang
cla reset;
%wang

global parsed_name1;

name=parsed_name1;
fid=fopen(name);

%% Reading the parameters

time=[];
time1=[];
time2=[];
time3=[];
time4=[];
time5=[];
time6=[];
time7=[];
protocol=[];
lengthpp=[];%length per packet
lengthpp1=[];
lengthpp2=[];
lengthpp3=[];
lengthpp4=[];
lengthpp5=[];
lengthpp6=[];
lengthpp7=[];

while 1 % For each line - AAM

    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know wher the spaces are
       
       %% First collate time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       p=line(spaces(3)+1:spaces(4)-1);
       %% Third the length of packet - AAM
       lengthpp=[lengthpp (str2num(line((spaces(4)+1):end)))];
       l=str2num(line((spaces(4)+1):end));
       %% counting the prtocols
       switch p
           case 'IPv4'
               protocol=[protocol 1];
               time1=[time1 t];
               lengthpp1=[lengthpp1 l];
           case 'UDP'
               protocol=[protocol 2];
               time2=[time2 t];
               lengthpp2=[lengthpp2 l];
          case 'TCP'
               protocol=[protocol 3];
               time3=[time3 t];
               lengthpp3=[lengthpp3 l];
           case 'ICMP'
               protocol=[protocol 4]; 
               time4=[time4 t];
               lengthpp4=[lengthpp4 l];
           case 'DNS'
               protocol=[protocol 5];
               time5=[time5 t];
               lengthpp5=[lengthpp5 l];
           case 'BGP'
               protocol=[protocol 6];   
               time6=[time6 t];
               lengthpp6=[lengthpp6 l];
%            case 'BGP'
%                protocol=[protocol 7];   
%                time7=[time7 t];
%                lengthpp7=[lengthpp7 l];
       end
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);

[packetspsecond,x]=hist(time,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100' 10000

packetspsecond1=hist(time1,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond2=hist(time2,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond3=hist(time3,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond4=hist(time4,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond5=hist(time5,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'
packetspsecond6=hist(time6,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100'

bytes=zeros(1,length(packetspsecond));%bytes each 0.00001
% bytes each 0.00001 seconds 
positions=[1 ,cumsum(packetspsecond)];
for i=1:(length(positions)-1)
    bytes(i)=sum(lengthpp(positions(i):positions(i+1)));  
end

axesHandle= findobj(gcf,'Tag','figure100');
hold on
grid on
plot(x,bytes,'--rs')
axis tight
ylabel('Bytes/second')
xlabel('Time (seconds)')
title('Througput')

guidata(gcbo, handles);

% --- Executes on button press in emperical_distribution.
function emperical_distribution_Callback(hObject, eventdata, handles)

%wang
cla reset;
%wang

% hObject    handle to emperical_distribution (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global parsed_name1;
name=parsed_name1;
fid=fopen(name);

%% Reading the parameters

time=[];
time1=[];
time2=[];
time3=[];
time4=[];
time5=[];
time6=[];
%time7=[];
protocol=[];
lengthpp=[];%length per packet
lengthpp1=[];
lengthpp2=[];
lengthpp3=[];
lengthpp4=[];
lengthpp5=[];
lengthpp6=[];
%lengthpp7=[];

while 1 % For each line - AAM

    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know where the spaces are
       
       %% First collate time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       j;
       p=line(spaces(3)+1:spaces(4)-1);
   
       %% Third the length of packet - AAM
       lengthpp=[lengthpp (str2num(line((spaces(4)+1):end)))];
       l=str2num(line((spaces(4)+1):end));
       %% counting the prtocols
       switch p
           case 'IPv4'
               protocol=[protocol 1];
               time1=[time1 t];
               lengthpp1=[lengthpp1 l];
           case 'UDP'
               protocol=[protocol 2];
               time2=[time2 t];
               lengthpp2=[lengthpp2 l];
          case 'TCP'
               protocol=[protocol 3];
               time3=[time3 t];
               lengthpp3=[lengthpp3 l];
           case 'ICMP'
               protocol=[protocol 4]; 
               time4=[time4 t];
               lengthpp4=[lengthpp4 l];
           case 'DNS'
               protocol=[protocol 5];
               time5=[time5 t];
               lengthpp5=[lengthpp5 l];
           case 'BGP'
               protocol=[protocol 6];   
               time6=[time6 t];
               lengthpp6=[lengthpp6 l];

       end
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);

[packetspsecond,x]=hist(time,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100' 10000

bytes=zeros(1,length(packetspsecond));%bytes each 0.00001
% bytes each 0.00001 seconds 
positions=[1 ,cumsum(packetspsecond)];
for i=1:(length(positions)-1)
    bytes(i)=sum(lengthpp(positions(i):positions(i+1)));  
end

axesHandle= findobj(gcf,'Tag','figure100');
%% Empirical distriution of packet lengths
grid on
cdfplot(lengthpp)
h = cdfplot(lengthpp)
[h,stats] = cdfplot(lengthpp)
ylabel('Empirical CDF')
xlabel('Packet length')
%title('Empirical CDF of packets lengths')

guidata(gcbo, handles);

% --- Executes on button press in boxplot.
function boxplot_Callback(hObject, eventdata, handles)

%wang
cla reset;
%wang

global parsed_name1;

name=parsed_name1;
fid=fopen(name);

%% Reading the parameters

time=[];
time1=[];
time2=[];
time3=[];
time4=[];
time5=[];
time6=[];
time7=[];
protocol=[];
lengthpp=[];%length per packet
lengthpp1=[];
lengthpp2=[];
lengthpp3=[];
lengthpp4=[];
lengthpp5=[];
lengthpp6=[];
lengthpp7=[];

while 1 % For each line - AAM

    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know where the spaces are
       
       %% First collate time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       j;
       p=line(spaces(3)+1:spaces(4)-1);
          
       %% Third the length of packet - AAM
       lengthpp=[lengthpp (str2num(line((spaces(4)+1):end)))];
       l=str2num(line((spaces(4)+1):end));
       %% counting the prtocols
       switch p
           case 'IPv4'
               protocol=[protocol 1];
               time1=[time1 t];
               lengthpp1=[lengthpp1 l];
           case 'UDP'
               protocol=[protocol 2];
               time2=[time2 t];
               lengthpp2=[lengthpp2 l];
          case 'TCP'
               protocol=[protocol 3];
               time3=[time3 t];
               lengthpp3=[lengthpp3 l];
           case 'ICMP'
               protocol=[protocol 4]; 
               time4=[time4 t];
               lengthpp4=[lengthpp4 l];
           case 'DNS'
               protocol=[protocol 5];
               time5=[time5 t];
               lengthpp5=[lengthpp5 l];
           case 'BGP'
               protocol=[protocol 6];   
               time6=[time6 t];
               lengthpp6=[lengthpp6 l];

       end
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);

[packetspsecond,x]=hist(time,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100' 10000

bytes=zeros(1,length(packetspsecond));%bytes each 0.00001
% bytes each 0.00001 seconds 
positions=[1 ,cumsum(packetspsecond)];
for i=1:(length(positions)-1)
    bytes(i)=sum(lengthpp(positions(i):positions(i+1)));  
end

axesHandle= findobj(gcf,'Tag','figure100');
set(axesHandle, 'Position', [170 27 60 15])
boxplot(lengthpp)
ylabel('Packets lengths ')

guidata(gcbo, handles);

% --- Executes on button press in Input_pcap.
function Input_pcap_file_Callback(hObject, eventdata, handles)
% hObject    handle to Input_pcap_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global full_path_name;
nam=full_path_name; %Upload pcap trace - AAM

nam = strcat('"',nam,'"');

pathhome=cd;
path=[cd '\gawk\'];
%nam=full_path_name;
cd(path);
global parsed_name;
file='parsed.txt';
parsed_name=[path file];
dos(['gawk -f pacp-parsing.txt ' nam ' >' file]); % Extract relevant information from the pcap trace and store in parsed.txt - AAM
cd(pathhome)

%% ******************Anonymization options**********
set(handles.prefix_preserving,'Enable','on');
set(handles.time_preci_deg,'Enable','on');
set(handles.anon_black_marker,'Enable','on');
set(handles.reverse_truncation,'Enable','on');
set(handles.time_ran_shift,'Enable','on');
set(handles.truncation,'Enable','on');
%*************************************************

%wang -- mrt off
%*************************************************
set(handles.mrt_anon_black_marker,'Enable','off');
set(handles.prefix_preserving_mrt1,'Enable','off');
set(handles.reverse_truncation_mrt,'Enable','off');
set(handles.time_preci_mrt,'Enable','off');
set(handles.time_rand_mrt,'Enable','off');
set(handles.truncation_mrt,'Enable','off');

set(handles.Input_pcap_file,'Enable','off');
set(handles.input_mrt_file,'Enable','off');
%wang

%wang--buffer clear
%global anon_parsed_name;
%fclose(anon_parsed_name);
%wang

%%*******************Analysis options***************%

set(handles.dataset,'Enable','off');

% set(handles.protocol_distribution,'Enable','on');
% set(handles.packet_length_distribution,'Enable','on');
% set(handles.throughput,'Enable','on');
% set(handles.emperical_distribution,'Enable','on');
% set(handles.boxplot,'Enable','on');
% set(handles.volume_bytes,'Enable','on');
% set(handles.volume_packet,'Enable','on');
% set(handles.prefix_preserving,'Enable','on');
%***************************************************%


% --- Executes on button press in prefix_preserving.
function prefix_preserving_Callback(hObject, eventdata, handles)

global parsed_name;
name4='ipv4.txt';
name6='ipv6.txt';
%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM

    
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%
% Output of decoded IPv4 source column
v4source= 'v4SColumn.txt';
% Output of decoded IPv4 destination column
v4destination='v4DColumn.txt';

% This gives the size of the input file
inputsize= size(IPv4source,1);
% Time in defind zero because at this point we are not decoding the time data. This need to be fixed. 
% time=0;
% Writing the output of IPv4 decode in a files v4SColumn.txt and v4DColumn.txt.
% Source and destination is writen in two files because Crypto-PAN takes
% input as it this formate (time length, address)
ipv4writefile (v4source,v4destination, time4, ipv4pktlength,IPv4source,IPv4destination,inputsize);


v4Sanonymized='v4sourceanonymized.txt';  % IPv4 source address anonymized
v4Danonymized='v4destinationanonymized.txt';   % IPv4 sdestination address anonymized


[s,s]=dos(['cryto_run.exe ' v4source ' > ' v4Sanonymized]);
[s,s]=dos(['cryto_run.exe ' v4destination ' > ' v4Danonymized]);


[IPv4source,IPv4destination, time4, ipv4pktlength]=ipv4readfile(v4Sanonymized, v4Danonymized, inputsize );

nameano='10outv4ano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);

lines = size(IPv6s,1);

namev4s='10outv4s.txt';
namev4d='10outv4d.txt';

%time=0;

ipv6toipv4writefile(namev4s,namev4d, time6, pktlength, IPv4s, IPv4d,lines );

namev4sout='10outv4sout.txt';
namev4dout='10outv4dout.txt';


[s,s]=dos(['cryto_run.exe ' namev4s ' > ' namev4sout]);
[s,s]=dos(['cryto_run.exe ' namev4d ' > ' namev4dout]);

[IPv4sout,IPv4dout, timeout, pktlengthout]=ipv4toipv6readfile(namev4sout, namev4dout, lines );

%% Anonymized IPv6 address output
nameano='10outv6ano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,nameano);

global anon_parsed_name;

%%%%% Write
%% Anonymized IPv6 address output
nameano='prefix_anonymized.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

%global parsed_name;
% file='parsed.txt';
% parsed_name=[path file];%
%pwd

anon_parsed_name='prefix_anonymized.txt';
set(handles.dataset,'Enable','on');

fid = textread('prefix_anonymized.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);
%**********************  Prefic preserving in PCAP end*************************%


% --- Executes on button press in anon_black_marker.
function anon_black_marker_Callback(hObject, eventdata, handles)
% hObject    handle to anon_black_marker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global parsed_name; %Retrieve anonymized trace - AAM

name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

%f=fopen(name);
f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%


%%   IPv4 ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv4source= (zeros(size(IPv4source)));
% IPv4destination= (zeros(size(IPv4destination)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source= ((ones(size(IPv4source))*1));
IPv4destination= ((ones(size(IPv4destination))*1));


%% randomized
% IPv4source= (round(rand(size(IPv4source))*65536));
% IPv4destination= (round(rand(size(IPv4destination))*65536));


nameano='10outv4blackmarkerano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);


%% iPv4 anonymization ends
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%% IPv6 anonymization starts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields

%% IPv6  ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv6d= (zeros(size(IPv6d)));
% IPv6s= (zeros(size(IPv6d)));
% IPv4sout=(zeros(size(IPv6d)));
% IPv4dout=(zeros(size(IPv6d)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv6d= ((ones(size(IPv6d))*1));
IPv6s= ((ones(size(IPv6d))*1));
IPv4sout=((ones(size(IPv6d))*1));
IPv4dout=((ones(size(IPv6d))*1));

%% randomized
% IPv6d= (round(rand(size(IPv6d))*65536));
% IPv6s= (round(rand(size(IPv6d))*65536));
% IPv4sout=(round(rand(size(IPv6d))*65536));
% IPv4dout=(round(rand(size(IPv6d))*65536));

lines = size(IPv6s,1);


%% Anonymized IPv6 address output
nameano='10outv6blackmarkerano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);

%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file
global anon_parsed_name;
nameano='anonymized.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

anon_parsed_name='anonymized.txt';
set(handles.dataset,'Enable','on');


fid = textread('anonymized.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);

% --- Executes on button press in reverse_truncation.
function reverse_truncation_Callback(hObject, eventdata, handles)
% hObject    handle to reverse_truncation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%%%%%%%%%%IPv6/4 anonymization%%%%%%%

global parsed_name;

name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);

%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%

%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source(:,1:2)= zeros(size(IPv4source,1),2);
IPv4destination(:,1:2)= zeros(size(IPv4source,1),2);

nameano='10outv4reverse_truncationano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);

%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
%% randomized
IPv4sout=zeros(size(IPv6d,1),4);
IPv4dout=zeros(size(IPv6d,1),4);

lines = size(IPv6s,1);

%% Anonymized IPv6 address output
nameano='10outv6reverse_truncationano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);

%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file
global anon_parsed_name;
nameano='10outreverse_truncationano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder,time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4,ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

anon_parsed_name='10outreverse_truncationano.txt';
set(handles.dataset,'Enable','on');

fid = textread('10outreverse_truncationano.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);


% --- Executes on button press in truncation.
function truncation_Callback(hObject, eventdata, handles)
% hObject    handle to truncation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles%%%%%%%%%%IPv6/4 anonymization%%%%%%%
%path=[cd '\gawk\'];
%name=[path 'both.txt'];
global parsed_name;
name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%


%%   IPv4 ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv4source= (zeros(size(IPv4source)));
% IPv4destination= (zeros(size(IPv4destination)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source(:,3:4)= zeros(size(IPv4source,1),2);
IPv4destination(:,3:4)= zeros(size(IPv4source,1),2);


%% randomized
% IPv4source= (round(rand(size(IPv4source))*65536));
% IPv4destination= (round(rand(size(IPv4destination))*65536));

nameano='10outv4truncationano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);


%% iPv4 anonymization ends
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% IPv6 anonymization starts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields

%% IPv6  ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv6d= (zeros(size(IPv6d)));
% IPv6s= (zeros(size(IPv6d)));
% IPv4sout=(zeros(size(IPv6d)));
% IPv4dout=(zeros(size(IPv6d)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
% IPv6d= ((ones(size(IPv6d))*1));
% IPv6s= ((ones(size(IPv6d))*1));
% IPv4sout=((ones(size(IPv6d))*1));
% IPv4dout=((ones(size(IPv6d))*1));

%% randomized
IPv4sout=IPv6s(:,1:4);
IPv4dout=IPv6d(:,1:4);

IPv6d=(zeros(size(IPv6d)));
IPv6s=(zeros(size(IPv6d)));

lines = size(IPv6s,1);

%% Anonymized IPv6 address output
nameano='10outv6truncationano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);

%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file

nameano='10outtruncationano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

global anon_parsed_name;
nameano='10outtruncationano.txt';
anon_parsed_name='10outtruncationano.txt';
set(handles.dataset,'Enable','on');

fid = textread('10outtruncationano.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);


% --- Executes on button press in time_ran_shift.
function time_ran_shift_Callback(hObject, eventdata, handles)
% hObject    handle to time_ran_shift (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global parsed_name; % Retrieve anonymized trace - AAM
name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%Random Shift
timeanony4=time4-(randi(100,1)*time4);

nameano='10outtimerandom_shiftv4ano.txt';
writeipv4anon(timeanony4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);


%% precision degradation
timeanony6=fix(time6*100)/100;

%% Anonymized IPv6 address output
nameano='10outtimev6ano.txt';

writeipv6anon(timeanony6,IPv6s,IPv6d,IPv4s,IPv4d,protocol6,pktlength,nameano);

%%%%% Writ
%% Anonymized IPv6 address output
nameano='10outtimeano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, timeanony6,IPv6s,IPv6d,IPv4s,IPv4d,protocol6,pktlength,timeanony4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPV6 %%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Writing same as the inputfile formate
originalfile='10outtimeano.txt';
finalfile='final.txt';
createpcapipv6(IPv6s,IPv6d,IPv4s,IPv4d,originalfile, finalfile);% This function take a file and replace the IPs with the ones from the anonmization process

global anon_parsed_name;
nameano='10outtimeano.txt';

%Display on Output screen

anon_parsed_name='10outtimeano.txt';
set(handles.dataset,'Enable','on');

fid = textread('10outtimeano.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);

% --- Executes on button press in time_preci_deg.
function time_preci_deg_Callback(hObject, eventdata, handles)

global parsed_name;
name4='ipv4.txt';
name6='ipv6.txt';
%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%
% Output of decoded IPv4 source column
v4source= 'v4SColumn.txt';
% Output of decoded IPv4 destination column
v4destination='v4DColumn.txt';

% This gives the size of the input file
inputsize= size(IPv4source,1);

% precision degradation
time4=fix(time4*10000)/100;

% Length anonymization

ipv4pktlength=ipv4pktlength+100;
% Time in defind zero because at this point we are not decoding the time data. This need to be fixed. 
% time=0;
% Writing the output of IPv4 decode in a files v4SColumn.txt and v4DColumn.txt.
% Source and destination is writen in two files because Crypto-PAN takes
% input as it this formate (time length, address)
ipv4writefile (v4source,v4destination, time4, ipv4pktlength,IPv4source,IPv4destination,inputsize);


v4Sanonymized='v4sourceanonymized.txt';  % IPv4 source address anonymized
v4Danonymized='v4destinationanonymized.txt';   % IPv4 sdestination address anonymized

[s,s]=dos(['cryto_run.exe ' v4source ' > ' v4Sanonymized]);
[s,s]=dos(['cryto_run.exe ' v4destination ' > ' v4Danonymized]);

[IPv4source,IPv4destination, time4, ipv4pktlength]=ipv4readfile(v4Sanonymized, v4Danonymized, inputsize );

nameano='10outv4ano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);

lines = size(IPv6s,1);

namev4s='10outv4s.txt';
namev4d='10outv4d.txt';

%time=0;

%% precision degradation
time6=fix(time6*100)/10000;
pktlength=pktlength+100;

ipv6toipv4writefile(namev4s,namev4d, time6, pktlength, IPv4s, IPv4d,lines );

namev4sout='10outv4sout.txt';
namev4dout='10outv4dout.txt';

[s,s]=dos(['cryto_run.exe ' namev4s ' > ' namev4sout]);
[s,s]=dos(['cryto_run.exe ' namev4d ' > ' namev4dout]);

[IPv4sout,IPv4dout, timeout, pktlengthout]=ipv4toipv6readfile(namev4sout, namev4dout, lines );

%% Anonymized IPv6 address output
nameano='10outv6ano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,nameano);

global anon_parsed_name;
%%%%% Writ
%% Anonymized IPv6 address output
nameano='timepreci_anonymized.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

anon_parsed_name='timepreci_anonymized.txt';

set(handles.dataset,'Enable','on');

fid = textread('timepreci_anonymized.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);

% --- Executes during object creation, after setting all properties.

function anoymized_text_Callback(hObject, eventdata, handles)
% hObject    handle to anoymized_text (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of anoymized_text as text
%        str2double(get(hObject,'String')) returns contents of anoymized_text as a double


% --- Executes during object creation, after setting all properties.
function anoymized_text_CreateFcn(hObject, eventdata, handles)
% hObject    handle to anoymized_text (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on mouse press over axes background.
function figure100_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure100 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object deletion, before destroying properties.
function figure100_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to figure100 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in mrt_anon_black_marker.
function mrt_anon_black_marker_Callback(hObject, eventdata, handles)
% hObject    handle to mrt_anon_black_marker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global parsed_name; % Retrieve anonymized trace - AAM

name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%


%%   IPv4 ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv4source= (zeros(size(IPv4source)));
% IPv4destination= (zeros(size(IPv4destination)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source= ((ones(size(IPv4source))*1));
IPv4destination= ((ones(size(IPv4destination))*1));


%% randomized
% IPv4source= (round(rand(size(IPv4source))*65536));
% IPv4destination= (round(rand(size(IPv4destination))*65536));


nameano='10outv4blackmarkerano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);


%% iPv4 anonymization ends
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% IPv6 anonymization starts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields

%% IPv6  ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv6d= (zeros(size(IPv6d)));
% IPv6s= (zeros(size(IPv6d)));
% IPv4sout=(zeros(size(IPv6d)));
% IPv4dout=(zeros(size(IPv6d)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv6d= ((ones(size(IPv6d))*1));
IPv6s= ((ones(size(IPv6d))*1));
IPv4sout=((ones(size(IPv6d))*1));
IPv4dout=((ones(size(IPv6d))*1));

%% randomized
% IPv6d= (round(rand(size(IPv6d))*65536));
% IPv6s= (round(rand(size(IPv6d))*65536));
% IPv4sout=(round(rand(size(IPv6d))*65536));
% IPv4dout=(round(rand(size(IPv6d))*65536));

lines = size(IPv6s,1);

%% Anonymized IPv6 address output
nameano='10outv6blackmarkerano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);

%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file
global anon_parsed_name;
nameano='anonymized.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);



anon_parsed_name='anonymized.txt';
set(handles.dataset,'Enable','on');


fid = textread('anonymized.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);

% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over mrt_anon_black_marker.
function mrt_anon_black_marker_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to mrt_anon_black_marker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function figure100_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure100 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate figure100


% --------------------------------------------------------------------
function Clear_window_Callback(hObject, eventdata, handles)
% hObject    handle to Clear_window (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.anoymized_text,'String', '');
cla reset;
%set(handles.anoymized_text,'String', '');


% --- Executes on mouse press over figure100 background, over a disabled or
% --- inactive control, or over an axes background.
function figure1_WindowButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Save.
function Save_Callback(hObject, eventdata, handles)
% hObject    handle to Save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Save current state of GUI - AAM
 [FileName,PathName,FilterIndex]=uiputfile({'*.jpg;*.tif;*.png;*.gif','All Image Files';...
          '*.*','All Files' },'Save Image',...
          'C:\newfile.jpg');
     temp=strcat(PathName,FileName);
      h=findobj(0,'Tag','figure100');
      global axesHandle100;
 h= axesHandle100;
 set (gcf, 'PaperPositionMode', 'Auto');
      saveas(handles.figure100,temp, 'jpg');


% --- Executes on selection change in dataset.
function dataset_Callback(hObject, eventdata, handles)

a=get(handles.dataset,'value');
global parsed_name;
global anon_parsed_name;
global parsed_name1;

switch a
    case 1 
            parsed_name1 = parsed_name;
            set(handles.protocol_distribution,'Enable','on');
            set(handles.packet_length_distribution,'Enable','on');
            set(handles.throughput,'Enable','on');
            set(handles.emperical_distribution,'Enable','on');
            set(handles.boxplot,'Enable','on');
            set(handles.volume_bytes,'Enable','on');
            set(handles.volume_curve_fitting,'Enable','on'); % Include volume curve fitting in analysis - AAM
            set(handles.volume_packet,'Enable','on');
            set(handles.packet_length_pdf_cdf,'Enable','on');
    case 2
       
          parsed_name1 = anon_parsed_name; % Retrieve anonymized trace - AAM
            
            set(handles.protocol_distribution,'Enable','on');
            set(handles.packet_length_distribution,'Enable','on');
            set(handles.throughput,'Enable','on');
            set(handles.emperical_distribution,'Enable','on');
            set(handles.boxplot,'Enable','on');
            set(handles.volume_bytes,'Enable','on');
            set(handles.volume_curve_fitting,'Enable','on'); % Include volume curve fitting in analysis - AAM
            set(handles.volume_packet,'Enable','on');
            set(handles.packet_length_pdf_cdf,'Enable','on');
end


% --- Executes during object creation, after setting all properties.
function dataset_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dataset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in packet_length_pdf_cdf.
function packet_length_pdf_cdf_Callback(hObject, eventdata, handles)

% wang 
cla reset;
% wang

% hObject    handle to packet_length_pdf_cdf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global parsed_name1; % Retrieve anonymized trace - AAM
name=parsed_name1;
fid=fopen(name);

%% Reading the parameters

time=[];
time1=[];
time2=[];
time3=[];
time4=[];
time5=[];
time6=[];
time7=[];
protocol=[];
lengthpp=[];%length per packet
lengthpp1=[];
lengthpp2=[];
lengthpp3=[];
lengthpp4=[];
lengthpp5=[];
lengthpp6=[];
lengthpp7=[];

while 1 % For each line
%for j=1:200
    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know wher the spaces are
       
       %% First collate time of packets - AAM
       time=[time str2num(line(1:spaces(1)-1))];
       t=str2num(line(1:spaces(1)-1));
       %% Second the protocol (in the middle there are the IP addresses)
       j;
       p=line(spaces(3)+1:spaces(4)-1);
       
   
       %% Third the length of packet - AAM
       lengthpp=[lengthpp (str2num(line((spaces(4)+1):end)))];
       l=str2num(line((spaces(4)+1):end));
       %% counting the prtocols
       switch p
           case 'IPv4'
               protocol=[protocol 1];
               time1=[time1 t];
               lengthpp1=[lengthpp1 l];
           case 'UDP'
               protocol=[protocol 2];
               time2=[time2 t];
               lengthpp2=[lengthpp2 l];
          case 'TCP'
               protocol=[protocol 3];
               time3=[time3 t];
               lengthpp3=[lengthpp3 l];
           case 'ICMP'
               protocol=[protocol 4]; 
               time4=[time4 t];
               lengthpp4=[lengthpp4 l];
           case 'DNS'
               protocol=[protocol 5];
               time5=[time5 t];
               lengthpp5=[lengthpp5 l];
           case 'BGP'
               protocol=[protocol 6];   
               time6=[time6 t];
               lengthpp6=[lengthpp6 l];

       end
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);

[packetspsecond,x]=hist(time,ceil(max(time*100)));% stadistics every 0.00001 seconds, to show every second remove '*100' 10000

axesHandle= findobj(gcf,'Tag','figure100');

%[packetfrecuency,x]=hist(lengthpp,ceil((max(lengthpp)-min(lengthpp)+1)/10));%packet frecuency each 10

dfittool(lengthpp)
%title('Packet length distribution')

guidata(gcbo, handles);


% --- Executes on button press in prefix_preserving_mrt1.
function prefix_preserving_mrt1_Callback(hObject, eventdata, handles)
% hObject    handle to prefix_preserving_mrt1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global parsed_name; 
name4='ipv4.txt';
name6='ipv6.txt';
%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%
% Output of decoded IPv4 source column
v4source= 'v4SColumn.txt';
% Output of decoded IPv4 destination column
v4destination='v4DColumn.txt';

% This gives the size of the input file
inputsize= size(IPv4source,1);
% Time in defind zero because at this point we are not decoding the time data. This need to be fixed. 
% time=0;
% Writing the output of IPv4 decode in a files v4SColumn.txt and v4DColumn.txt.
% Source and destination is writen in two files because Crypto-PAN takes
% input as it this formate (time length, address)
ipv4writefile (v4source,v4destination, time4, ipv4pktlength,IPv4source,IPv4destination,inputsize);

v4Sanonymized='v4sourceanonymized.txt';  % IPv4 source address anonymized
v4Danonymized='v4destinationanonymized.txt';   % IPv4 sdestination address anonymized

[s,s]=dos(['cryto_run.exe ' v4source ' > ' v4Sanonymized]);
[s,s]=dos(['cryto_run.exe ' v4destination ' > ' v4Danonymized]);

[IPv4source,IPv4destination, time4, ipv4pktlength]=ipv4readfile(v4Sanonymized, v4Danonymized, inputsize );

nameano='10outv4ano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);

lines = size(IPv6s,1);

namev4s='10outv4s.txt';
namev4d='10outv4d.txt';

%time=0;

ipv6toipv4writefile(namev4s,namev4d, time6, pktlength, IPv4s, IPv4d,lines );

namev4sout='10outv4sout.txt';
namev4dout='10outv4dout.txt';

[s,s]=dos(['cryto_run.exe ' namev4s ' > ' namev4sout]);
[s,s]=dos(['cryto_run.exe ' namev4d ' > ' namev4dout]);

[IPv4sout,IPv4dout, timeout, pktlengthout]=ipv4toipv6readfile(namev4sout, namev4dout, lines );

%% Anonymized IPv6 address output
nameano='10outv6ano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,nameano);

global anon_parsed_name;


%% Anonymized IPv6 address output
nameano='prefix_anonymized.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

anon_parsed_name='prefix_anonymized.txt';
set(handles.dataset,'Enable','on');

fid = textread('prefix_anonymized.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);

% --- Executes on button press in reverse_truncation_mrt.
function reverse_truncation_mrt_Callback(hObject, eventdata, handles)
% hObject    handle to reverse_truncation_mrt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%%%%%%%%%%IPv6/4 anonymization%%%%%%%

global parsed_name;

name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);

%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%

%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source(:,1:2)= zeros(size(IPv4source,1),2);
IPv4destination(:,1:2)= zeros(size(IPv4source,1),2);

nameano='10outv4reverse_truncationano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);

%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
%% randomized
IPv4sout=zeros(size(IPv6d,1),4);
IPv4dout=zeros(size(IPv6d,1),4);

lines = size(IPv6s,1);

%% Anonymized IPv6 address output
nameano='10outv6reverse_truncationano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);

%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file
global anon_parsed_name;
nameano='10outreverse_truncationano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder,time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4,ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

anon_parsed_name='10outreverse_truncationano.txt';
set(handles.dataset,'Enable','on');

fid = textread('10outreverse_truncationano.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);
% --- Executes on button press in truncation.

% --- Executes on button press in truncation_mrt.
function truncation_mrt_Callback(hObject, eventdata, handles)
% hObject    handle to truncation_mrt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global parsed_name;
name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%

%%   IPv4 ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv4source= (zeros(size(IPv4source)));
% IPv4destination= (zeros(size(IPv4destination)));

%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
IPv4source(:,3:4)= zeros(size(IPv4source,1),2);
IPv4destination(:,3:4)= zeros(size(IPv4source,1),2);

%% randomized
% IPv4source= (round(rand(size(IPv4source))*65536));
% IPv4destination= (round(rand(size(IPv4destination))*65536));


nameano='10outv4truncationano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);


%% iPv4 anonymization ends
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%% IPv6 anonymization starts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields

%% IPv6  ANonnymization using Black Marker ALgorithm - doing all "Zero's" "Any number" or "Randomized"
%% Zeros
% IPv6d= (zeros(size(IPv6d)));
% IPv6s= (zeros(size(IPv6d)));
% IPv4sout=(zeros(size(IPv6d)));
% IPv4dout=(zeros(size(IPv6d)));


%% Any number (Can multiply with any number - change "*1" to any number like "*2", "*3")
% IPv6d= ((ones(size(IPv6d))*1));
% IPv6s= ((ones(size(IPv6d))*1));
% IPv4sout=((ones(size(IPv6d))*1));
% IPv4dout=((ones(size(IPv6d))*1));

%% randomized
IPv4sout=IPv6s(:,1:4);
IPv4dout=IPv6d(:,1:4);

IPv6d=(zeros(size(IPv6d)));
IPv6s=(zeros(size(IPv6d)));

lines = size(IPv6s,1);

%% Anonymized IPv6 address output
nameano='10outv6truncationano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,nameano);

%% Anonymizing both IPV$ and IPv6 from the same inputfile and then writing them back to the file

nameano='10outtruncationano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlength,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

global anon_parsed_name;
nameano='10outtruncationano.txt';
anon_parsed_name='10outtruncationano.txt';
set(handles.dataset,'Enable','on');

fid = textread('10outtruncationano.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);


% --- Executes on button press in time_rand_mrt.
function time_rand_mrt_Callback(hObject, eventdata, handles)
% hObject    handle to time_rand_mrt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global parsed_name;
name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%

%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%Random Shift
timeanony4=time4-(randi(100,1)*time4);

nameano='10outtimerandom_shiftv4ano.txt';
writeipv4anon(timeanony4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);


%% precision degradation
timeanony6=fix(time6*100)/100;

%% Anonymized IPv6 address output
nameano='10outtimev6ano.txt';

writeipv6anon(timeanony6,IPv6s,IPv6d,IPv4s,IPv4d,protocol6,pktlength,nameano);

%%%%% Write
%% Anonymized IPv6 address output
nameano='10outtimeano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, timeanony6,IPv6s,IPv6d,IPv4s,IPv4d,protocol6,pktlength,timeanony4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPV6 %%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Writing same as the inputfile formate
originalfile='10outtimeano.txt';
finalfile='final.txt';
createpcapipv6(IPv6s,IPv6d,IPv4s,IPv4d,originalfile, finalfile);% This function take a file and replace the IPs with the ones from the anonmization process

global anon_parsed_name;
nameano='10outtimeano.txt';

%Display on Output screen

anon_parsed_name='10outtimeano.txt';
set(handles.dataset,'Enable','on');

fid = textread('10outtimeano.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);


% --- Executes on button press in time_preci_mrt.
function time_preci_mrt_Callback(hObject, eventdata, handles)
% hObject    handle to time_preci_mrt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global parsed_name;
name4='ipv4.txt';
name6='ipv6.txt';
%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(parsed_name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line - AAM
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%
% Output of decoded IPv4 source column
v4source= 'v4SColumn.txt';
% Output of decoded IPv4 destination column
v4destination='v4DColumn.txt';

% This gives the size of the input file
inputsize= size(IPv4source,1);

% precision degradation
time4=fix(time4*10000)/100;

% Length anonymization

ipv4pktlength=ipv4pktlength+100;
% Time in defind zero because at this point we are not decoding the time data. This need to be fixed. 
% time=0;
% Writing the output of IPv4 decode in a files v4SColumn.txt and v4DColumn.txt.
% Source and destination is writen in two files because Crypto-PAN takes
% input as it this formate (time length, address)
ipv4writefile (v4source,v4destination, time4, ipv4pktlength,IPv4source,IPv4destination,inputsize);

v4Sanonymized='v4sourceanonymized.txt';  % IPv4 source address anonymized
v4Danonymized='v4destinationanonymized.txt';   % IPv4 sdestination address anonymized

[s,s]=dos(['cryto_run.exe ' v4source ' > ' v4Sanonymized]);
[s,s]=dos(['cryto_run.exe ' v4destination ' > ' v4Danonymized]);

[IPv4source,IPv4destination, time4, ipv4pktlength]=ipv4readfile(v4Sanonymized, v4Danonymized, inputsize );

nameano='10outv4ano.txt';
writeipv4anon(time4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);

lines = size(IPv6s,1);

namev4s='10outv4s.txt';
namev4d='10outv4d.txt';

%time=0;

%% precision degradation
time6=fix(time6*100)/10000;
pktlength=pktlength+100;

ipv6toipv4writefile(namev4s,namev4d, time6, pktlength, IPv4s, IPv4d,lines );

namev4sout='10outv4sout.txt';
namev4dout='10outv4dout.txt';

[s,s]=dos(['cryto_run.exe ' namev4s ' > ' namev4sout]);
[s,s]=dos(['cryto_run.exe ' namev4d ' > ' namev4dout]);

[IPv4sout,IPv4dout, timeout, pktlengthout]=ipv4toipv6readfile(namev4sout, namev4dout, lines );

%% Anonymized IPv6 address output
nameano='10outv6ano.txt';

writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,nameano);

global anon_parsed_name;

%% Anonymized IPv6 address output
nameano='timepreci_anonymized.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);


anon_parsed_name='timepreci_anonymized.txt';
%anon_parsed_name ='anonymized.txt';
set(handles.dataset,'Enable','on');

fid = textread('timepreci_anonymized.txt', '%s', 'delimiter', '\n', ...
                'whitespace', '');
set(handles.anoymized_text,'String', fid);

guidata(gcbo, handles);

% --- Executes during object creation, after setting all properties.

% wang
% --- Executes on button press in pushbutton46.
function pushbutton46_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton46 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.anoymized_text,'String', '');
cla reset;
% wang

% wang
% --------------------------------------------------------------------
function Exit_Callback(hObject, eventdata, handles)
% hObject    handle to Exit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(gcf);
% wang
