clc
close all;
clear all;

path=[cd '\gawk\'];
name=[path 'chicago-ipv6-2011-parsed.txt'];
name4='ipv4.txt';
name6='ipv6.txt';

%% Check if it is Ipv4 or IPv6
iporder=[];
f=fopen(name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

%while 1 % For each line
 for j=1:40
    
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);

%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);

%%%%%%%%%%%%%%%%%%%%%%%%%decode of the ipv4 end%%%%%%%%%%%%%
% Output of decoded IPv4 source column
v4source= 'v4SColumn.txt';
% Output of decoded IPv4 destination column
v4destination='v4DColumn.txt';

% This gives the size of the input file
inputsize= size(IPv4source,1);
% Time in defind zero because at this point we are not decoding the time data. This need to be fixed. 
% time=0;
% Writing the output of IPv4 decode in a files v4SColumn.txt and v4DColumn.txt.
% Source and destination is writen in two files because Crypto-PAN takes
% input as it this formate (time length, address)
ipv4writefile (v4source,v4destination, time4, ipv4pktlength,IPv4source,IPv4destination,inputsize);

v4Sanonymized='v4sourceanonymized.txt';  % IPv4 source address anonymized
v4Danonymized='v4destinationanonymized.txt';   % IPv4 sdestination address anonymized


[s,s]=dos(['cryto_run.exe ' v4source ' > ' v4Sanonymized]);
[s,s]=dos(['cryto_run.exe ' v4destination ' > ' v4Danonymized]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);

lines = size(IPv6s,1);

namev4s='10outv4s.txt';
namev4d='10outv4d.txt';

%time=0;

ipv6toipv4writefile(namev4s,namev4d, time6, pktlength, IPv4s, IPv4d,lines );

namev4sout='10outv4sout.txt';
namev4dout='10outv4dout.txt';

[s,s]=dos(['cryto_run.exe ' namev4s ' > ' namev4sout]);
[s,s]=dos(['cryto_run.exe ' namev4d ' > ' namev4dout]);

[IPv4sout,IPv4dout, timeout, pktlengthout]=ipv4toipv6readfile(namev4sout, namev4dout, lines );

%% Anonymized IPv6 address output
nameano='10outv6ano.txt';

 writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,nameano);

%% Anonymized IPv6 address output
nameano='10outano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol6,pktlengthout,time4, ipv4pktlength,IPv4source,IPv4destination,protocol4,nameano);



