function [time6,IPv6s,IPv6d,protocol,pktlength,macs, macd] = ipv6decode(name)
%% IN:
%    name: string with the path of teh file

%% OUT:
%   IPv6s/d (Nx8): contains the ipv6 address in decimal, each address of each line in one row (N in total),
%   and the fields of teh address in each column (8 fields)


IPv6s=[];
IPv6d=[];
protocol=[];
pktlength=[];
time6=[];
macs=[];
macd=[];
fid=fopen(name); %open the file
%nline = 0; % to now the line 

while 1 % For each line
    
    %% Getting the line
    line = fgetl(fid);
    if ~isempty(line)
       spaces = [];
       for i=1:size(line,2)
           if (line(i)==' ')
               spaces = [spaces i]; %storing the position of the spaces
           end
       end %we know wher the spaces are
       time6=[time6 str2num(line(1:spaces(1)-1))];
       line=line(spaces(1)+1:end);
       spaces=spaces-spaces(1);
       spaces=spaces(2:end);
       %% First the IPv6 address source
       ipv6text=line(1:spaces(1)-1);
       colon=[];
       for i=1:size(ipv6text,2)
           if (ipv6text(i)==':')
               colon=[colon i];% the position of the colons
           end
       end
       count=size(colon,2);
       if (count<7)
           IPv6sline = zeros(1,8); % IPv6 8 numbers of this line
           IPv6sline(1) = hex2dec(ipv6text(1:colon(1)-1));
           fieldcount = 1;
           for i=1:count-1
               colon(i+1)-colon(i);
               if ((colon(i+1)-colon(i))>1)
                   
                   fieldcount = fieldcount +1;
                    IPv6sline(fieldcount) = hex2dec(ipv6text(colon(i)+1:colon(i+1)-1));
                    
               else
                  % disp('i am here')
                   fieldcount = fieldcount + (8-count);
               end
           end

           IPv6sline(8) = hex2dec(ipv6text(colon(count)+1:end));
       else
           IPv6sline = zeros(1,8); % IPv6 8 numbers of this line
           IPv6sline(1) = hex2dec(ipv6text(1:colon(1)-1));
           for i=1:count-1
               IPv6sline(i+1) = hex2dec(ipv6text(colon(i)+1:colon(i+1)-1));
           end

           IPv6sline(8) = hex2dec(ipv6text(colon(count)+1:end));
           %for ii=
       end
       % Now we have the IPv6 address
       IPv6s = [IPv6s; IPv6sline];
       
       
       
       
       %% Second the IPv6 address destination
       ipv6text=line(spaces(1)+1:spaces(2)-1);
       colon=[];
       for i=1:size(ipv6text,2)
           if (ipv6text(i)==':')
               colon=[colon i];% the position of the colons
           end
       end
       count=size(colon,2);
       if (count<7)
           IPv6sline = zeros(1,8); % IPv6 8 numbers of this line
           IPv6sline(1) = hex2dec(ipv6text(1:colon(1)-1));
           fieldcount = 1;
           for i=1:count-1
               colon(i+1)-colon(i);
               if ((colon(i+1)-colon(i))>1)
                   
                   fieldcount = fieldcount +1;
                    IPv6sline(fieldcount) = hex2dec(ipv6text(colon(i)+1:colon(i+1)-1));
                    
               else
                  % disp('i am here')
                   fieldcount = fieldcount + (8-count);
               end
           end

           IPv6sline(8) = hex2dec(ipv6text(colon(count)+1:end));
       else
           IPv6sline = zeros(1,8); % IPv6 8 numbers of this line
           IPv6sline(1) = hex2dec(ipv6text(1:colon(1)-1));
           for i=1:count-1
               IPv6sline(i+1) = hex2dec(ipv6text(colon(i)+1:colon(i+1)-1));
           end

           IPv6sline(8) = hex2dec(ipv6text(colon(count)+1:end));
           %for ii=
       end
       % Now we have the IPv6 address
       IPv6d = [IPv6d; IPv6sline];
       
       
       
       %% Third the protocol
       protocol=char(protocol ,line(spaces(2)+1:spaces(3)-1));
       
       %% Four the lenght
       pktlength=[pktlength str2num(line(spaces(3)+1:spaces(4)-1))];
       
       
       line=line(spaces(4)+1:end);
       starmac=find(line=='_');
       dotmac=find(line==':');
       bracketstart=find(line=='(');
       bracketends=find(line==')');


       mac=zeros(1,9);
       mac(1)=hex2dec(line(starmac(1)+1:dotmac(1)-1));
       mac(2)=hex2dec(line(dotmac(1)+1:dotmac(2)-1));
       mac(3)=hex2dec(line(dotmac(2)+1:bracketstart(1)-2));
       mac(4)=hex2dec(line(bracketstart(1)+1:dotmac(3)-1));
       for i=4:7
           mac(i+1)=hex2dec(line(dotmac(i-1)+1:dotmac(i)-1));
       end
       mac(9)=hex2dec(line(dotmac(7)+1:bracketends(1)-1));
       macs=[macs; mac];
       
       
       %% mac destination
       mac=zeros(1,9);
       mac(1)=hex2dec(line(starmac(2)+1:dotmac(8)-1));
       mac(2)=hex2dec(line(dotmac(8)+1:dotmac(9)-1));
       mac(3)=hex2dec(line(dotmac(9)+1:bracketstart(2)-2));
       mac(4)=hex2dec(line(bracketstart(2)+1:dotmac(10)-1));
       for i=4:7
           mac(i+1)=hex2dec(line(dotmac(i+6)+1:dotmac(i+7)-1));
       end
       mac(9)=hex2dec(line(dotmac(14)+1:bracketends(2)-1));
       macd=[macd; mac];
       %% end for teh moment
%        pause
       if (feof(fid))
            break;
        end 
    end
end
fclose(fid);