clc
close all;
clear all;

%%%%%%%%%%IPv6/4 anonymization%%%%%%%
path=[cd '\gawk\'];
name=[path 'both.txt'];
name4='ipv4.txt';
name6='ipv6.txt';
%%%%%%%%%%%%%%%%%%%%%%%




%%% Check if it is Ipv4 or IPv6

iporder=[];

f=fopen(name);
f4=fopen(name4,'w');
f6=fopen(name6,'w');

while 1 % For each line
    line = fgetl(f);
    if (strfind(line, ':'))
        iporder=[iporder 1];
        fprintf(f6, '%s\n',line);
    else
        iporder=[iporder 0];
        fprintf(f4, '%s\n',line);
    end
    if (feof(f))
         break;
    end 
end
fclose(f);
fclose(f4);
fclose(f6);


%% This function makes the decode of the ipv4daddresses, protocolo and pktlength (out) %% the in parameter is the name of the file
[time4,IPv4source,IPv4destination,protocol4,ipv4pktlength] = ipv4decode(name4);


%%Random Shift
timeanony4=time4-(randi(100,1)*time4);


nameano='10outtimerandom_shiftv4ano.txt';
writeipv4anon(timeanony4,IPv4source,IPv4destination,protocol4,ipv4pktlength,nameano);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPv6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function makes the decode of the ipv6 directions, protocolo and pktlength (out)
%% the in parameter is the name of the file

[time6,IPv6s,IPv6d,protocol6,pktlength] = ipv6decode(name6);

%decode of the ipv6 end%% IPv6 Coversion to IPv4, we only need the 4 first fields
IPv4s=IPv6s(:,1:4);
IPv4d=IPv6d(:,1:4);


%% precision degradation
timeanony6=fix(time6*100)/100;

%% Anonymized IPv6 address output
nameano='10outtimev6ano.txt';

 writeipv6anon(timeanony6,IPv6s,IPv6d,IPv4s,IPv4d,protocol6,pktlength,nameano);




%% Anonymized IPv6 address output
nameano='10outtimeano.txt';

% writeipv6anon(time6,IPv6s,IPv6d,IPv4sout,IPv4dout,protocol,pktlengthout,nameano);
writeipanon(iporder, timeanony6,IPv6s,IPv6d,IPv4s,IPv4d,protocol6,pktlength,timeanony4, ipv4pktlength,IPv4source,IPv4destination,protocol4,1,nameano);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% IPV6 %%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Writing same as the inputfile formate
originalfile='gawk/10files.txt';
finalfile='final.txt';
createpcapipv6(IPv6s,IPv6d,IPv4s,IPv4d,originalfile, finalfile);% This function take a file and replace the IPs with the ones from the anonmization process

