%%% rbf and multilayer BLSs using BGP dataset
%%% Zhida Li, 2018-12-07
%%%%%%%%%%load the dataset%%%%%%%%%%%%%%%%%%%%
% {1}-> Code Red I 
% {2}-> Nimda 
% {3}->Slammer
tic
clear; 
clc
% warning off all;

seed = 1;
rng(seed)

num_class = 2;

load train_80_5intervaldata.mat 
load test_20_5interval_data.mat

dataset = 3 % select dataset
Train = train_80_data{dataset};
Test = test_20_data{dataset};

train_x = Train(:, 1:end-1);
train_x = zscore(train_x);
train_y = Train(:, end);
% change label 0 to 2 
    [index_0, ~] = find(train_y == 0);
    train_y(index_0)=2;
    
test_x = Test(:, 1:end-1);
test_x = zscore(test_x);

test_y = Test(:, end);
    [index_00, ~] = find(test_y == 0);
    test_y(index_00)=2;
% one hot encoding for labels
train_y = one_hot_m(train_y, num_class);
test_y = one_hot_m(test_y, num_class);

%%
fprintf('BLS...\n\n');
%%%%%%%%%%%%%%%%%%%% Original BLS %%%%%%%%%%%%%%%%%%%%
C = 2^-25; s = .8;%the l2 regularization parameter and the shrinkage scale of the enhancement nodes 25
N11=100;%feature nodes  per window  100
N2=2;% number of windows of feature nodes 10
N33=2;% number of enhancement nodes  200 good
epochs=1;% number of epochs 
train_err=zeros(1,epochs);test_err=zeros(1,epochs);
train_time=zeros(1,epochs);test_time=zeros(1,epochs);
%  rand('state',67797325)   % 12000 %%%%% The random seed recommended by the
% reference HELM [10].
N1=N11; N3=N33;  
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,f_score]...
        = bls_train_cebls_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3);       % change name of the function here bls_train_cebls_fscore, bls_train_cfbls_fscore, bls_train_cfebls_fscore, bls_train_fscore
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
bls_test_acc = TestingAccuracy;
bls_test_f_score = f_score;

% ripe  no Fscore here
rng(seed)
load instance_matrix_test_ripe.mat
test_x = zscore(instance_matrix_test_ripe);
test_y = 2*ones(1440,1);
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,~]...
        = bls_train_cebls_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3);       % change name of the function here bls_train_cebls_fscore, bls_train_cfbls_fscore, bls_train_cfebls_fscore, bls_train_fscore
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
fprintf('ripe accuracy above...\n\n\n');
bls_ripe_acc = TestingAccuracy;

% bcnet no Fscore here
rng(seed)
load instance_matrix_test_bcnet.mat
test_x = zscore(instance_matrix_test_bcnet);
test_y = 2*ones(1440,1);
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,~]...
        = bls_train_cebls_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3);       % change name of the function here bls_train_cebls_fscore, bls_train_cfbls_fscore, bls_train_cfebls_fscore, bls_train_fscore
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
fprintf('bcnet accuracy above...\n\n\n');
bls_bcnet_acc = TestingAccuracy;
result1 = [bls_test_acc bls_ripe_acc bls_bcnet_acc bls_test_f_score]


clc
% warning off all;

seed = 1;
rng(seed)

num_class = 2;
% load train_80_data.mat
% load test_20_data.mat

load train_80_5intervaldata.mat 
load test_20_5interval_data.mat

% dataset = 3
Train = train_80_data{dataset};
Test = test_20_data{dataset};

train_x = Train(:, 1:end-1);
train_x = zscore(train_x);
train_y = Train(:, end);
% change label 0 to 2 
    [index_0, ~] = find(train_y == 0);
    train_y(index_0)=2;
    
test_x = Test(:, 1:end-1);
test_x = zscore(test_x);

test_y = Test(:, end);
    [index_00, ~] = find(test_y == 0);
    test_y(index_00)=2;
% one hot encoding for labels
train_y = one_hot_m(train_y, num_class);
test_y = one_hot_m(test_y, num_class);
%%
fprintf('RBF-BLS...\n\n');
%%%%%%%%%%%%%%%%%%%% RBF-BLS %%%%%%%%%%%%%%%%%%%%
cc = 0.1; % rbf parameter
h = 15;    % rbf parameter

C = 2e-25; s = .8;%the l2 regularization parameter and the shrinkage scale of the enhancement nodes 25
N11=100;%feature nodes  per window  100
N2=10;% number of windows of feature nodes 10
N33=200;% number of enhancement nodes  200 good
epochs=1;% number of epochs 
train_err=zeros(1,epochs);test_err=zeros(1,epochs);
train_time=zeros(1,epochs);test_time=zeros(1,epochs);
%  rand('state',67797325)   % 12000 %%%%% The random seed recommended by the
% reference HELM [10].
N1=N11; N3=N33;  
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,f_score] ...
          = bls_train_rbf_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3,cc,h);       
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
fprintf('test accuracy and F-Score above...\n\n\n');
rbfbls_test_acc = TestingAccuracy;
rbfbls_test_f_score = f_score;

% ripe  no Fscore here
rng(seed)
load instance_matrix_test_ripe.mat
test_x = zscore(instance_matrix_test_ripe);
test_y = 2*ones(1440,1);
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,~] ...
          = bls_train_rbf_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3,cc,h);       
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
fprintf('ripe accuracy above...\n\n\n');
rbfbls_ripe_acc = TestingAccuracy;

% bcnet no Fscore here
rng(seed)
load instance_matrix_test_bcnet.mat
test_x = zscore(instance_matrix_test_bcnet);
test_y = 2*ones(1440,1);
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,~] ...
          = bls_train_rbf_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3,cc,h);       
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
fprintf('bcnet accuracy above...\n\n\n');
rbfbls_bcnet_acc = TestingAccuracy;

result1 = [bls_test_acc bls_ripe_acc bls_bcnet_acc bls_test_f_score]

result2 = [rbfbls_test_acc rbfbls_ripe_acc rbfbls_bcnet_acc rbfbls_test_f_score]

a = [result1;result2]
          
% 
toc
