%%% rbf and multilayer BLSs using NSL-KDD dataset
%%% Zhida Li, 2018-12-07
%%%%%%%%%%load the dataset%%%%%%%%%%%%%%%%%%%%
clc
clear; 
warning off all;
format compact;

seed = 1
% rng(1)
rng('default')

num_class = 2
Train = csvread('data_train.csv');
% Test = csvread('data_test21.csv');
Test = csvread('data_test21.csv');

train_x = Train(:, 1:end-1);
% train_x = Train(:, 1:100);

train_y = Train(:, end);

test_x = Test(:, 1:end-1);
% test_x = Test(:, 1:100);
test_y = Test(:, end);
% one hot
train_y = one_hot_m(train_y, num_class);
test_y = one_hot_m(test_y, num_class);

%% rbf
cc = 0.1; % rbf parameter
h = 15;    % rbf parameter

C = 2e-25; s = .8;%the l2 regularization parameter and the shrinkage scale of the enhancement nodes 25
N11=100;%feature nodes  per window  100
N2=25;% number of windows of feature nodes 10
N33=200;% number of enhancement nodes  200 good
epochs=1;% number of epochs 
train_err=zeros(1,epochs);test_err=zeros(1,epochs);
train_time=zeros(1,epochs);test_time=zeros(1,epochs);
%  rand('state',67797325)   % 12000 %%%%% The random seed recommended by the
% reference HELM [10].
N1=N11; N3=N33;  
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,f_score] ...
          = bls_train_rbf_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3,cc,h);        
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
fprintf('test accuracy and F-Score above...\n\n\n');
rbfbls_test_acc = TestingAccuracy;
rbfbls_test_f_score = f_score;

%% cfebls
C = 2^-30; s = .8;%the l2 regularization parameter and the shrinkage scale of the enhancement nodes 25
N11=100;%feature nodes  per window  100
N2=25;% number of windows of feature nodes 10
N33=200;% number of enhancement nodes  200 good
epochs=1;% number of epochs 
train_err=zeros(1,epochs);test_err=zeros(1,epochs);
train_time=zeros(1,epochs);test_time=zeros(1,epochs);
% %  rand('state',67797325)   % 12000 %%%%% The random seed recommended by the
% % reference HELM [10].
N1=N11; N3=N33;  
for j=1:epochs    
    [TrainingAccuracy,TestingAccuracy,Training_time,Testing_time,f_score]...
        = bls_train_cfebls_fscore(train_x,train_y,test_x,test_y,s,C,N1,N2,N3);   % change name of the function here bls_train_cebls_fscore, bls_train_cfbls_fscore, bls_train_cfebls_fscore
    train_err(j)=TrainingAccuracy * 100;
    test_err(j)=TestingAccuracy * 100;
    train_time(j)=Training_time;
    test_time(j)=Testing_time;
end
bls_test_acc = TestingAccuracy;
bls_test_f_score = f_score;

%%%%%%%%%%%%%%%%%%This is the model of broad learning system for%%%%%%
%%%%%%%%%%%%%%%%%%the increment of m input patterns and m2 enhancement nodes %%%%%%%%%%%%%%%%%%%%%%%%
train_xf=train_x;train_yf=train_y;
train_x=train_xf(1:100000,:);train_y=train_yf(1:100000,:); % the selected input patterns of int incremental learning
C = 2^-30;%the regularization parameter for sparse regualarization 2^-30
s = .8;%the shrinkage parameter for enhancement nodes
N11=100;%feature nodes  per window
N2=25;% number of windows of feature nodes
N33=200;% number of enhancement nodes
epochs=1;% number of epochs 
m=3000;%number of added input patterns per incremental step     ###2e4
m2=60; %number of added enhancement nodes per incremental step  ###25
l=3;% steps of incremental learning % for original bls test l2. test21:
train_err_t=zeros(epochs,l);test_err_t=zeros(epochs,l);train_time_t=zeros(epochs,l);test_time_t=zeros(epochs,l);
Testing_time_t=zeros(epochs,1);Training_time_t=zeros(epochs,1);
N1=N11; N3=N33;  
for i=1:epochs        
   [train_err,test_err,train_time,test_time,Testing_time,Training_time, accuracy_cal, f_score] = bls_train_inputenhance_fscore(train_x,train_y,train_xf,train_yf,test_x,test_y,s,C,N1,N2,N3,m,m2,l); 
   train_err_t(i,:)=train_err;test_err_t(i,:)=test_err;train_time_t(i,:)=train_time;test_time_t(i,:)=test_time;
   Testing_time_t(i)=Testing_time;Training_time_t(i)=Training_time;
end
fprintf('Accuracy--calculated-test %.2f%%, F-score-test %.2f%%---END', accuracy_cal*100, f_score*100);