/**
 * delay.h
 */

#ifndef ns_delay_h
#define ns_delay_h

#include <assert.h>

#include "packet.h"
#include "queue.h"
#include "ip.h"
#include "connector.h"

class LinkDelay : public Connector {
 public:

	enum LinkDelay_DelayMode
	{
		LD_DelayMode_Constant = 0,
		LD_DelayMode_Random
	};

    LinkDelay();
	void recv(Packet* p, Handler*);
	void send(Packet* p, Handler*);
	void handle(Event* e);
	double delay()
    {
        //wan
        assert(false); //it seems this is neve called.
        
        return delay_;
    }
//wan
    double getDelay(Packet* p); //my added func.  it will return the link delay with variation if appliable.
        
	inline double txtime(Packet* p) {
		return (8. * hdr_cmn::access(p)->size() / bandwidth_);
	}
	double bandwidth() const { return bandwidth_; }
	void pktintran(int src, int group);
 protected:
	int command(int argc, const char*const* argv);
	void reset();
	double bandwidth_;	/* bandwidth of underlying link (bits/sec) */
	double delay_;		/* line latency */
	Event intr_;
	int dynamic_;		/* indicates whether or not link is ~ */

	PacketQueue* itq_;
	int total_[4];

//wan
private:
	int delayMode_;        
};

#endif
