/**
 * ll-wz.cc
 */

#include "ll-wz.h"
#include "random.h"

#include <address.h>
#include <mac.h>

#include <tcp.h>

static class LLWzClass : public TclClass {
public:
    LLWzClass() : TclClass("LL/LLWz") {}
    TclObject* create(int, const char*const*)
    {
        return (new LLWz());
    }
} llwz_class;

LLWz::LLWz() : LL(), m_dLastRTT(0.0), enableAckControl_(0)
{
	bind("enableAckControl_", &enableAckControl_);
    
	bind("srtt_", &m_dSrtt);
	bind("rttvar_", &m_dRttvar);
	bind("g_", &m_dG);
    
	//print parameter values
	printf("%x LLWz created --------------------------\n", this);

    m_pktSampleWirelessAck = NULL;
    m_piNextWiredDataToSend = NULL;
    m_iLastWirelessAck = -1;
    m_iLastAckSent = -1;
	m_acTimer = new LLWzACTimerHandler(this);
    m_iLastWirelessRcvTime = 0.0;
    m_iWirelessAckRcvAvg = 0.0;
    m_fWiredDataRate = 0.0;
    m_actmPending_ = NULL;

    //delete!  not used.
    m_dLastAckSentTime = 0.0;
}

LLWz::~LLWz()
{
    Packet::free(m_pktSampleWirelessAck);
    delete m_acTimer;
}

void LLWz::recv(Packet *p, Handler *h)
{
    printf("%f [%s@%x]: LLWz::recv(): type(%i), seqno(%9i)\n", Scheduler::instance().clock(), name(),
        this, hdr_cmn::access(p)->ptype(), hdr_tcp::access(p)->seqno());

    if(enableAckControl_ == 0)
    {
        LL::recv(p, h);
        return;                
    }
    
	Tcl &tcl = Tcl::instance();

    packet_t ptType = hdr_cmn::access(p)->ptype();
	hdr_cmn *ch = HDR_CMN(p);
    hdr_ip *iph = hdr_ip::access(p);
    hdr_tcp * tcph = hdr_tcp::access(p);
	if(ch->direction() == hdr_cmn::UP)
	{   //packet received from wireless link.
        if (ptType == PT_ACK)
        {
            //del printf("%f[%s]<-: LLWz::recv() : ack  (%i)\n", Scheduler::instance().clock(), name(), tcph->seqno());
            if(m_pktSampleWirelessAck == NULL || hdr_tcp::access(m_pktSampleWirelessAck)->seqno() == 0) //keep copy until we get the first ack for data packet (i.e. to skip conneciton pkt)
            {   //make a copy of the sample ack.
                m_pktSampleWirelessAck = p->copy();
            }
            receiveWirelessAck(p);
            return;
        }
        else if (ptType == PT_TCP)
        {   //wan TODO:
            printf("%f[%s]<-: LLWz::recv() : seqno(%i)\n", Scheduler::instance().clock(), name(), tcph->seqno());
            abort();
        }
	}
    else
    {   //packet received from wired link.        
        if (ptType == PT_ACK)
        {   //wan TODO:
            printf("%f[%s]->: LLWz::recv() : ack  (%i)\n", Scheduler::instance().clock(), name(), tcph->seqno());
            abort();
        }
        else if (ptType == PT_TCP)
        {
            //del printf("%f[%s]->: LLWz::recv() : seqno(%i)", Scheduler::instance().clock(), name(), tcph->seqno());
            recordPacket(tcph->seqno());
            //del printf("%s dataqueue(%i), ACEnabled(%i)\n", name(), m_lstWiredDataPkt.size(), enableAckControl_);
        }
    }
    
    LL::recv(p, h);
}

void LLWz::recordPacket(int iSeqno)
{
    list <PacketInfo>::iterator iter = m_lstWiredDataPkt.begin();
    while (iter != m_lstWiredDataPkt.end())
    {
        if(iter->m_iSeqno == iSeqno)
        {
            iter->m_iNumOfRtm++;
            return;
        }
        else if(iter->m_iSeqno < iSeqno)
        {
            break;
        }
      
        iter++;
    }
	//acked dup data ack, don't store it anymore.  
	//wan TODO:  this could cause problem though, when ack send from this router last on its way back to sender, then, we will have to wait for
	//	receiver to resend this ack again to trigger this ack to be reset from router.	
	if(iSeqno <= m_iLastAckSent)
		return; 

    double dNow = Scheduler::instance().clock();
    m_lstWiredDataPkt.insert(iter, PacketInfo(iSeqno, dNow));

    //print current data pkt queue.
    printf("%s euque: ", name());
    iter = m_lstWiredDataPkt.begin();
    while (iter != m_lstWiredDataPkt.end())
    {
        printf("%i ", iter->m_iSeqno);
        if (iter->m_iNumOfRtm > 0)
            printf("(dup)");
            
        iter++;
    }
    printf(" Total(%i)\n", m_lstWiredDataPkt.size());

//del    updateWiredDataRate(iSeqno, dNow);

}

/**
*wan: this proc is not used.
* updates the data rate received from wired sender.
* @param iSeqno: the largest seqno received so far.
* @param dNow: the time when the iseno received.
*/
void LLWz::updateWiredDataRate(int iSeqno, double dRecvTime)
{
    //Note: this function will not work when data is recv out of order.  but in my simulation so far, all data are recv in order.
    abort();
    
    //we assumes that we started to receive data at the beginning of sim.  This needs to be changed.
    m_fWiredDataRate = iSeqno / dRecvTime;
    printf("%s WiredDataRate %f %f %i\n", name(), dRecvTime, m_fWiredDataRate, iSeqno);
}

/**
* @return: 0 - duplicate/old ACK, if it's the case, packet p IS freed in this function.
*/
int LLWz::receiveWirelessAck(Packet* p)
{
    hdr_tcp * tcph = hdr_tcp::access(p);
    int iSeqno = tcph->seqno();
    if(iSeqno < m_iLastWirelessAck)
    {
        Packet::free(p);
        return 0;
    }

    bool bDupAck = false;
    if(iSeqno == m_iLastWirelessAck)
    {
        //duplicate acks.  this should still be sent to forwarded, otherwise, TCP is changed!!
        bDupAck = true;
    }
    m_iLastWirelessAck = iSeqno;
    PacketInfo* pktInfo = getAckedPktSendTime(m_iLastWirelessAck);
    Scheduler &s = Scheduler::instance();
    if(pktInfo == NULL && bDupAck == true) //this ack is already sent.  re-send this ack.
    {
        printf("%s sending dup-ack %i\n", name(), m_iLastWirelessAck);
        Packet::free(p);
        //wan TODO: Note this is not right.  probably should be set to the sending time of data packet which triggers this dup-ack.
        double dNow = Scheduler::instance().clock();
        m_lstWiredDataPkt.push_back(PacketInfo(iSeqno, dNow));
        if (m_actmPending_) {
            s.cancel(m_actmPending_);
            m_actmPending_ = NULL;
        }
        pktInfo = getAckedPktSendTime(m_iLastWirelessAck);
        if (updateNextWiredDataToSend(pktInfo) == true)
        {
            m_actmPending_ = (Event *) m_pktSampleWirelessAck;
            s.schedule(m_acTimer, m_actmPending_, 0);
        }
        return 0;
    }
    
    {
        //good ACK.
//wan TODO: this needs to mofidy too according to last TODO 5 lines up.
        if(pktInfo->m_iSeqno != m_iLastWirelessAck)
        {
            fprintf(stderr, "iack = %i, pktinfo.iseqno = %i\n", m_iLastWirelessAck, pktInfo->m_iSeqno);
            abort();
        }
        if(bDupAck == true)
        {
            pktInfo->m_iNumOfDupAcks++;
            if(pktInfo->m_iNumOfDupAcks >= 3)
            {
                //send 3 acks to trigger sender into
                //wan TODO:  it seemes it only send one dup-ack, which cannot trigger sender to re-transmitt right away!!
                printf("%s sending dup-ack %i\n", name(), m_iLastWirelessAck);
                Packet::free(p);
                if (m_actmPending_) {
                    s.cancel(m_actmPending_);
                    m_actmPending_ = NULL;
                }
                if (updateNextWiredDataToSend(pktInfo) == true)
                {
                    m_actmPending_ = (Event *) m_pktSampleWirelessAck;
                    s.schedule(m_acTimer, m_actmPending_, 0);
                }

                return 0;
            }
        }
            
        pktInfo->m_dAckTime = Scheduler::instance().clock();

//wan testing
        double dOldLastWirelessRcvTime = m_iLastWirelessRcvTime;
        if(m_iLastWirelessRcvTime == 0.0)
        {
            m_iLastWirelessRcvTime = Scheduler::instance().clock();            
            m_iWirelessAckRcvAvg = 0.0;
        }
        else
        {
            double dOldLastWirelessRcvTime = m_iLastWirelessRcvTime;
            m_iLastWirelessRcvTime = Scheduler::instance().clock();
            m_iWirelessAckRcvAvg = (1 - m_dG) * m_iWirelessAckRcvAvg + m_dG * (m_iLastWirelessRcvTime - dOldLastWirelessRcvTime);
        }
//del        printf("m_iLastWirelessRcvTime(%f), recv interval(%f)\n", m_iWirelessAckRcvAvg,
//            (m_iLastWirelessRcvTime - dOldLastWirelessRcvTime));
            
        calcRtt(pktInfo->m_dSendTime);
        
        //based on the new calculated srtt to re-schedule next ack to be transmitted.
        Scheduler &s = Scheduler::instance();
        Packet::free(p);
        if (m_actmPending_) {
            s.cancel(m_actmPending_);
            m_actmPending_ = NULL;
        }
        if (updateNextWiredDataToSend() == true)
        {
                m_actmPending_ = (Event *) m_pktSampleWirelessAck;
                s.schedule(m_acTimer, m_actmPending_, nextAckTime());
        }
    }

    return 1;
}
/**
* @return: the packinfo of the packet with largest seqno, which has been acked by iAck. Returns NULL if there's no packet
*   in the data queue, or iAck didn't ack any packet.
*/
PacketInfo* LLWz::getAckedPktSendTime(int iAck)
{
    list <PacketInfo>::iterator iter = m_lstWiredDataPkt.begin();
    if(iter == m_lstWiredDataPkt.end())
    {
        return NULL; //there is no data pkt in the queue, OR all data seqno > iAck.
    }

    while (iter != m_lstWiredDataPkt.end())
    {
	if (iter->m_iSeqno <= iAck)
            return &(*iter);
            
        iter++;
    }

    return NULL;
}
/**
* @return: the latest send time of the packet this ACK frees, i.e. the packet with largest seqno. which are freed.
*Note:  the return value is not correctly implimented!!!
*/
double LLWz::clearDataBuf(int iAck)
{
	double dSndTime = -1;

	if (m_lstWiredDataPkt.empty())
		return dSndTime;

    int seq = -1;
    while ( ! m_lstWiredDataPkt.empty())
    {
		if (m_lstWiredDataPkt.back().m_iSeqno <= iAck) //this is NOT "<" instead since ack is NOT next expected seqno in ns!
        {
			dSndTime = m_lstWiredDataPkt.front().m_dSendTime;
            m_lstWiredDataPkt.pop_back();
		}
        else //if (seq > ack)
			break;
	}

	return dSndTime;
}

bool LLWz::updateNextWiredDataToSend(PacketInfo* pNextAck)
{
    if(pNextAck != NULL)
    {
        m_piNextWiredDataToSend = pNextAck;
        return true;        
    }
    
    if(m_lstWiredDataPkt.empty() == false 
        && m_lstWiredDataPkt.back().m_iSeqno == (m_iLastAckSent + 1) //make sure ack we send is in order. 
        && m_lstWiredDataPkt.back().m_iSeqno <= m_iLastWirelessAck) //make sure what to send is also acked by receiver!
    {
        list <PacketInfo>::iterator iter = m_lstWiredDataPkt.end();
        iter--;
        m_piNextWiredDataToSend = &(*iter);
    }
    else
        m_piNextWiredDataToSend = NULL;

/*    if(m_piNextWiredDataToSend == NULL)
        printf("m_piNextWiredDataToSend is NULL\n");
    else
        printf("nextseqnotosend(%i), end--(%i), numofDataInQueue(%i)\n", m_piNextWiredDataToSend->m_iSeqno,
            (m_lstWiredDataPkt.end()--)->m_iSeqno, m_lstWiredDataPkt.size());
*/
    return (m_piNextWiredDataToSend==NULL)?false:true;
}

//wan TODO: this works only when every ack is acked, and in order!!!!  fix it if not.
void LLWz::calcRtt(double dSendTime)
{
    //del printf("%f: Srtt(%f), rttdev(%f), g(%f)", Scheduler::instance().clock(), m_dSrtt, m_dRttvar, m_dG);
	double rtt = Scheduler::instance().clock() - dSendTime;
    if (rtt > 0) {
        if(m_dSrtt != 0.0)
            m_dSrtt = (1 - m_dG) * m_dSrtt + m_dG * rtt;
        else
            m_dSrtt = rtt;        
        double delta = rtt - m_dSrtt;
		if (delta < 0)
			delta = -delta;
		if (m_dRttvar != 0)
			m_dRttvar = (1 - m_dG) * m_dRttvar + m_dG * delta;
		else
			m_dRttvar = delta;
        printf("Srtt(%f), rtt(%f), rttdev(%f), delta(%f), g_(%f)\n", m_dSrtt, rtt, m_dRttvar, delta, m_dG);
	}
}

void LLWz::sendNextAck()
{
printf("wan 8-2 lastsentack(%i), lastrecvack(%i), queued(%i), nowtosend(%i)\n", m_iLastAckSent, m_iLastWirelessAck,
    m_iLastWirelessAck - m_iLastAckSent, m_piNextWiredDataToSend->m_iSeqno);

    if(m_piNextWiredDataToSend == NULL)
        return;
        
	Scheduler &s = Scheduler::instance();

    if(m_iLastAckSent < m_piNextWiredDataToSend->m_iSeqno)       
        m_iLastAckSent = m_piNextWiredDataToSend->m_iSeqno;

    //construct and transmit ACK packet.
    Packet* p = m_pktSampleWirelessAck->copy();
    hdr_tcp::access(p)->seqno() = m_iLastAckSent;
    LL::recv(p, NULL); //del  h);
    double dNow = s.clock();
 //del printf("sendingat %f %f\n", dNow, dNow - m_dLastAckSentTime);
    m_dLastAckSentTime = s.clock();
    clearDataBuf(m_iLastAckSent);
    updateNextWiredDataToSend();
 
    //Reset timeout for later time if there's more ACK in the queue.
    if(m_piNextWiredDataToSend != NULL)
    {
        if (m_actmPending_)
            s.cancel(m_actmPending_);
        m_actmPending_ = (Event *) m_pktSampleWirelessAck;
        s.schedule(m_acTimer, m_actmPending_, nextAckTime());
    }
}

double LLWz::nextAckTime()
{
//wan testing
//del return m_iWirelessAckRcvAvg;

	//send connection bits right away.
    if (m_iLastAckSent < 1) 
        return 0.0;

//del return m_iWirelessAckRcvAvg/2.0;
        
/*if(m_iLastAckSent <= 10 //pass connection bits. in fact, 1 would be ok here.
    || (m_iLastWirelessAck-m_iLastAckSent) > 1
    || m_dRttvar <= 0.00001)
    return 0.0;
else
    return 10;
  */      
/*    if(m_dRttvar < 0.0001)
        return 0.0;
    else
        return m_iWirelessAckRcvAvg;
  */      
    double dNow = Scheduler::instance().clock();
    double dRet = 0.0; //passed supposed schedule time, transmit right away.
/*    if(dNow < m_dLastAckSentTime + m_dSrtt)
        dRet = m_dLastAckSentTime + m_dSrtt - dNow;
*/
    if(dNow < m_piNextWiredDataToSend->m_dSendTime + m_dSrtt)
        dRet = m_piNextWiredDataToSend->m_dSendTime + m_dSrtt - dNow;

//del    printf("scheduledat %f %f lastsent(%f), srtt(%f)\n", dNow, dRet, m_dLastAckSentTime, m_dSrtt);
    return dRet;
}

/***************  class LLWzACTimerHandler ***************
*/
void
LLWzACTimerHandler::handle(Event *)
{
    m_llwz->m_actmPending_ = NULL; //indicates there is no timer.
    m_llwz->sendNextAck();
        
/*del    Packet *p = snoop_->pkts_[snoop_->buftail_];
	snoop_->toutPending_ = 0;
	if (p == 0)
		return;
	hdr_snoop *sh = hdr_snoop::access(p);
	if (sh->seqno() != snoop_->lastAck_ + 1)
		return;
	if ((snoop_->bufhead_ != snoop_->buftail_) ||
	    (snoop_->fstate_ & SNOOP_FULL))
     {
		//		printf("%f Snoop timeout\n", Scheduler::instance().clock());
		if (snoop_->snoop_rxmit(p) == SNOOP_SUPPRESS)
			snoop_->expNextAck_ = snoop_->next(snoop_->buftail_);
	}*/
}
