/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.ClassReaderFactory;
import net.sf.retrotranslator.transformer.GenericClassVisitor;
import net.sf.retrotranslator.transformer.MemberFinder;
import net.sf.retrotranslator.transformer.MessageLogger;

public class ReferenceVerifyingVisitor
extends GenericClassVisitor {
    private final ClassReaderFactory factory;
    private final MessageLogger logger;
    private String currentClassName;
    private Set warnings = new LinkedHashSet();
    private int warningCount;

    public ReferenceVerifyingVisitor(ClassReaderFactory classReaderFactory, MessageLogger messageLogger) {
        super((ClassVisitor)new EmptyVisitor());
        this.factory = classReaderFactory;
        this.logger = messageLogger;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.currentClassName = ReferenceVerifyingVisitor.getClassInfo(string);
        this.warnings.clear();
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    public void visitEnd() {
        super.visitEnd();
    }

    protected String visitInternalName(String string) {
        try {
            this.factory.getClassReader(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.println("Class not found: " + ReferenceVerifyingVisitor.getClassInfo(classNotFoundException.getMessage()));
        }
        return string;
    }

    protected void visitFieldRef(int n, String string, String string2, String string3) {
        boolean bl = n == 178 || n == 179;
        try {
            int n2 = new MemberFinder(this.factory, false, bl, string2, string3).findIn(string, null);
            if (n2 == 0) {
                this.println(ReferenceVerifyingVisitor.getFieldInfo(string, bl, string2, string3, "not found"));
            } else if (n2 > 1) {
                this.println(ReferenceVerifyingVisitor.getFieldInfo(string, bl, string2, string3, "duplicated"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.cannotVerify(ReferenceVerifyingVisitor.getFieldInfo(string, bl, string2, string3, "not verified"), classNotFoundException);
        }
    }

    protected void visitMethodRef(int n, String string, String string2, String string3) {
        if (string.startsWith("[")) {
            return;
        }
        boolean bl = n == 184;
        try {
            int n2 = new MemberFinder(this.factory, true, bl, string2, string3).findIn(string, null);
            if (n2 == 0) {
                this.println(ReferenceVerifyingVisitor.getMethodInfo(string, bl, string2, string3, "not found"));
            } else if (n2 > 1) {
                this.println(ReferenceVerifyingVisitor.getMethodInfo(string, bl, string2, string3, "duplicated"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.cannotVerify(ReferenceVerifyingVisitor.getMethodInfo(string, bl, string2, string3, "not verified"), classNotFoundException);
        }
    }

    private void cannotVerify(String string, ClassNotFoundException classNotFoundException) {
        this.println(string + "\n (Class not found: " + ReferenceVerifyingVisitor.getClassInfo(classNotFoundException.getMessage()) + ")");
    }

    private void println(String string) {
        String string2 = this.currentClassName + ":\n " + string;
        if (!this.warnings.contains(string2)) {
            ++this.warningCount;
            this.logger.warning(string2);
            this.warnings.add(string2);
        }
    }

    private static String getClassInfo(String string) {
        return string.replace('/', '.');
    }

    private static String getFieldInfo(String string, boolean bl, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer("Field ").append(string4).append(": ");
        if (bl) {
            stringBuffer.append("static ");
        }
        stringBuffer.append(Type.getType((String)string3).getClassName()).append(' ');
        stringBuffer.append(ReferenceVerifyingVisitor.getClassInfo(string)).append('.').append(string2);
        return stringBuffer.toString();
    }

    private static String getMethodInfo(String string, boolean bl, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.equals("<init>")) {
            stringBuffer.append("Constructor ").append(string4).append(": ");
            stringBuffer.append(ReferenceVerifyingVisitor.getClassInfo(string));
        } else {
            stringBuffer.append("Method ").append(string4).append(": ");
            if (bl) {
                stringBuffer.append("static ");
            }
            stringBuffer.append(Type.getReturnType((String)string3).getClassName());
            stringBuffer.append(' ').append(ReferenceVerifyingVisitor.getClassInfo(string)).append('.').append(string2);
        }
        stringBuffer.append('(');
        boolean bl2 = true;
        Type[] typeArray = Type.getArgumentTypes((String)string3);
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type type = typeArray[i];
            stringBuffer.append(bl2 ? "" : ",").append(type.getClassName());
            bl2 = false;
        }
        return stringBuffer.append(')').toString();
    }
}

