/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.sf.retrotranslator.runtime.java.lang._Class;

public class _Collections {
    public static boolean addAll(Collection collection, Object ... objectArray) {
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            bl |= collection.add(object);
        }
        return bl;
    }

    public static Collection checkedCollection(Collection collection, Class clazz) {
        return new CheckedCollection(collection, clazz);
    }

    public static List checkedList(List list, Class clazz) {
        return new CheckedList(list, clazz);
    }

    public static Map checkedMap(Map map, Class clazz, Class clazz2) {
        return new CheckedMap(map, clazz, clazz2);
    }

    public static Set checkedSet(Set set, Class clazz) {
        return new CheckedSet(set, clazz);
    }

    public static SortedMap checkedSortedMap(SortedMap sortedMap, Class clazz, Class clazz2) {
        return new CheckedSortedMap(sortedMap, clazz, clazz2);
    }

    public static SortedSet checkedSortedSet(SortedSet sortedSet, Class clazz) {
        return new CheckedSortedSet(sortedSet, clazz);
    }

    public static boolean disjoint(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!collection2.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static final List emptyList() {
        return Collections.EMPTY_LIST;
    }

    public static final Map emptyMap() {
        return Collections.EMPTY_MAP;
    }

    public static final Set emptySet() {
        return Collections.EMPTY_SET;
    }

    public static int frequency(Collection collection, Object object) {
        int n = 0;
        if (object == null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n += e == null ? 1 : 0;
            }
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n += object.equals(e) ? 1 : 0;
            }
        }
        return n;
    }

    public static Comparator reverseOrder(Comparator comparator) {
        return comparator == null ? Collections.reverseOrder() : new ReverseComparator(comparator);
    }

    private static class ReverseComparator
    implements Comparator,
    Serializable {
        static final long serialVersionUID = 1955474637275920642L;
        private final Comparator comparator;

        public ReverseComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object object, Object object2) {
            return this.comparator.compare(object2, object);
        }
    }

    private static class CheckedSortedMap
    extends CheckedMap
    implements SortedMap {
        static final long serialVersionUID = 4436469034535189432L;
        private final SortedMap map;

        public CheckedSortedMap(SortedMap sortedMap, Class clazz, Class clazz2) {
            super(sortedMap, clazz, clazz2);
            this.map = sortedMap;
        }

        public Comparator comparator() {
            return this.map.comparator();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new CheckedSortedMap(this.map.subMap(object, object2), this.keyType, this.valueType);
        }

        public SortedMap headMap(Object object) {
            return new CheckedSortedMap(this.map.headMap(object), this.keyType, this.valueType);
        }

        public SortedMap tailMap(Object object) {
            return new CheckedSortedMap(this.map.tailMap(object), this.keyType, this.valueType);
        }

        public Object firstKey() {
            return this.map.firstKey();
        }

        public Object lastKey() {
            return this.map.lastKey();
        }
    }

    private static class CheckedEntry
    implements Map.Entry {
        private Map.Entry entry;
        private Class valueType;

        public CheckedEntry(Map.Entry entry, Class clazz) {
            this.entry = entry;
            this.valueType = clazz;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object object) {
            return this.entry.setValue(_Class.cast(this.valueType, object));
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return CheckedEntry.equal(entry.getKey(), this.entry.getKey()) && CheckedEntry.equal(entry.getValue(), this.entry.getValue());
            }
            return false;
        }

        private static boolean equal(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    private static class CheckedEntrySet
    implements Set {
        private Set set;
        private Class valueType;

        public CheckedEntrySet(Set set, Class clazz) {
            this.set = set;
            this.valueType = clazz;
        }

        public int size() {
            return this.set.size();
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        public Iterator iterator() {
            final Iterator iterator = this.set.iterator();
            return new Iterator(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Map.Entry next() {
                    return new CheckedEntry((Map.Entry)iterator.next(), CheckedEntrySet.this.valueType);
                }

                public void remove() {
                    iterator.remove();
                }
            };
        }

        public Object[] toArray() {
            return this.toArray(new Object[this.set.size()]);
        }

        public Object[] toArray(Object[] objectArray) {
            Object[] objectArray2 = this.set.toArray(objectArray);
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = new CheckedEntry((Map.Entry)objectArray2[i], this.valueType);
            }
            return objectArray2;
        }

        public boolean add(Map.Entry entry) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            return this.set.remove(object);
        }

        public boolean containsAll(Collection collection) {
            return this.set.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            return this.set.retainAll(collection);
        }

        public boolean removeAll(Collection collection) {
            return this.set.removeAll(collection);
        }

        public void clear() {
            this.set.clear();
        }
    }

    private static class CheckedMap
    implements Map,
    Serializable {
        static final long serialVersionUID = 5466234636130576534L;
        private final Map map;
        final Class keyType;
        final Class valueType;

        public CheckedMap(Map map, Class clazz, Class clazz2) {
            this.map = map;
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        public Object get(Object object) {
            return this.map.get(object);
        }

        public Object put(Object object, Object object2) {
            return this.map.put(_Class.cast(this.keyType, object), _Class.cast(this.valueType, object2));
        }

        public Object remove(Object object) {
            return this.map.remove(object);
        }

        public void putAll(Map map) {
            Object[] objectArray = (Object[])Array.newInstance(this.keyType, map.size());
            Object[] objectArray2 = (Object[])Array.newInstance(this.valueType, map.size());
            int n = 0;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                try {
                    objectArray[n] = entry.getKey();
                    objectArray2[n] = entry.getValue();
                }
                catch (ArrayStoreException arrayStoreException) {
                    throw new ClassCastException();
                }
                ++n;
            }
            if (n != objectArray.length || n != objectArray2.length) {
                throw new ConcurrentModificationException();
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                this.map.put(objectArray[i], objectArray2[i]);
            }
        }

        public void clear() {
            this.map.clear();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Collection values() {
            return this.map.values();
        }

        public Set entrySet() {
            return new CheckedEntrySet(this.map.entrySet(), this.valueType);
        }
    }

    private static class CheckedSortedSet
    extends CheckedSet
    implements SortedSet {
        static final long serialVersionUID = 5682305462714452989L;
        private final SortedSet sortedSet;

        public CheckedSortedSet(SortedSet sortedSet, Class clazz) {
            super(sortedSet, clazz);
            this.sortedSet = sortedSet;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public SortedSet subSet(Object object, Object object2) {
            return new CheckedSortedSet(this.sortedSet.subSet(object, object2), this.type);
        }

        public SortedSet headSet(Object object) {
            return new CheckedSortedSet(this.sortedSet.headSet(object), this.type);
        }

        public SortedSet tailSet(Object object) {
            return new CheckedSortedSet(this.sortedSet.tailSet(object), this.type);
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }
    }

    private static class CheckedSet
    extends CheckedCollection
    implements Set {
        static final long serialVersionUID = 2655826269013753724L;

        public CheckedSet(Set set, Class clazz) {
            super(set, clazz);
        }

        public int hashCode() {
            return ((Object)this.collection).hashCode();
        }

        public boolean equals(Object object) {
            return ((Object)this.collection).equals(object);
        }
    }

    private static class CheckedList
    extends CheckedCollection
    implements List {
        static final long serialVersionUID = 7544634693847682845L;
        private final List list;

        public CheckedList(List list, Class clazz) {
            super(list, clazz);
            this.list = list;
        }

        public boolean addAll(int n, Collection collection) {
            return this.list.addAll(n, this.check(collection));
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public Object set(int n, Object object) {
            return this.list.set(n, _Class.cast(this.type, object));
        }

        public void add(int n, Object object) {
            this.list.add(n, _Class.cast(this.type, object));
        }

        public Object remove(int n) {
            return this.list.remove(n);
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(final int n) {
            return new ListIterator(){
                private ListIterator iterator;
                {
                    this.iterator = CheckedList.this.list.listIterator(n);
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public Object next() {
                    return this.iterator.next();
                }

                public boolean hasPrevious() {
                    return this.iterator.hasPrevious();
                }

                public Object previous() {
                    return this.iterator.previous();
                }

                public int nextIndex() {
                    return this.iterator.nextIndex();
                }

                public int previousIndex() {
                    return this.iterator.previousIndex();
                }

                public void remove() {
                    this.iterator.remove();
                }

                public void set(Object object) {
                    this.iterator.set(_Class.cast(CheckedList.this.type, object));
                }

                public void add(Object object) {
                    this.iterator.add(_Class.cast(CheckedList.this.type, object));
                }
            };
        }

        public List subList(int n, int n2) {
            return new CheckedList(this.list.subList(n, n2), this.type);
        }

        public boolean equals(Object object) {
            return ((Object)this.list).equals(object);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }
    }

    private static class CheckedCollection
    implements Collection,
    Serializable {
        static final long serialVersionUID = 6295674601624604684L;
        final Collection collection;
        final Class type;

        public CheckedCollection(Collection collection, Class clazz) {
            this.collection = collection;
            this.type = clazz;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.collection.toArray(objectArray);
        }

        public boolean add(Object object) {
            return this.collection.add(_Class.cast(this.type, object));
        }

        public boolean remove(Object object) {
            return this.collection.remove(object);
        }

        public boolean containsAll(Collection collection) {
            return this.collection.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            return this.collection.addAll(this.check(collection));
        }

        public boolean removeAll(Collection collection) {
            return this.collection.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            return this.collection.removeAll(collection);
        }

        public void clear() {
            this.collection.clear();
        }

        List check(Collection collection) {
            try {
                return Arrays.asList(collection.toArray((Object[])Array.newInstance(this.type, collection.size())));
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
        }
    }
}

