/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.release;

import biz.papercut.pcng.util.ObjectUtils;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseStationUser {
    private static final String FIELD_USER_NAME = "userName";
    private static final String FIELD_BALANCE = "balanceValue";
    private static final String FIELD_FORMATTED_BALANCE = "balance";
    private static final String FIELD_UNRESTRICTED = "unrestricted";
    private static final String FIELD_AUTHENTICATED = "authenticated";
    private static final String FIELD_IS_REGISTERED_USER = "isRegistered";
    private static final String FIELD_IS_RELEASE_STATION_MANAGER = "isReleaseStationManager";
    private static final String FIELD_CAN_CLOSE_RELEASE_STATION = "canCloseReleaseStation";
    private volatile String _userName;
    private volatile boolean _authenticated;
    private volatile boolean _isRegisteredUser;
    private volatile boolean _isReleaseStationManager;
    private volatile boolean _canCloseReleaseStation;
    private volatile boolean _anonymous;
    private volatile AccountDetails _accountDetails;
    private volatile String _authenticatedWithCardNumber;
    private volatile String _authenticatedWithCardPIN;

    public ReleaseStationUser(String userName) {
        this._userName = userName;
        this._authenticated = false;
        this._isRegisteredUser = false;
        this._isReleaseStationManager = false;
        this._canCloseReleaseStation = false;
        this._accountDetails = new AccountDetails();
    }

    public ReleaseStationUser(Hashtable<String, Object> data) {
        this._userName = (String)data.get(FIELD_USER_NAME);
        Boolean b = (Boolean)data.get(FIELD_AUTHENTICATED);
        this._authenticated = b != null && b != false;
        b = (Boolean)data.get(FIELD_IS_REGISTERED_USER);
        this._isRegisteredUser = b != null && b != false;
        b = (Boolean)data.get(FIELD_IS_RELEASE_STATION_MANAGER);
        this._isReleaseStationManager = b != null && b != false;
        b = (Boolean)data.get(FIELD_CAN_CLOSE_RELEASE_STATION);
        this._canCloseReleaseStation = b != null && b != false;
        AccountDetails acct = AccountDetails.create(data);
        this._accountDetails = acct != null ? acct : new AccountDetails();
    }

    public Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put(FIELD_USER_NAME, StringUtils.trimToEmpty((String)this.getUserName()));
        data.put(FIELD_AUTHENTICATED, this.isAuthenticated());
        data.put(FIELD_IS_REGISTERED_USER, this.isRegisteredUser());
        data.put(FIELD_IS_RELEASE_STATION_MANAGER, this.isReleaseStationManager());
        data.put(FIELD_CAN_CLOSE_RELEASE_STATION, this.isCanCloseReleaseStation());
        this.getAccountDetails().saveToHashtable(data);
        return data;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public boolean isAuthenticated() {
        return this._authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this._authenticated = authenticated;
    }

    public boolean isRegisteredUser() {
        return this._isRegisteredUser;
    }

    public void setRegisteredUser(boolean isRegisteredUser) {
        this._isRegisteredUser = isRegisteredUser;
    }

    public boolean isReleaseStationManager() {
        return this._isReleaseStationManager;
    }

    public void setReleaseStationManager(boolean isReleaseStationManager) {
        this._isReleaseStationManager = isReleaseStationManager;
    }

    public boolean isCanCloseReleaseStation() {
        return this._canCloseReleaseStation;
    }

    public void setCanCloseReleaseStation(boolean canCloseReleaseStation) {
        this._canCloseReleaseStation = canCloseReleaseStation;
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this._anonymous = anonymous;
    }

    public AccountDetails getAccountDetails() {
        return this._accountDetails;
    }

    public void setAccountDetails(AccountDetails accountDetails) {
        this._accountDetails = accountDetails;
    }

    public String getAuthenticatedWithCardNumber() {
        return this._authenticatedWithCardNumber;
    }

    public void setAuthenticatedWithCardNumber(String authenticatedWithCardNumber) {
        this._authenticatedWithCardNumber = authenticatedWithCardNumber;
    }

    public String getAuthenticatedWithCardPIN() {
        return this._authenticatedWithCardPIN;
    }

    public void setAuthenticatedWithCardPIN(String authenticatedWithCardPIN) {
        this._authenticatedWithCardPIN = authenticatedWithCardPIN;
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append("user-name", (Object)this._userName).append(FIELD_AUTHENTICATED, this._authenticated).append("registered", this._isRegisteredUser).append("manager", this._isReleaseStationManager).append("can-close", this._canCloseReleaseStation).append("anonymous", this._anonymous).append("account-details", (Object)this._accountDetails).append("auth-with-card-no", (Object)this._authenticatedWithCardNumber).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccountDetails {
        private double _balance;
        private String _formattedBalance = "";
        private boolean _restricted = true;

        public AccountDetails() {
        }

        public AccountDetails(Hashtable<String, Object> data) {
            String s;
            Boolean b;
            if (data == null || data.size() == 0) {
                return;
            }
            Double balance = (Double)data.get(ReleaseStationUser.FIELD_BALANCE);
            if (balance != null) {
                this.setBalance(balance);
            }
            if ((b = (Boolean)data.get(ReleaseStationUser.FIELD_UNRESTRICTED)) != null) {
                this.setRestricted(b);
            }
            if ((s = (String)data.get(ReleaseStationUser.FIELD_FORMATTED_BALANCE)) != null) {
                this.setFormattedBalance(s);
            }
        }

        public static AccountDetails create(Hashtable<String, Object> data) {
            if (data == null || data.size() == 0) {
                return null;
            }
            return new AccountDetails(data);
        }

        public double getBalance() {
            return this._balance;
        }

        public void setBalance(double balance) {
            this._balance = balance;
        }

        public String getFormattedBalance() {
            return this._formattedBalance;
        }

        public void setFormattedBalance(String formattedBalance) {
            this._formattedBalance = formattedBalance;
        }

        public boolean isRestricted() {
            return this._restricted;
        }

        public void setRestricted(boolean restricted) {
            this._restricted = restricted;
        }

        public void saveToHashtable(Hashtable<String, Object> data) {
            data.put(ReleaseStationUser.FIELD_BALANCE, this.getBalance());
            data.put(ReleaseStationUser.FIELD_FORMATTED_BALANCE, StringUtils.trimToEmpty((String)this.getFormattedBalance()));
            data.put(ReleaseStationUser.FIELD_UNRESTRICTED, this.isRestricted());
        }

        public Hashtable<String, Object> saveToHashtable() {
            Hashtable<String, Object> data = new Hashtable<String, Object>();
            this.saveToHashtable(data);
            return data;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ObjectUtils.TO_STRING_STYLE);
        }
    }
}

