/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkUtils {
    private static final Log logger = LogFactory.getLog(NetworkUtils.class);
    private static final Pattern REGEX_IP_ADDRESS = Pattern.compile("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b");
    private static final Pattern REGEX_STRIP_WIN_DOMAIN_PREFIX = Pattern.compile("[^\\\\]+?\\\\(.+)");
    private static final Pattern REGEX_STRIP_AT_DOMAIN_SUFFIX = Pattern.compile("([^@]+?)@.*");

    private NetworkUtils() {
    }

    public static String getComputerName() {
        String hostname = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostname = address.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (hostname == null || hostname.length() == 0) {
            hostname = System.getenv("COMPUTERNAME");
        }
        if (hostname == null || hostname.length() == 0) {
            hostname = System.getenv("HOSTNAME");
        }
        return hostname;
    }

    public static String stripDomainOffHostname(String hostname) {
        return StringUtils.substringBefore((String)hostname, (String)".");
    }

    public static String getIpAddress() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static Set<String> getAllIpAddresses() {
        HashSet<String> addresses = new HashSet<String>();
        String standardAddress = NetworkUtils.getIpAddress();
        if (standardAddress != null) {
            addresses.add(standardAddress);
        }
        try {
            InetAddress[] allAddresses;
            String hostname = InetAddress.getLocalHost().getHostName();
            for (InetAddress inetA : allAddresses = InetAddress.getAllByName(hostname)) {
                if (inetA.isLoopbackAddress()) continue;
                addresses.add(inetA.getHostAddress());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return addresses;
    }

    public static String getUserHomeDirectory() {
        File profileDir;
        String profileDirPath;
        String homeDir = System.getProperty("user.home");
        if (SystemUtils.IS_OS_WINDOWS && SystemUtils.isJavaVersionAtLeast((int)150) && StringUtils.isNotEmpty((String)(profileDirPath = System.getenv("USERPROFILE"))) && (profileDir = new File(profileDirPath)).exists()) {
            homeDir = profileDir.getAbsolutePath();
        }
        return homeDir;
    }

    public static void setupHTTPSToIgnoreHostnameAndTrustErrors() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslctx = SSLContext.getInstance("SSL");
        sslctx.init(null, new X509TrustManager[]{new TrustAllTrustManager()}, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslctx.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new TrustAllHostnameVerifier());
    }

    public static SSLSocketFactory getTrustAllSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslctx = SSLContext.getInstance("SSL");
        sslctx.init(null, new X509TrustManager[]{new TrustAllTrustManager()}, null);
        SSLSocketFactory sslsf = sslctx.getSocketFactory();
        return sslsf;
    }

    public static void setupHTTPSToIgnoreHostnameAndTrustErrors(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslctx = SSLContext.getInstance("SSL");
        sslctx.init(null, new X509TrustManager[]{new TrustAllTrustManager()}, null);
        conn.setSSLSocketFactory(sslctx.getSocketFactory());
        conn.setHostnameVerifier(new TrustAllHostnameVerifier());
    }

    public static boolean isIpV4Address(String ip) {
        if ((ip = StringUtils.trimToNull((String)ip)) == null) {
            return false;
        }
        return REGEX_IP_ADDRESS.matcher(ip).matches();
    }

    public static boolean isIpV6Address(String ip) {
        InetAddress a = NetworkUtils.constructInetAddressFromIPv6Format(ip);
        return a != null;
    }

    static boolean isPossibleIPv6Address(String ip) {
        return ip != null && ip.contains(":") && ip.length() >= 3;
    }

    public static boolean isIpAddress(String ip) {
        return NetworkUtils.isIpV4Address(ip) || NetworkUtils.isIpV6Address(ip);
    }

    public static String normalizeIpAddress(String ip) {
        if (NetworkUtils.isIpV4Address(ip = StringUtils.trimToEmpty((String)ip))) {
            return ip;
        }
        InetAddress a = NetworkUtils.constructInetAddressFromIPv6Format(ip);
        if (a != null) {
            return a.getHostAddress();
        }
        return null;
    }

    private static InetAddress constructInetAddressFromIPv6Format(String ip) {
        if (!NetworkUtils.isPossibleIPv6Address(ip = StringUtils.trimToNull((String)ip))) {
            return null;
        }
        String host = null;
        host = ip.charAt(0) == '[' && ip.charAt(ip.length() - 1) == ']' ? ip : "[" + ip + "]";
        int pos = host.indexOf("%");
        if (pos != -1) {
            host = host.substring(0, pos) + "]";
        }
        try {
            InetAddress[] a = InetAddress.getAllByName(host);
            if (a.length > 0) {
                return a[0];
            }
        }
        catch (Throwable t) {
            logger.debug((Object)("error converting ipv6 address: " + host + ". " + t.getMessage()), t);
        }
        return null;
    }

    public static String stripDomainOffUsername(String username) {
        if (username.indexOf(92) < 0 && username.indexOf(64) < 0) {
            return username;
        }
        String strippedUser = username;
        Matcher matcher = REGEX_STRIP_WIN_DOMAIN_PREFIX.matcher(strippedUser);
        if (matcher.find()) {
            strippedUser = matcher.group(1);
        }
        if ((matcher = REGEX_STRIP_AT_DOMAIN_SUFFIX.matcher(strippedUser)).find()) {
            strippedUser = matcher.group(1);
        }
        return strippedUser;
    }

    protected static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        protected TrustAllHostnameVerifier() {
        }

        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }

    protected static class TrustAllTrustManager
    implements X509TrustManager {
        protected TrustAllTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }
}

