/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.client.dialogrequest;

import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceDialogRequest
extends MessageDialogRequest {
    static final String TYPE_NAME = "ChoiceDialog";
    public static final String ARG_CHOICES = "choices";
    public static final String ARG_DEFAULT_CHOICE = "defaultChoice";
    public static final String ARG_FIELD_LABEL = "fieldLabel";

    public ChoiceDialogRequest(String uniqueID, Map<String, Object> optionalArgs, String message, Vector<String> choices, String ... buttons) {
        String[] stringArray;
        if (buttons.length == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "OK";
            stringArray = stringArray2;
            stringArray2[1] = "CANCEL";
        } else {
            stringArray = buttons;
        }
        super(uniqueID, optionalArgs, message, stringArray);
        if (choices.size() == 0) {
            throw new IllegalArgumentException("Require at least on choice in choice dialog.");
        }
        Vector<String> filteredChoices = new Vector<String>(choices.size());
        for (String choice : choices) {
            if (!StringUtils.isNotBlank((String)choice)) continue;
            filteredChoices.add(choice);
        }
        this._data.put(ARG_CHOICES, filteredChoices);
        this.loadOptionalArgs(optionalArgs);
    }

    public ChoiceDialogRequest(Hashtable<String, Object> data) {
        super(data);
        Vector v = (Vector)data.get(ARG_CHOICES);
        if (v == null) {
            v = new Vector(0);
        }
        this._data.put(ARG_CHOICES, v);
        this.loadOptionalArgs(data);
    }

    @Override
    protected Set<String> getSupportedArgNames() {
        Set<String> r = super.getSupportedArgNames();
        r.add(ARG_CHOICES);
        r.add(ARG_DEFAULT_CHOICE);
        r.add(ARG_FIELD_LABEL);
        return r;
    }

    private void loadOptionalArgs(Map<String, Object> optionalArgs) {
        this.loadOptionalArgString(ARG_DEFAULT_CHOICE, optionalArgs);
        this.loadOptionalArgString(ARG_FIELD_LABEL, optionalArgs);
    }

    public Vector<String> getChoices() {
        Vector v = (Vector)this._data.get(ARG_CHOICES);
        if (v == null) {
            return new Vector<String>();
        }
        return v;
    }

    public String getDefaultChoice() {
        String v = (String)this._data.get(ARG_DEFAULT_CHOICE);
        if (v == null) {
            return "";
        }
        return v;
    }

    public String getFieldLabel() {
        String v = (String)this._data.get(ARG_FIELD_LABEL);
        if (v == null) {
            return "";
        }
        return v;
    }

    @Override
    public String getDialogTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ClientDialogResponse parseResponse(Hashtable<String, Object> data) {
        return new ChoiceDialogResponse(data);
    }
}

