/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientUserConfigFromServer;
import biz.papercut.pcng.util.Checksum;
import biz.papercut.pcng.util.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class UserClientConfig {
    public static final int DEFAULT_CLIENT_TIMEOUT_SECS = 90;
    private boolean _debugEnabled = false;
    private boolean _silent = false;
    private boolean _neverRequestIdentity = false;
    private boolean _alwaysRequestIdentity = false;
    private boolean _multipleInstancesAllowed = false;
    private boolean _useStandardWinLAF = false;
    private boolean _disableGUIEffects = false;
    private boolean _hideBalance = false;
    private String _clientAccountsFile = null;
    private String _lockDirectory;
    private String _serverName;
    private String _serverIP;
    private int _serverPort;
    private String _userPageURL;
    private String _registerPageURL;
    private String _windowPosition = "top-right";
    private String _windowTitle = null;
    private int _backgroundColor = -1;
    private int _textColor = -1;
    private int _linkColor = -1;
    private int _linkHoverColor = -1;
    private int _timeoutSecs = 90;
    private String _authTTLValues = "";
    private Integer _authTTLDefault = null;
    private boolean _doPreAuthentication = false;
    private boolean _usePreAuthentication = false;
    private String _sharedSecretFile;
    private boolean _clearAuthentication = false;
    private String _userName;
    private String _displayUserName;
    private boolean _currentlyAuthenticated = false;
    private boolean _startMinimised = false;
    private ChargeToAccountType _defaultSelectedOption = null;
    private String _defaultSelectedAccount;
    private String _defaultSelectedAccountPin;
    private boolean _successfullyIdentified = false;
    private boolean _disallowExit = false;
    private boolean _disableTaskTray = false;
    private boolean _disableTaskTrayBalloonTips = false;
    private ClientPopupInfo _lastPopupSelection;
    private ClientGlobalConfigFromServer _serverGlobalConfig = new ClientGlobalConfigFromServer();
    private ClientUserConfigFromServer _serverUserConfig = new ClientUserConfigFromServer();

    public UserClientConfig() {
        this._userName = System.getProperty("user.name");
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                String netwareUsername = System.getenv("NWUSERNAME");
                String novellCNUsername = System.getenv("%CN");
                if (StringUtils.isNotBlank((String)netwareUsername)) {
                    this._userName = netwareUsername.replace("\\.", ".");
                } else if (StringUtils.isNotBlank((String)novellCNUsername)) {
                    this._userName = novellCNUsername.replace("\\.", ".");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._displayUserName = this._userName;
    }

    public boolean isSilent() {
        return this._silent;
    }

    public void setSilent(boolean silent) {
        this._silent = silent;
    }

    public boolean isAlwaysRequestIdentity() {
        return this._alwaysRequestIdentity;
    }

    public void setAlwaysRequestIdentity(boolean alwaysRequestIdentity) {
        this._alwaysRequestIdentity = alwaysRequestIdentity;
    }

    public boolean isNeverRequestIdentity() {
        return this._neverRequestIdentity;
    }

    public void setNeverRequestIdentity(boolean neverRequestIdentity) {
        this._neverRequestIdentity = neverRequestIdentity;
    }

    public boolean isDebugEnabled() {
        return this._debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this._debugEnabled = debugEnabled;
    }

    public ClientGlobalConfigFromServer getServerGlobalConfig() {
        return this._serverGlobalConfig;
    }

    public void setServerGlobalConfig(ClientGlobalConfigFromServer serverConfig) {
        this._serverGlobalConfig = serverConfig;
    }

    public String getUserPageURL() {
        return this._userPageURL;
    }

    public void setUserPageURL(String userPageURL) {
        this._userPageURL = userPageURL;
    }

    public String getRegisterPageURL() {
        return this._registerPageURL;
    }

    public void setRegisterPageURL(String registerPageURL) {
        this._registerPageURL = registerPageURL;
    }

    public boolean isStartMinimised() {
        return this._startMinimised;
    }

    public void setStartMinimised(boolean minimised) {
        this._startMinimised = minimised;
    }

    public ChargeToAccountType getDefaultSelectedOption() {
        return this._defaultSelectedOption;
    }

    public void setDefaultSelectedOption(ChargeToAccountType defaultSelectedOption) {
        this._defaultSelectedOption = defaultSelectedOption;
    }

    public String getDefaultSelectedAccount() {
        if (StringUtils.isNotBlank((String)this._defaultSelectedAccount)) {
            return this._defaultSelectedAccount;
        }
        if (this.getServerUserConfig() != null && StringUtils.isNotBlank((String)this.getServerUserConfig().getDefaultSharedAccountName())) {
            return this.getServerUserConfig().getDefaultSharedAccountName();
        }
        return null;
    }

    public void setDefaultSelectedAccount(String defaultSelectedAccount) {
        this._defaultSelectedAccount = defaultSelectedAccount;
    }

    public String getDefaultSelectedAccountPin() {
        return this._defaultSelectedAccountPin;
    }

    public void setDefaultSelectedAccountPin(String defaultSelectedAccountPin) {
        this._defaultSelectedAccountPin = defaultSelectedAccountPin;
    }

    protected String getUserName() {
        return this._userName;
    }

    protected void setUserName(String userName) {
        this._userName = userName;
    }

    public String getDisplayUserName() {
        return this._displayUserName;
    }

    public void setDisplayUserName(String displayUserName) {
        this._displayUserName = displayUserName;
    }

    public String getServerIP() {
        return this._serverIP;
    }

    public void setServerIP(String serverIP) {
        this._serverIP = serverIP;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public boolean isMultipleInstancesAllowed() {
        return this._multipleInstancesAllowed;
    }

    public void setMultipleInstancesAllowed(boolean multipleInstancesAllowed) {
        this._multipleInstancesAllowed = multipleInstancesAllowed;
    }

    public int getTimeoutSecs() {
        return this._timeoutSecs;
    }

    public void setTimeoutSecs(int timeoutSec) {
        this._timeoutSecs = timeoutSec;
    }

    public String getLockDirectory() {
        return this._lockDirectory;
    }

    public void setLockDirectory(String lockDirectory) {
        this._lockDirectory = lockDirectory;
    }

    public boolean isUseStandardWinLAF() {
        return this._useStandardWinLAF;
    }

    public void setUseStandardWinLAF(boolean useStandardWinLAF) {
        this._useStandardWinLAF = useStandardWinLAF;
    }

    public boolean isDisableGUIEffects() {
        return this._disableGUIEffects;
    }

    public void setDisableGUIEffects(boolean disableGUIEffects) {
        this._disableGUIEffects = disableGUIEffects;
    }

    public boolean isCurrentlyAuthenticated() {
        return this._currentlyAuthenticated;
    }

    public void setCurrentlyAuthenticated(boolean currentlyAuthenticated) {
        this._currentlyAuthenticated = currentlyAuthenticated;
    }

    public String getWindowPosition() {
        return this._windowPosition;
    }

    public void setWindowPosition(String windowPosition) {
        this._windowPosition = windowPosition;
    }

    public String getWindowTitle() {
        return this._windowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this._windowTitle = windowTitle;
    }

    public int getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        int color = UserClientConfig.parseRGBHexString(backgroundColor);
        if (color != -1) {
            this.setBackgroundColor(color);
        }
    }

    public int getTextColor() {
        return this._textColor;
    }

    public void setTextColor(int textColor) {
        this._textColor = textColor;
    }

    public void setTextColor(String textColor) {
        int color = UserClientConfig.parseRGBHexString(textColor);
        if (color != -1) {
            this.setTextColor(color);
        }
    }

    public int getLinkColor() {
        return this._linkColor;
    }

    public void setLinkColor(int linkColor) {
        this._linkColor = linkColor;
    }

    public void setLinkColor(String linkColor) {
        int color = UserClientConfig.parseRGBHexString(linkColor);
        if (color != -1) {
            this.setLinkColor(color);
        }
    }

    public void setLinkHoverColor(int linkHoverColor) {
        this._linkHoverColor = linkHoverColor;
    }

    public int getLinkHoverColor() {
        return this._linkHoverColor;
    }

    public void setLinkHoverColor(String linkHoverColor) {
        int color = UserClientConfig.parseRGBHexString(linkHoverColor);
        if (color != -1) {
            this.setLinkHoverColor(color);
        }
    }

    private static int parseRGBHexString(String rgbHexString) {
        int color;
        try {
            color = Integer.parseInt(rgbHexString, 16);
        }
        catch (Exception e) {
            return -1;
        }
        if (color < 0 || color > 0xFFFFFF) {
            return -1;
        }
        return color;
    }

    public String getServerIdHash() {
        return Checksum.getMD5Sum((String)("" + this._serverName + "-" + this._serverIP + "-" + this._serverPort));
    }

    public boolean isSuccessfullyIdentified() {
        return this._successfullyIdentified;
    }

    public void setSuccessfullyIdentified(boolean successfullyIdentified) {
        this._successfullyIdentified = successfullyIdentified;
    }

    public ClientPopupInfo getLastPopupSelection() {
        return this._lastPopupSelection;
    }

    public void setLastPopupSelection(ClientPopupInfo lastPopupSelection) {
        this._lastPopupSelection = lastPopupSelection;
    }

    public final boolean isDisallowExit() {
        return this._disallowExit;
    }

    public final void setDisallowExit(boolean disallowExit) {
        this._disallowExit = disallowExit;
    }

    public final ClientUserConfigFromServer getServerUserConfig() {
        return this._serverUserConfig;
    }

    public final void setServerUserConfig(ClientUserConfigFromServer serverUserConfig) {
        this._serverUserConfig = serverUserConfig;
    }

    public final String getClientAccountsFile() {
        return this._clientAccountsFile;
    }

    public final void setClientAccountsFile(String clientAccountsFile) {
        this._clientAccountsFile = clientAccountsFile;
    }

    public final String getAuthTTLValues() {
        return this._authTTLValues;
    }

    public final void setAuthTTLValues(String authTTLValues) {
        this._authTTLValues = authTTLValues;
    }

    public final Integer getAuthTTLDefault() {
        return this._authTTLDefault;
    }

    public final void setAuthTTLDefault(Integer authTTLDefault) {
        this._authTTLDefault = authTTLDefault;
    }

    public boolean isDisableTaskTray() {
        return this._disableTaskTray;
    }

    public void setDisableTaskTray(boolean disableTaskTray) {
        this._disableTaskTray = disableTaskTray;
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ObjectUtils.TO_STRING_STYLE);
    }

    public boolean isDisableTaskTrayBalloonTips() {
        return this._disableTaskTrayBalloonTips;
    }

    public void setDisableTaskTrayBalloonTips(boolean disableTaskTrayBalloonTips) {
        this._disableTaskTrayBalloonTips = disableTaskTrayBalloonTips;
    }

    public boolean isDoPreAuthentication() {
        return this._doPreAuthentication;
    }

    public void setDoPreAuthentication(boolean doPreAuthentication) {
        this._doPreAuthentication = doPreAuthentication;
    }

    public boolean isUsePreAuthentication() {
        return this._usePreAuthentication;
    }

    public void setUsePreAuthentication(boolean usePreAuthentication) {
        this._usePreAuthentication = usePreAuthentication;
    }

    public String getSharedSecretFile() {
        return this._sharedSecretFile;
    }

    public void setSharedSecretFile(String sharedSecretFile) {
        this._sharedSecretFile = sharedSecretFile;
    }

    public boolean isClearAuthentication() {
        return this._clearAuthentication;
    }

    public void setClearAuthentication(boolean clearAuthentication) {
        this._clearAuthentication = clearAuthentication;
    }

    public boolean isHideBalance() {
        return this._hideBalance;
    }

    public void setHideBalance(boolean hideBalance) {
        this._hideBalance = hideBalance;
    }
}

