/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientAccountFile;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.Component;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientAccountCache {
    private static final Log logger = LogFactory.getLog(ClientAccountCache.class);
    private static ClientAccountCache _instance;
    private final ServerConnection _connection;
    private final UserClientConfig _config;
    private List<ClientAccount> _accounts;
    private long _cacheLastModifiedTime = 0L;
    private CacheSource _source;
    private String _serverAssociatedUser = null;
    private boolean _dontCacheAccountsFromServer;
    private static final long FILE_TIME_PRECISION = 3000L;
    private static final String SYS_PROP_NO_ACCOUNT_CACHE = "user-client-no-account-cache";

    private ClientAccountCache(ServerConnection conn, UserClientConfig config) {
        this._connection = conn;
        this._config = config;
        this._dontCacheAccountsFromServer = StringUtils.isNotBlank((String)System.getProperty(SYS_PROP_NO_ACCOUNT_CACHE));
    }

    public synchronized List<ClientAccount> getUserAccounts(ClientPrintJob job, String username, Component parentDialog) {
        this.loadAccountsFromSiteAccountFileIfRequired(parentDialog);
        if (this._source != CacheSource.File) {
            this.loadAccountsFromServerIfRequired(job, username);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Available accounts: " + this._accounts));
        }
        return this._accounts;
    }

    private void loadAccountsFromSiteAccountFileIfRequired(Component parentDialog) {
        String clientAccountsFileName = this._config.getClientAccountsFile();
        if (StringUtils.isBlank((String)clientAccountsFileName)) {
            return;
        }
        File accountsFile = new File(clientAccountsFileName);
        clientAccountsFileName = accountsFile.getAbsolutePath();
        if (!accountsFile.exists()) {
            logger.debug((Object)("Accounts file does not exist: " + clientAccountsFileName));
            this.displayLoadFileError("Account file does not exist. File: " + clientAccountsFileName, parentDialog);
            if (this._source == CacheSource.File) {
                this.invalidateCache();
            }
            return;
        }
        long fileLastModified = accountsFile.lastModified();
        if (fileLastModified == 0L) {
            logger.debug((Object)("Cannot determine account last modified time: " + clientAccountsFileName));
            this.displayLoadFileError("Cannot determine whether the file has been recently modified.", parentDialog);
            if (this._source == CacheSource.File) {
                this.invalidateCache();
            }
            return;
        }
        if (this._accounts == null || (fileLastModified += 3000L) > this._cacheLastModifiedTime) {
            logger.debug((Object)("Accounts need to be reloaded from file: " + clientAccountsFileName));
            try {
                this._accounts = ClientAccountFile.readClientAccountFile((String)clientAccountsFileName, (int)3);
                this._cacheLastModifiedTime = fileLastModified;
                this._source = CacheSource.File;
                this._serverAssociatedUser = null;
            }
            catch (Exception e) {
                this.displayLoadFileError(e.getMessage(), parentDialog);
                if (this._source == CacheSource.File) {
                    this.invalidateCache();
                }
                logger.error((Object)("Problem occurred loading accounts from file: " + clientAccountsFileName + ". " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void displayLoadFileError(String detailedError, final Component parentComponent) {
        final String title = Messages.getString(ClientAccountCache.class, (String)"SelectAccount.error", (String[])new String[0]);
        final String msg = StringUtils.isBlank((String)detailedError) ? Messages.getString(ClientAccountCache.class, (String)"cannot-load-accounts-file", (String[])new String[0]) : Messages.getString(ClientAccountCache.class, (String)"cannot-load-accounts-file", (String[])new String[0]) + "\n\n" + detailedError;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogUtils.showInformationMessageDialog((Component)parentComponent, (String)title, (String)msg);
            }
        });
    }

    private void invalidateCache() {
        this._accounts = null;
        this._source = null;
        this._cacheLastModifiedTime = 0L;
        this._serverAssociatedUser = null;
    }

    private void loadAccountsFromServerIfRequired(ClientPrintJob job, String username) {
        username = StringUtils.trimToEmpty((String)username);
        if (this._dontCacheAccountsFromServer) {
            this._accounts = StringUtils.isBlank((String)username) ? this._connection.getAllSharedAccounts() : this._connection.getUserAccounts(job, username);
            this._cacheLastModifiedTime = 0L;
            this._serverAssociatedUser = username;
            this._source = CacheSource.Server;
        } else {
            long accountsLastModified = Long.parseLong(this._connection.getUserAccountsLastModifiedTime(job));
            if (this._accounts == null || accountsLastModified > this._cacheLastModifiedTime || this._source == CacheSource.Server && !StringUtils.equals((String)this._serverAssociatedUser, (String)username)) {
                logger.debug((Object)"Accounts need to be reloaded from server");
                this._accounts = StringUtils.isBlank((String)username) ? this._connection.getAllSharedAccounts() : this._connection.getUserAccounts(job, username);
                this._cacheLastModifiedTime = accountsLastModified;
                this._serverAssociatedUser = username;
                this._source = CacheSource.Server;
            } else {
                logger.debug((Object)("Using accounts cached at: " + new Date(this._cacheLastModifiedTime) + ", for user: " + this._serverAssociatedUser));
            }
        }
    }

    public static synchronized ClientAccountCache initialise(ServerConnection conn, UserClientConfig config) {
        if (_instance != null) {
            throw new IllegalStateException("Client account cache already initialized.");
        }
        _instance = new ClientAccountCache(conn, config);
        return _instance;
    }

    public static synchronized ClientAccountCache getInstance() {
        if (_instance == null) {
            throw new IllegalStateException("Client account cache is not initialized.");
        }
        return _instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheSource {
        Server,
        File;

    }
}

