/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.concurrent;

import biz.papercut.pcng.util.concurrent.PriorityCallable;
import biz.papercut.pcng.util.concurrent.PriorityRunnable;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Runnables {
    private Runnables() {
    }

    public static Thread startInDaemonThread(String threadName, Runnable runnable) {
        Thread t = new Thread(runnable, threadName);
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static PriorityRunnable priorityDecorator(final Runnable delegate, final int priority) {
        return new PriorityRunnable(){

            public int getPriority() {
                return priority;
            }

            public void run() {
                delegate.run();
            }
        };
    }

    public static <T> PriorityCallable<T> priorityDecorator(final Callable<T> delegate, final int priority) {
        return new PriorityCallable<T>(){

            @Override
            public int getPriority() {
                return priority;
            }

            @Override
            public T call() throws Exception {
                return delegate.call();
            }
        };
    }
}

