/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumberUtils {
    private NumberUtils() {
    }

    public static double round(double num, int decimalDigits) {
        return NumberUtils.round(num, decimalDigits, 4);
    }

    public static double round(double num, int decimalDigits, int roundingMode) {
        if (Double.isInfinite(num) || Double.isNaN(num)) {
            return num;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(num));
        bd = bd.setScale(decimalDigits, roundingMode);
        return bd.doubleValue();
    }

    public static ArrayList<Long> splitStringToLongList(String s, char delim) {
        ArrayList<Long> l = new ArrayList<Long>();
        int length = s.length();
        int cur = -1;
        if (length == 0) {
            return l;
        }
        while (true) {
            int next;
            if ((next = s.indexOf(delim, cur + 1)) == -1) {
                l.add(NumberUtils.stringToLong(s.substring(cur + 1)));
                break;
            }
            if (next == length - 1) {
                l.add(NumberUtils.stringToLong(s.substring(cur + 1, next)));
                break;
            }
            l.add(NumberUtils.stringToLong(s.substring(cur + 1, next)));
            cur = next;
        }
        return l;
    }

    private static Long stringToLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String generateRandomNumberString(int length) {
        StringBuilder s = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            s.append(random.nextInt(10));
        }
        return s.toString();
    }

    public static int minNonNegative(int ... values) {
        if (values == null) {
            return -1;
        }
        Integer min = null;
        for (int i : values) {
            if (i < 0 || min != null && i >= min) continue;
            min = i;
        }
        return min == null ? -1 : min;
    }
}

