/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.util.ApplicationException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MSWindowsUtils {
    private static final Log logger = LogFactory.getLog(MSWindowsUtils.class);
    private static boolean _initialised = false;
    private static boolean _initialiseFailed = false;

    private MSWindowsUtils() {
    }

    public static void addWindowListenerToBringWindowToFrontOnOpen(final Window window) {
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (!MSWindowsUtils.forceWindowToTop(window)) {
                    window.toFront();
                }
            }
        });
    }

    public static boolean forceWindowToTop(Window window) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        if (!MSWindowsUtils.ensureDllIsInitialised()) {
            return false;
        }
        MSWindowsUtils.forceWindowToTopInternal(window);
        return true;
    }

    private static synchronized boolean ensureDllIsInitialised() {
        if (!_initialised && !_initialiseFailed) {
            try {
                File clientLibDir = new File(UserClientUtils.getHomeDirectory(), "lib");
                String clientDllPath = new File(clientLibDir, "clientjni.dll").getCanonicalPath();
                logger.debug((Object)("Loading dll: " + clientDllPath));
                System.load(clientDllPath);
                File javaHomeBin = new File(System.getProperty("java.home"), "bin");
                File jawtDllFile = new File(javaHomeBin, "jawt.dll");
                String jawtDllPath = jawtDllFile.getCanonicalPath();
                if (!jawtDllFile.exists()) {
                    throw new ApplicationException("Cannot find jawt.dll here: " + jawtDllPath);
                }
                MSWindowsUtils.initialise(jawtDllPath);
                _initialised = true;
            }
            catch (Throwable t) {
                logger.error((Object)("Error loading clientjni.dll: " + t.getMessage()), t);
                _initialiseFailed = true;
            }
        }
        return _initialised;
    }

    private static native void initialise(String var0);

    private static native void forceWindowToTopInternal(Window var0);
}

