/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.ClassWriter;
import net.sf.retrotranslator.transformer.ClassLiteralVisitor;
import net.sf.retrotranslator.transformer.ClassSubstitutionVisitor;
import net.sf.retrotranslator.transformer.ConstructorSubstitutionVisitor;
import net.sf.retrotranslator.transformer.EnumVisitor;
import net.sf.retrotranslator.transformer.InheritanceVisitor;
import net.sf.retrotranslator.transformer.MemberSubstitutionVisitor;
import net.sf.retrotranslator.transformer.MessageLogger;
import net.sf.retrotranslator.transformer.SignatureStrippingVisitor;
import net.sf.retrotranslator.transformer.TransformerTools;
import net.sf.retrotranslator.transformer.VersionVisitor;

public class ClassTransformer {
    private boolean stripsign;

    public ClassTransformer(boolean bl) {
        this.stripsign = bl;
    }

    public byte[] transform(byte[] byArray, int n, int n2) {
        ClassReader classReader = new ClassReader(byArray);
        ClassWriter classWriter = new ClassWriter(true);
        ClassAdapter classAdapter = new VersionVisitor(new ClassSubstitutionVisitor((ClassVisitor)new MemberSubstitutionVisitor((ClassVisitor)new ConstructorSubstitutionVisitor((ClassVisitor)new InheritanceVisitor((ClassVisitor)new EnumVisitor((ClassVisitor)new ClassLiteralVisitor((ClassVisitor)classWriter)))))));
        if (this.stripsign) {
            classAdapter = new SignatureStrippingVisitor((ClassVisitor)classAdapter);
        }
        classReader.accept((ClassVisitor)classAdapter, true);
        return classWriter.toByteArray();
    }

    public void transform(File file, File file2, List list, MessageLogger messageLogger) {
        messageLogger.info("Transforming " + list.size() + " file(s)" + (file2.equals(file) ? " in " + file + "." : " from " + file + " to " + file2 + "."));
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            messageLogger.verbose(string);
            byte[] byArray = TransformerTools.readFileToByteArray(new File(file, string));
            byte[] byArray2 = this.transform(byArray, 0, byArray.length);
            String string2 = ClassSubstitutionVisitor.fixIdentifier(string);
            if (!string2.equals(string)) {
                list.set(i, string2);
                new File(file2, string).delete();
            }
            TransformerTools.writeByteArrayToFile(new File(file2, string2), byArray2);
        }
        messageLogger.info("Transformation of " + list.size() + " file(s) completed successfully.");
    }
}

